        DEVICE  ZXSPECTRUM48


;GZU_BASE        EQU     GZU+(GR_Y*64*16)+GR_X;+(256-192)/2*64+(64-32)/2

        include "src/k_consts.asm"
        org     0100h


stack:
        ld      sp,stack

start:
        call    HardWareINIT
        call    SET_LUT

        di

        ld  a, 6Ch 
        ld  (regbase1C+SYSREG), a

main_loop:

        call    next_iteration_init


;         ld      b,00010000b
;         call    _dbg_lut


        call    do_cls

;         ld      b,01000000b
;         call    _dbg_lut

        call    _effect
;         call    _main_show

;         ld      b,01010000b
;         call    _dbg_lut

        call    _vbl_

        call    update_lut

        jp  main_loop


_dbg_lut:
;         ret
        ld  a, 1Ch 
        ld  (regbase6C+SYSREG), a

        ld      hl, regbase1C+LUT
        ld      a,b
        ld      (hl),a

        ld  a, 6Ch 
        ld  (regbase1C+SYSREG), a
        ret

_vbl_:
        ld  a, 1Ch 
        ld  (regbase6C+SYSREG), a

.waitVBL:
        ld  a,(portbase1C+VISTS)  
        and     2
;         jp      z,.waitVBL    ;if z start from first screen line, no vbl
       jp      nz,.waitVBL    ;if z start from first screen line, no vbl

        ld  a, 6Ch 
        ld  (regbase1C+SYSREG), a
        ret
SET_LUT:
;     ei
;     halt
;
;  При записи в LUT биты 
;D0...D3 задают номер одной из 16; строк таблицы, а 
;D4...D7 - содержимое этой строки.

; D7 - задает интенсивность (яркость),
; D6 - наличие красного цвета, 
; D5 - зеленого цвета, 
; D4 - синего цвета.
; D3 - соответствует АЦЗУ, 
; D2 - слою ГЗУ #2, 
; D1 - слою ГЗУ #1,
; D0 - слою ГЗУ #0;  

;colors
;  00 - black
;  01 - green
;  10 - red
;  11 - yellow
;1 00 -  
;1 01 - blue    
;1 10 -     
;1 11 -     
;
;1    - aczu
;  
;esl colors
;                             xrgbC210
            ld      hl, regbase1C+LUT
            ld      (hl), 00000000b         
            ld      (hl), 00000001b         
            ld      (hl), 00000010b         
            ld      (hl), 00000011b         
            ld      (hl), 00000100b         
            ld      (hl), 00000101b         
            ld      (hl), 00000110b         
            ld      (hl), 00000111b         
            ld      (hl), 11111000b         
            ld      (hl), 11111001b         
            ld      (hl), 11111010b         
            ld      (hl), 11111011b         
            ld      (hl), 11111100b         
            ld      (hl), 11111101b         
            ld      (hl), 11111110b         
            ld      (hl), 11111111b         

            ld      (hl), 00100100b         

            ret
        include "src/3200_half_page_cleaner.asm"
        include "src/3200_effect.asm"
        include "src/k_hw_init.asm"
        include "src/dbg.asm"

        display /A,"END:", $
XEND:
        SAVEBIN "out/3200dots.COM",0x100,(XEND-0x100)        

