#! /usr/local/bin/ruby
require 'ap'


def read_data_from_file(path="3200.bin")
	offset=0x61a8
	data=File.open(path,"rb").read;
	_x=data.unpack("@#{0x61a8}C#{800}")
	_y=data.unpack("@#{0x64c8}C#{800}")
	[_x,_y]
end

def get_sin_tabs(steps,min,maxx,maxy)
	_x=[]
	_y=[]

	tmp_y=[]

	kx=(maxx-min)/2
	ky=(maxy-min)/2

	steps2=(steps*1.08).floor
	steps2+=1 if steps2.odd?

	step=(5*2*Math::PI)/steps2
	angle=0

	steps2.times do |x|
		tmp_y << (0.9*Math.sin(angle/10)*Math.sin(angle/10)*Math.sin(angle)*ky+ky+min).floor
		angle+=step
	end

	y0=(steps2-steps)/2


	#Math.sin(Math::PI/2) 
	step=(5*2*Math::PI)/steps
	angle=0
	steps.times do |x|
		_x << (Math.sin(angle/10)*Math.sin(angle)*kx+kx+min).floor
		angle+=step

		_y << tmp_y[y0+x]
	end

	_x.map{|v| raise if v>255}
	_y.map{|v| raise if v>255}

	[_x,_y]
end

def get_y_tab(ytab)
	out2=[]
	out2 << "ytab_size\tequ\t#{ytab.size}"
	out2 << ""

	out=[]
	ytab.each do |y|
		yy=0xc000+64*y
		raise "TOO LARGE y:#{y} -> #{"%x" % yy}" if yy>=0x10000
		raise "TOO SMALL y:#{y} -> #{"%x" % yy}" if yy<0xC000
		# p [y,"%04x" % yy]
		out << "\tdw\t0x#{"%04x" % yy}\t;#{y}"
	end
	out2 +=out[-20..-1]
	out2 << ";"
	out2 << "y_tab:"
	out2 +=out
	out2 << ";"
	out2 << ";"
	out2 << "; copy2"
	out2 << ";"
	out2 << ";"
	out2 +=out
	out2
end	

def generate_asm(x_table,label="rotator")

	out=[]
	out << "#{label}:" if label

	# shift_tab=[0x01,0x02,0x04,0x08,0x10,0x20,0x40,0x80]
	shift_tab=[0x01,0x02,0x04,0x08,0x10,0x20,0x40,0x80].reverse


	byte_val=-999
	byte_col=0
	byte_changes=0
	byte_reload=0
	byte_incdec=0


	# bit_val=0x5
	bit_val=nil

	bit_changes=0
	bit_shift=0
	bit_reload=0

	seq_cnt=0

	takt_count=0
	byte_count=0

	write_val=-1

	#convert x to [x,x_byte,x_bit]
	byte_x=x_table.map{|b| [b,b>>3,b&7]}

	out << "\tld\td,0"
	byte_x.each { |bb| 	
		
		x,byte,bit=bb

		out << ";%3d : %2d - %d" % bb

		if byte_val != byte
			unless byte_val == -1
				#print "\t\t\t\tB(#{byte_val}) :: #{byte_col} :: #{byte_val-byte} :: "
			end

			if (byte_val-byte).abs == 1
				byte_incdec+=1
				# print "incdec"
				if byte_val-byte > 0
					out << "\tdec\te"
				else
					out << "\tinc\te"
				end
				takt_count+=5
				byte_count+=1

			else 
				byte_reload+=1
				out << "\tld\te,0x#{"%02x" % byte}"
				# print "reload"
				takt_count+=7
				byte_count+=2
			end
			# puts

			byte_val=byte
			byte_col=1
			byte_changes+=1
		else
			byte_col+=1
		end

		bit_bit=shift_tab[bit]

		# p [:x0,bit_val,bit]
		if bit_val.nil?
			write_val=bit_bit
			bit_val=bit
			out << "\tld\ta,0x#{"%02x" % bit_bit}"
		elsif bit_val != bit
			unless bit_val == -1
				# print "\t\t\t\t\t\tBit(#{bit_val}) - #{bit_changes}\t\t:"
			end

			sh_l=shift_tab[(bit_val-1)&7]
			sh_r=shift_tab[(bit_val+1)&7]

			if ((bit_bit == sh_l) || (bit_bit == sh_r))
				bit_shift+=1
				# print "shift"
				# p [:bshift,bit_val-bit,bit_shift]
				if bit_bit == sh_l
					out <<"\trlca"
					write_val=(write_val<<1) & 0xff
					write_val=1 if write_val==0
				else
					out <<"\trrca"
					write_val=(write_val>>1) & 0xff
					write_val=0x80 if write_val==0
				end
				takt_count+=4
				byte_count+=1
			else
				write_val=bit_bit
				# p [:r,bit_val,sh_l,sh_r]
				bit_reload+=1
				# p [:breload,bit_reload]
				# print "reload"
				out << "\tld\ta,0x#{"%02x" % bit_bit}"
				takt_count+=7
				byte_count+=2

			end
			# puts

			bit_val=bit
			bit_changes+=1
		end

		out << "\tpop\thl"
		out << "\tadd\thl,de"
		out << "\tld\t(hl),a;\t#{"%02x" % write_val}"
		takt_count+=27
		byte_count+=3

		# p [:d,byte_val,byte_col]
	}
	# puts
	# p [:byte_changes,byte_changes,byte_reload,byte_incdec]
	# p [:bit_changes,bit_changes,bit_reload,bit_shift]


	# puts "\t;TOTAL_TAKTS=#{takt_count}"
	# puts "\t;TOTAL_BYTES=#{byte_count}"
	# out << "\tret"
	out << "\tjp\tx_ret"

	out << ";src takts/bytes #{calc_tact(out)}"
	out
end

def optimize_single_ld(body)

	def pass_1(body)
		cntr=[]
		use_cntr=0
		_idx=0
		body.each_with_index do |line,idx|
				# ld	a,0x80
				# ld	(hl),a;	80
				case line
				when /ld\s+a,0x(..)/
					use_cntr=0
					_idx=idx
					cntr[_idx]=use_cntr
				when /ld\s+\(hl\),a/
					raise "empty idx #{_idx}" unless cntr[_idx]
					cntr[_idx]+=1
				end
		end
		cntr
	end

	def pass_2(body,usage_array)
		replace_count=nil
		value=nil
		out=[]
		body.each_with_index do |line,idx|
			out_line=line
			case line
			when /ld\s+a,(0x..)/
				value=$1
				cnt=usage_array[idx]
				out_line+=";#{cnt}"
				if cnt==1
					replace_count=cnt
					out_line=""#;####{out_line}"
				end
			when /ld\s+\(hl\),a/
				if replace_count
					out_line=[""]#;***#{out_line}"]
					out_line<<"\tld\t(hl),#{value}\n"
					# out_line<<";***\n"
					replace_count=nil
				end
			end
			out += [*out_line].flatten
		end
		out
	end	

	usage_array=pass_1(body)
	out=pass_2(body,usage_array)

	out << ";opt takts/bytes #{calc_tact(out)}"

	out
end

def calc_tact(src)
	takt=0
	bytes=0
	src.each do |line|
	# pop	hl 	;10
	# ld	de,0 	;10
	# add	hl,de 	;10
	# ld	(hl),1 	;10
	# ld 	a,1	;7
	# ld 	e,1 	;7	
	# inc/dec de 	;5
	# rrca/rlca 	;4


		case line
		when /^\s*$/
			#noop
		when /^\s*;/
			#noop
		when /^\S+:$/
			#noop
		when /^\s+pop\s+(hl|de|bc|af)/
			takt+=10
			bytes+=1
		when /^\s+ld\s+(hl|de|bc|af|sp),/
			takt+=10
			bytes+=3
		when /^\s+ld\s+(a|b|c|d|e|h|l),/
			takt+=7
			bytes+=2
		when /^\s+add\s+(hl|de|bc|sp),/
			takt+=10
			bytes+=1
		when /^\s+ld\s+\(hl\),(a|b|c|d|e|h|l)/
			takt+=7
			bytes+=1
		when /^\s+ld\s+\(hl\),0x/
			takt+=10
			bytes+=2
		when /^\s+(inc|dec)\s+(a|b|c|d|e|h|l)/
			takt+=5
			bytes+=1
		when /^\s+(inc|dec)\s+(hl|de|bc)/
			takt+=5
			bytes+=1
		when /^\s+r(r|l)ca?/
			takt+=5
			bytes+=1
		when /^\s+ret/
			takt+=10
			bytes+=1
		when /^\s+jp\s+.*/
			takt+=10
			bytes+=1
		else
			raise "unsopported cmd '#{line}'"
		end
	end
	[takt,bytes]
end




# def test_size(name,xtab)
# 	asm=generate_asm(xtab)
# 	s1=calc_tact(asm)
# 	s2=calc_tact(optimize_single_ld(asm))

# 	p [name,s1,s2,[s1[0]-s2[0],s1[1]-s2[1]]]	
# end
# # test_size(:xtab2x,xtab2x)
# # test_size(:xtab__,xtab)

# def Param_tosser(xtab)
# 	opt_tab=[]
# 	fl=false
# 	(0).step(2,2/8.0) do |k|
# 		# puts "#{k}"
# 		xtab2x=xtab.map{|x| (x*k).to_int}
# 		asm=generate_asm(xtab2x)
# 		# puts "-"*80
# 		# p xtab2x
# 		# puts "-"*80
# 		# puts asm
# 		# puts "="*80
# 		# t1,b1=calc_tact(asm)
# 		t1,b1=calc_tact(optimize_single_ld(asm))
# 		dt=0;db=0
# 		if fl
# 			dt=t1-opt_tab[0][0]
# 			db=b1-opt_tab[0][1]
# 		end
# 		fl=true
# 		opt_tab << [t1,b1,dt,db,k*1000]
# 	end
# 	opt_tab.sort!{|a,b| a[0] <=> b[0]}
# 	puts opt_tab.map{|v| v.map{|vv| "%5d" % vv}.join("\t")}

# 	# # xtab2x=xtab.map{|x| x*2}
# end



