#! /usr/local/bin/ruby
require '../rb/3200-asmgen_code.rb'

#xtab,ytab=read_data_from_file("../rb/3200.bin")

size=800#xtab.size

xtab,ytab=get_sin_tabs(size,6,249,128)

ytab2x=ytab.map{|y| (y*2).to_int}

ytab2x.each_with_index{|v,idx| raise "Y -> #{v} : #{idx}" if v>255}

asm_y=get_y_tab(ytab2x)

puts asm_y

kx=[]
0.step(2,2/12.0) {|k| kx<<k}
kx[0]=0.05

kx.each_with_index do |k,idx|
	xtab2x=xtab.map{|x| (x*k).to_int}
	#recenter
	xsize=xtab2x.max-xtab2x.min
	dx=-xtab2x.min+(511-xsize)/2
	xtab2x=xtab2x.map{|x| x+=dx }
	# p [xtab2x.min,xtab2x.max,xtab2x.max-xtab2x.min]

	xtab2x.each_with_index{|v,idx| raise "X -> #{v} : #{idx}" if v>512}

	asm_x=optimize_single_ld(generate_asm(xtab2x,"rotator_#{"%02d" % idx}"))
	puts asm_x
end



