        DEVICE  ZXSPECTRUM48

dbg_flag    equ     0x5c+1

        include "src-sintab/k_consts.asm"
        org     0100h

;run with any param for debug
;xpark d

        ld      a,(dbg_flag)
        sub     0x20
        ld      (dbg_flag),a


        jp  start
        include "src/dbg.asm"
start:        
stack:
        ld      sp,stack

        call    HardWareINIT
        call    SET_LUT

        di

        ld  a, 6Ch 
        ld  (regbase1C+SYSREG), a

main_loop:

        call    next_iteration_init

        lut_dbg      00010000b

        call    do_cls

        lut_dbg      01000000b

        call    _effect

        lut_dbg      01010000b

        call    _vbl_

        call    update_lut

        jp  main_loop


_vbl_:
        ld  a, 1Ch 
        ld  (regbase6C+SYSREG), a

.waitVBL:
        ld  a,(portbase1C+VISTS)  
        and     2
;         jp      z,.waitVBL    ;if z start from first screen line, no vbl
       jp      nz,.waitVBL    ;if z start from first screen line, no vbl

        ld  a, 6Ch 
        ld  (regbase1C+SYSREG), a
        ret
SET_LUT:
;     ei
;     halt
;
;  При записи в LUT биты 
;D0...D3 задают номер одной из 16; строк таблицы, а 
;D4...D7 - содержимое этой строки.

; D7 - задает интенсивность (яркость),
; D6 - наличие красного цвета, 
; D5 - зеленого цвета, 
; D4 - синего цвета.
; D3 - соответствует АЦЗУ, 
; D2 - слою ГЗУ #2, 
; D1 - слою ГЗУ #1,
; D0 - слою ГЗУ #0;  

;colors
;  00 - black
;  01 - green
;  10 - red
;  11 - yellow
;1 00 -  
;1 01 - blue    
;1 10 -     
;1 11 -     
;
;1    - aczu
;  
;esl colors
;                             xrgbC210
            ld      hl, regbase1C+LUT
            ld      (hl), 00000000b         
            ld      (hl), 00000001b         
            ld      (hl), 00000010b         
            ld      (hl), 00000011b         
            ld      (hl), 00000100b         
            ld      (hl), 00000101b         
            ld      (hl), 00000110b         
            ld      (hl), 00000111b         
            ld      (hl), 11111000b         
            ld      (hl), 11111001b         
            ld      (hl), 11111010b         
            ld      (hl), 11111011b         
            ld      (hl), 11111100b         
            ld      (hl), 11111101b         
            ld      (hl), 11111110b         
            ld      (hl), 11111111b         

            ret
        include "src-sintab/3200_half_page_cleaner.asm"
        include "src-sintab/3200_effect.asm"
        include "src-sintab/k_hw_init.asm"
;         include "src/dbg.asm"

        display /A,"END:", $
XEND:
        SAVEBIN "out/3200dots.COM",0x100,(XEND-0x100)        

