
        macro lut_dbg _color_
        	ld 	b,_color_
        	call 	_dbg_lut
        endm

_dbg_lut:
;         ret
	ld 	a,(dbg_flag)
	or 	a
	ret 	z

        ld  a, 1Ch 
        ld  (regbase6C+SYSREG), a

        ld      hl, regbase1C+LUT
        ld      a,b
        ld      (hl),a

        ld  a, 6Ch 
        ld  (regbase1C+SYSREG), a
        ret

XADDR:	DW 	0xFC00

SET_ADDR:
	ld 	(XADDR),hl
	ret

INC_ADDR:
	push 	hl
	ld 	hl,(XADDR)
	inc 	hl
	ld 	(XADDR),hl
	pop 	hl
	ret

put:
	push    af
	push    bc
	push    de
	push    hl
	ld 	hl,(XADDR)
	ld 	(hl),a
	call 	INC_ADDR
	pop     hl
	pop     de
	pop     bc
	pop     af
	ret


puthl:
	ld 	a,h
	call 	puthex
	ld 	a,l
	call 	puthex
	ret

puthex:
	push    af
	push    bc
	push    de
	push    hl


	push    af
	and     0f0h
	rrca
	rrca
	rrca
	rrca
	call    nibl
	pop     af
	call    nibl

	pop     hl
	pop     de
	pop     bc
	pop     af
	ret

nibl:
	push    af
	push    bc
	push    de
	push    hl

	and     0x0f
	add     a,90h
	daa
	adc     a,40h
	daa
	call    put

	pop     hl
	pop     de
	pop     bc
	pop     af
	ret






spc:
	ld  a,' '
	jp  put

crlf:
	ld  a,0dh
	call    put
	ld  a,0ah
	jp  put
