#pragma option -a-

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <string.h>
#include <dos.h>


#define CPM_TYPE        0x02        // ⨯ ࠧ CP/M
#define MAX_DIR         0x10        // ᨬ쭮 ⢮ ஢  ४

#define MAX_WAIT_TIME   18*1        // . ६  ⢥  HDD

#define DI              asm cli
#define EI              asm sti

typedef unsigned char   UINT8;
typedef unsigned int    UINT16;
typedef unsigned long   UINT32;

typedef signed char     INT8;
typedef signed int      INT16;
typedef signed long     INT32;



typedef struct {
    UINT8   Active;     // 0x80 - active partion
    UINT8   Side;       // head
    UINT16  Addr;       // cylinder/sector
    UINT8   Type;       // type partion
    UINT8   SideEnd;
    UINT16  AddrEnd;
    UINT32  RelAddr;    // ⭮⥫  
    UINT32  Size;       // ࠧ ࠧ  ᥪ
} PARTION;

typedef struct {
    char    Active;     // ਧ ⢨⥫쭮 
    char    Name[18];
    char    NumChan;
    char    NumDev;
    UINT16  Head;
    UINT16  Cyl;
    UINT16  Sec;
    UINT32  Size;       // in sectors
} DEVICE;

typedef struct {
    UINT16  SPT;        // sectors per track
    UINT8   BSH;        // block shift
    UINT8   BLM;        // block mask
    UINT8   EXM;        // extent mask
    UINT16  DSM;        // disk maximum
    UINT16  DRM;        // directory maximum
    UINT8   AL0;        // allocation vector
    UINT8   AL1;
    UINT16  CKS;        // checksum vector size
    UINT16  OFF;        // track offset
    UINT8   res;
} DPB;

typedef struct {
    char    Sign[8];    // ᨣ "CP/M"
    DPB     dpb;
    UINT8   res[486];   // १
    UINT16  parSign;    // 0xAA55;
} SYSSEC;

typedef struct {
    char    user;
    char    name[8];
    char    ext[3];
    char    ex;
    UINT16  res;
    char    rc;
    UINT16  map[8];
} DIRREC;

typedef struct {
    int     lastDisk;
    UINT32  AbsAddr[32];
} DISKS;


#define DIRINSEC        (512 / sizeof(DIRREC))


/*
==============================================================================

                                 DISK IO

==============================================================================
*/

static UINT16 BaseAddr[2] = {0x1F0, 0x170};


char wait_nBSY(UINT16 base)
{
    UINT32      time;
    UINT32 far *timeptr;
    UINT8       b;

    timeptr = (UINT32 far*) MK_FP(0, 0x46C);
    time =  *timeptr + MAX_WAIT_TIME;
    while (time >= *timeptr) {
        b = inportb(base+7);
        if ((b & 0x80) == 0)
            return -1;
    }
    return 0;
}

char wait_DRDY(UINT16 base)
{
    UINT32      time;
    UINT32 far *timeptr;
    UINT8       b;

    timeptr = (UINT32 far *) MK_FP(0, 0x46C);
    time =  *timeptr + MAX_WAIT_TIME;
    while (time >= *timeptr) {
        b = inportb(base+7);
        if ((b & 0xC0) == 0x40)
            return -1;
    }
    return 0;
}

char wait_DRQ(UINT16 base)
{
    UINT32      time;
    UINT32 far *timeptr;
    UINT8       b;

    timeptr = (UINT32 far *) MK_FP(0, 0x46C);
    time =  *timeptr + MAX_WAIT_TIME;
    while (time >= *timeptr) {
        b = inportb(base+7);
        if ((b & 0x88) == 0x08)
            return -1;
    }
    return 0;
}



char ide_SendCmd(UINT8 Chan, UINT8 Device, UINT32 Sector, UINT8 Cmd)
{
    UINT16 base;

    base = BaseAddr[Chan];
    //  ⮢ ன⢠
    if (!wait_nBSY(base))
        return 0;
    // 롨ࠥ ன⢮
    outportb(base+6, (Device << 4) | 0xA0);
    if (!wait_DRDY(base))
        return 0;
    // 㦠 ࠬ   ॣ
    DI;
    outportb(base+1, 0);            // feature register must be 0
    outportb(base+2, 1);            // sector count
    outportb(base+3, Sector & 0xFF);
    outportb(base+4, (Sector >> 8) & 0xFF);
    outportb(base+5, (Sector >> 16) & 0xFF);
    outportb(base+6, ((Sector >> 24) & 0xFF) | (Device << 4) | 0xE0);
    outportb(base+7, Cmd);
    EI;
    return -1;
}

char ide_ReadSector(UINT8 Chan, UINT8 Device, UINT32 Sector, void far *buff)
{
    int         i;
    UINT16      base = BaseAddr[Chan];
    UINT16 far *b;

    if (!ide_SendCmd(Chan, Device, Sector, 0x20))
        return 0;
    if (!wait_DRQ(base))
        return 0;
    b = (UINT16 far *) buff;
    DI;
    for (i=0; i<256; i++)
    {
        *b = inpw(base);
        b++;
    }
    EI;
    wait_nBSY(base);
    return -1;
}

char ide_WriteSector(UINT8 Chan, UINT8 Device, UINT32 Sector, void far *buff)
{
    int         i;
    UINT16      base = BaseAddr[Chan];
    UINT16 far *b;

    if (!ide_SendCmd(Chan, Device, Sector, 0x30))
        return 0;
    if (!wait_DRQ(base))
        return 0;
    b = (UINT16 far *) buff;
    DI;
    for (i=0; i<256; i++)
    {
        outpw(base, *b);
        b++;
    }
    EI;
    wait_nBSY(base);
    return -1;
}



char ide_Identify(UINT8 Chan, UINT8 Device, void far *buff)
{
    int         i;
    UINT16      base =  BaseAddr[Chan];
    UINT16 far *b;

    if (!ide_SendCmd(Chan, Device, 0, 0xEC))
        return 0;
    if (!wait_DRQ(base))
        return 0;
    if (inp(base+7) & 0x01 != 0)
        return 0;
    b = (UINT16 far *) buff;
    DI;
    for (i=0; i<256; i++)
    {
        *b = inpw(base);
        b++;
    }
    EI;
    wait_nBSY(base);
    return -1;
}



/*
==============================================================================

                                    HDD

==============================================================================
*/

char hdd_CheckSign(char buff[])
{
    if ((buff[0x1FE] != 0x55) || (buff[0x1FF] != 0xAA))
        return 0;
    else
        return -1;
}


//
// ᪠஢ SMBR  । ᪨ ᪮ CP/M
//  relAdd - ⭮⥫   砫 ࠧ SMBR
//
void hdd_ParseSMBR(DEVICE *p, UINT32 relAddr, DISKS *dsk)
{
    PARTION    *par;
    PARTION    *nxt;
    UINT8       buff[512];
    UINT32      base = relAddr;     // ᮫  砫 SMBR

    do
    {
        // 㦠 SMBR
        if (!ide_ReadSector(p->NumChan, p->NumDev, relAddr, &buff))
        {
            printf("    *error* - can't read SMBR at 0x%08lX!\n", relAddr);
            return;
        }
        if (!hdd_CheckSign(buff))
        {
            printf("    *error* - SMBR at 0x%08lX is corrupt!\n", relAddr);
            return;
        }
        par = (PARTION *) &buff[0x1BE];
        nxt = (PARTION *) &buff[0x1CE];
        if (par->Type == CPM_TYPE)
        {
            dsk->lastDisk++;
            dsk->AbsAddr[dsk->lastDisk] = par->RelAddr+relAddr;
            printf("    -found CP/M disk [%c]   size: %12lu Kb\n", (dsk->lastDisk+'A'), par->Size / 2);
        }
        relAddr = nxt->RelAddr+base;
    } while (nxt->Type != 0);

}


//
//  ᪨ CP/M   ७ ࠧ dos
//
char hdd_FindDisks(DEVICE *p, DISKS *dsk)
{
    PARTION    *par;
    UINT8       buff[512];
    int         i;

    // 㦠 MBR
    if (!ide_ReadSector(p->NumChan, p->NumDev, 0, &buff))
    {
        printf("  *error* - can't read MBR!\n");
        return 0;
    }
    if (!hdd_CheckSign(buff))
    {
        printf("  *error* - MBR is corrupt!\n");
        return 0;
    }

    dsk->lastDisk = -1;
    // ᪠㥬 樨  MBR
    par = (PARTION *) &buff[0x1BE];
    for(i = 0; i < 4; i++)
    {
        if (par->Active)
        {
            printf("    -skip primary DOS partion.\n");
        } else {
            if ((par->Type == 0x05) || (par->Type == 0x0C) || (par->Type == 0xF))
            {
                hdd_ParseSMBR(p, par->RelAddr, dsk);
            }
        }
        par++;
    }
    return -1;
}



/*
==============================================================================

                                   COPY

==============================================================================
*/


//  ⥪饣 ᪮ ᪠ CP/M
UINT32      StartSector;        // 砫 ᥪ ᪠
UINT16      NumBlock;           // ࠧ ᪠  
UINT16      BlockSize;          // ࠧ 
char        BlockMap[1024];     //  ᢮ ஢
char        DirMap[1024];       //  ४ ᥩ
UINT16      NumDir;             // . ⢮ ᥩ  ४ਨ


// 砥  
void disk_SetBlock(UINT16 nBlock)
{
    BlockMap[nBlock / 8] |= (1 << (nBlock % 8));
}

// 砥  ᢮
void disk_FreeBlock(UINT16 nBlock)
{
    BlockMap[nBlock / 8] &= (~(1 << (nBlock % 8)));
}

// 頥  : 0 - ᢮, >0 - 
char disk_CheckBlock(UINT16 nBlock)
{
    return BlockMap[nBlock / 8] & (1 << (nBlock % 8));
}

// 砥 ४  ⮩
void disk_SetDir(UINT16 nDir)
{
    DirMap[nDir/8] |= (1 << (nDir % 8));
}

// 砥 ४  ᢮
void disk_FreeDir(UINT16 nDir)
{
    DirMap[nDir/8] &= (~(1 << (nDir % 8)));
}

// 頥  ४୮ : 0 - ᢮, >0 - 
char disk_CheckDir(UINT16 nDir)
{
    return DirMap[nDir/8] & (1 << (nDir % 8));
}


//
// ⠢     ४ ᥩ
//
char disk_ScanDir(DEVICE *p)
{
    UINT16  i, j, k;
    DIRREC  dir[DIRINSEC];

    memset(&BlockMap, 0, sizeof(BlockMap));
    memset(&DirMap, 0, sizeof(DirMap));
    // 砥  ४਩
    for (i = 0; i < NumDir / (BlockSize/sizeof(DIRREC)); i++)
        disk_SetBlock(i);
    // ᪠㥬 ४਩  砥  䠩
    for (i = 0; i < ((NumDir+(DIRINSEC-1)) / DIRINSEC); i++)
    {
        if (!ide_ReadSector(p->NumChan, p->NumDev, StartSector + i, &dir))
        {
            printf("    *error* - can't read directory sector at 0x%08lX\n", StartSector+i);
            return 0;
        }
        for (j = 0; j < DIRINSEC; j++)          // 横  
        {
            if (dir[j].user != 0xE5)
            {
                disk_SetDir(i*DIRINSEC+j);
                for (k = 0; k < 8; k++)         // 横    
                    disk_SetBlock(dir[j].map[k]);
            }
        }
    }
    return -1;
}


//
// "砥"  CP/M  쭥襩 ࠡ  
//
char disk_Mount(DEVICE *p, UINT32 AbsSec)
{
    SYSSEC  sec;

    // 뢠  ࠬ஢ ᪠
    if (!ide_ReadSector(p->NumChan, p->NumDev, AbsSec, &sec))
    {
        printf("  *error* - can't read sector at 0x%08lX!\n", AbsSec);
        return 0;
    }
    if ((!hdd_CheckSign((char *) &sec)) || (memcmp(sec.Sign, "CP/M    ", 8) != 0))
    {
        printf("  *error* - disk is not CP/M!\n");
        return 0;
    }
    NumBlock  = sec.dpb.DSM + 1;
    BlockSize = (sec.dpb.BLM + 1) * 128;
    NumDir    = sec.dpb.DRM + 1;
    StartSector = ((sec.dpb.OFF*sec.dpb.SPT)*128) / 512 + AbsSec + 1;
    // ⠢塞     ४਩
    return disk_ScanDir(p);
}


//
//    䠩  ଠ, ᯮ㥬  ᪥[11]
//
void disk_FrmName(char *filename, char *dskname)
{
    char drive[_MAX_DRIVE];
    char dir[_MAX_DIR];
    char fname[_MAX_FNAME];
    char ext[_MAX_EXT];
    char *e;

    memset(dskname, 0x20, 11);
    _splitpath(filename, drive, dir, fname, ext);
    strupr(fname);
    strupr(ext);
        e = &ext[0];
    if (*e == '.')
        e++;
    memcpy(dskname, fname, strlen(fname));
    memcpy(dskname+8, e, strlen(e));
}

char *disk_GetPath(char *fullname)
{
    char drive[_MAX_DRIVE];
    char dir[_MAX_DIR];
    char fname[_MAX_FNAME];
    char ext[_MAX_EXT];
    char *m;
    _splitpath(fullname, drive, dir, fname, ext);
    m = (char *) malloc(strlen(drive) + strlen(dir)+sizeof(char));
    if (m)
    {
        strcpy(m, drive);
        strcat(m, dir);
    }
    return m;
}



//
// 뤥 nBlocks ᢮  ४ 
//
char disk_AllocBlock(DIRREC *dir, UINT16 nBlocks)
{
    DIRREC *r;
    UINT16  i, j, k;
    UINT16  nDirs;

    r = dir;
    nDirs = ((nBlocks + 7) / 8);
    for (i = 0; i < nDirs; i++)             //   ४୮ 
    {
        for (j = 0; j < 8; j++)             //    ᨢ .  ४୮ 
        {
            r->map[j] = 0;
            if (!nBlocks)
                continue;
            // ᪠㥬  ᢮ 
            for (k = 0; k < NumBlock; k++)
            {
                if (!disk_CheckBlock(k))
                {
                    //  ᢮
                    disk_SetBlock(k);
                    r->map[j] = k;
                    nBlocks--;
                    break;
                }
            } // k
        } // j
        r++;
    }
    if (nBlocks)
        return 0;
    return -1;
}

//
// 뤥   ४ਨ ᪠
//  ᮧ ᨢ  nDirs ४ ᥩ
//
DIRREC *disk_AllocDir(char *name, UINT16 nDirs)
{
    UINT16   i, j, f;
    DIRREC  *dir, *r;

    dir = (DIRREC *) malloc(nDirs*sizeof(DIRREC));
    if (dir == NULL)
        return NULL;
    r = dir;
    for (i = 0; i < nDirs; i++)             //   ४୮ 
    {
        memset(r, 0, sizeof(DIRREC));
        disk_FrmName(name, &r->name[0]);
        f = 0;
        for (j = 0; j < NumDir; j++)
        {
            if (!disk_CheckDir(j))
            {
                disk_SetDir(j);
                r->res = j;                 // ६   
                f++;
                break;
            }
        }   // for j
        if (!f)
        {
            free(dir);                      // ᢮ ४ਨ 稫
            return NULL;
        }
        r++;
    }
    return dir;
}


//
//     
// 頥 ⢮ ⢨⥫쭮 ᠭ 
//
UINT16 disk_WriteBlock(DEVICE *p, FILE *src, UINT16 nBlock)
{
    UINT32  i;
    UINT32  SecInBlock;
    char    buff[512];
    UINT16  total;
    UINT32  n;

    total = 0;
    SecInBlock = BlockSize / 512;
    for (i = 0; i < SecInBlock; i++)
    {
        memset(buff, 0xE5, sizeof(buff));
        total += fread(&buff, 1, 512, src);
        n = StartSector + (nBlock * SecInBlock) + i;
        if (!ide_WriteSector(p->NumChan, p->NumDev, n, &buff))
            break;
    }
    return total;
}


//
//   ४୮   
//
char disk_WriteDir(DEVICE *p, UINT16 nDir, DIRREC *dir)
{
    DIRREC  buff[DIRINSEC];
    DIRREC *r;
    UINT32  Sec;
    UINT16  Rec;

    Sec = StartSector + (nDir / DIRINSEC);
    Rec = nDir % DIRINSEC;
    r = &buff[Rec];
    ide_ReadSector(p->NumChan, p->NumDev, Sec, &buff);
    memcpy(r, dir, sizeof(DIRREC));
    ide_WriteSector(p->NumChan, p->NumDev, Sec, &buff);
    return -1;
}


//
// 㤠 䠩  ᪠ CP/M
//
char disk_DeleteFile(DEVICE *p, char *name)
{
    UINT16  i, j, f, k;
    DIRREC  dir[DIRINSEC];
    char    fname[14];

    disk_FrmName(name, fname);
    for (i = 0; i < ((NumDir+(DIRINSEC-1)) / DIRINSEC); i++)
    {
        // 㦠 । ᥪ ४
        if (!ide_ReadSector(p->NumChan, p->NumDev, StartSector + i, &dir))
        {
            printf("    *error* - can't read directory sector at 0x%08lX\n", StartSector+i);
            return 0;
        }
        f = 0;
        for (j = 0; j < DIRINSEC; j++)          // 横    ⥪饬 ᥪ
        {
            if (dir[j].user == 0xE5)            // ᢮ ?
                continue;
            if (!memcmp(dir[j].name, fname, 11))
            {
                f++;
                dir[j].user = 0xE5;             // ᢮ ४ 
                disk_FreeDir(i*DIRINSEC+j);
                for (k = 0; k < 8; k++)         //    
                    if (dir[j].map[k] != 0)
                        disk_FreeBlock(dir[j].map[k]);
            }
        }
        if (f)
            ide_WriteSector(p->NumChan, p->NumDev, StartSector + i, &dir);
    }
    return -1;
}


//
// ஢ 稥 䠩  ᪥
//
char disk_IsFilePresent(DEVICE *p, char *name)
{
    UINT16  i, j;
    DIRREC  dir[DIRINSEC];
    char    fname[14];

    disk_FrmName(name, fname);
    for (i = 0; i < ((NumDir+(DIRINSEC-1)) / DIRINSEC); i++)
    {
        // 㦠 । ᥪ ४
        if (!ide_ReadSector(p->NumChan, p->NumDev, StartSector + i, &dir))
        {
            printf("      *error* - can't read directory sector at 0x%08lX\n", StartSector+i);
            return 0;
        }
        for (j = 0; j < DIRINSEC; j++)          // 横  
        {
            if (dir[j].user == 0xE5)            // ᢮ ?
                continue;
            if (!memcmp(dir[j].name, fname, 11))
                return -1;
        }
    }
    return 0;
}


//
//     䠩
//
char disk_Copy(DEVICE *p, char *name, UINT32 size)
{
    DIRREC *dir, *r;
    UINT16  nBlocks, nDirs;
    FILE   *src;
    UINT16  i, j, k, n;
    UINT8   ex;
    UINT32  total;
    char    c;

    nBlocks = (size + BlockSize-1) / BlockSize;
    nDirs = (nBlocks+7) / 8;    // १ࢨ㥬   ᪥  ४ 

    if (disk_IsFilePresent(p, name))
    {
        // 䠩 㦥 
        printf("    -file %s is present! overwrite (y/n)? ", name);
        fflush(stdout);
        c = getch();
        if ((c == 'y') || (c == 'Y'))
        {
            printf("\r                                                                               \r");
            disk_DeleteFile(p, name);
        } else {
            printf("\r                                                                               \r");
            printf("    -skip: %s\n", name);
            return -1;
        }
    }
    if ( (dir = disk_AllocDir(name, nDirs)) == NULL)
    {
        printf("    -skip: %s - not enought directory space\n", name);
        return 0;
    }
    if (!disk_AllocBlock(dir, nBlocks))
    {
        free(dir);
        printf("    -skip: %s - not enought disk space\n", name);
        return 0;
    }
    // 뢠 䠩  ⥭
    if (( src = fopen(name, "rb")) == NULL)
    {
        free(dir);
        printf("    -skip: %s - can't open\n", name);
        return 0;
    }
    // 㥬 䠩  
    printf("    -copy: %-42s %12lu bytes\n", name, size);
    r = dir;
    ex = 0;
    total = 0;
    for (i = 0; i < nDirs; i++)
    {
        for (j = 0; j < 8; j++)
        {
            if (r->map[j] != 0)
            {
                k = disk_WriteBlock(p, src, r->map[j]);
                total += k;
                if (total > 16384)
                {
                    total -= 16384;
                    ex += 1;
                }
            }
        }
        r->ex = ex;
        r->rc = (total+127) / 128;
        n = r->res;
        r->res = 0;
        disk_WriteDir(p, n, r);
        r++;
    }

    fclose(src);
    free(dir);
    return -1;
}


//
//  䠩  ᪥  ࠢ  
//
void disk_CopyFiles(DEVICE *p, char *files)
{
    struct find_t  fileinfo;
    int            rc;
    char          *path;
    char          *fname;

    path = disk_GetPath(files);
    fname = (char *) malloc(strlen(path) + _MAX_FNAME + _MAX_EXT + sizeof(char));
    if ((!path) || (!fname))
    {
        printf("  *error* - not enought memory!\n");
        return;
    }
    rc = _dos_findfirst(files, _A_NORMAL, &fileinfo );

    while( !rc )
    {
        if (!(fileinfo.attrib & _A_SUBDIR))
        {
            strcpy(fname, path);
            strcat(fname, fileinfo.name);
            if (!disk_Copy(p, fname, fileinfo.size))
            {
                // ४㥬  訡
                disk_DeleteFile(p, fname);
                disk_ScanDir(p);
            }

        }
        rc = _dos_findnext(&fileinfo);
    }
}
/*
==============================================================================

                                   MENU

==============================================================================
*/

char* szDrives[4] = {"Prim. master: ","Prim. slave : ","Sec.  master: ","Sec.  slave : "};



//   䨪  㯭 ⮢
int hdd_Find(DEVICE *dev)
{
    int     i, j, k;
    DEVICE* p;
    UINT16  buff[256];
    char*   b;
    int     numDev;
    UINT32  sec,cyl,head;
    numDev = 0;
    p = dev;
    for (i=0; i<2; i++)
        for (j=0; j<2; j++)
        {
            p->Active = 0;
            if (ide_Identify(i, j, &buff))
            {
                p->Active = 0xFF;
                p->NumChan = i;
                p->NumDev = j;
                p->Cyl = buff[1];
                p->Head = buff[3];
                p->Sec = buff[6];
                cyl = buff[1];
                head = buff[3];
                sec = buff[6];
                p->Size = cyl*sec*head;
                // ७ᨬ  ன⢠
                b = (char*) &buff[27];
                for (k=0; k<8; k++)
                {
                    p->Name[k*2+1]  = *b++;
                    p->Name[k*2]    = *b++;
                }
                p->Name[k*2] = 0x00;            // !!!   ন !!!
                numDev++;
            }
            p++;
        }
    return numDev;
}

char mnu_Select(DEVICE *dev)
{
    DEVICE* p;
    int i;

    printf(">Select drive:\n");
    p = dev;
    for (i=0; i<4; i++)
    {
        printf("[%i] %s", i, szDrives[i]);
        if (p->Active)
        {
            printf("%s  Size: %8luKb\tCHS: %u/%u/%u\n",&p->Name, p->Size / 2,p->Cyl,p->Head,p->Sec);

        } else {
            printf("none\n");
        }
        p++;
    }
    printf("[4] or [ESC] to exit\n");
    return getch();
}



void do_Usage()
{
    printf("Usage: C8000D.EXE disk: file.ext\n");
    printf("  disk:       - CP/M disk in hard disk [A,B,C,D, etc.]\n");
    printf("  file.ext    - filename, include mask '?' and '*'\n");
}

char do_argv(int argc, char *argv[], int *CPMDrive, char *SrcFiles)
{
    char drv;

    if (argc < 3)
    {
        do_Usage();
        return 0;
    }
    if (strlen(&argv[1][0]) != 2)
    {
        printf("  *error* - CP/M drive parametr request!\n");
        return 0;
    }
    strupr(&argv[1][0]);
    drv = argv[1][0];
    if ( (drv < 'A') || (drv > 'Z') || (argv[1][1] != ':') )
        {
            printf("  *error* - unknown parametr '%s'\n", argv[1]);
            return 0;
        }
    *CPMDrive = drv - 'A';
    strcpy(SrcFiles, &argv[2][0]);
    return -1;
}


void do_Save(int argc, char *argv[])
{
    DEVICE  dev[4];          //   ன⢠   
    DEVICE *p;
    DISKS   dsk;
    char    b;
    char   *SrcFiles;
    int     CPMDrive;

    while (kbhit()) getch();

    SrcFiles = (char*) malloc(512);
    if (!do_argv(argc, argv, &CPMDrive, SrcFiles))
    {
        free(SrcFiles);
        return;
    }
    if (hdd_Find(dev) == 0)
    {
        printf("*error* - hard disk's not found!\n");
        return;
    }
    switch ((b = mnu_Select(dev)))
    {
        case '0':
        case '1':
        case '2':
        case '3':
        {
            p = &dev[b-'0'];
            if (!p->Active)
            {
                printf("*error* - select unused drive!\n");
                return;
            }
            break;
        }
        case '4':
        case  27:
        {
            printf("Good ");
            return;
        }
        default:
        {
            printf("*error* - select must be range in [0..3]!\n");
            return;
        }
    } // switch
    // ᪠஢  । ᪨ ᪮
    memset(&dsk, 0, sizeof(DISKS));
    if (!hdd_FindDisks(p, &dsk))
        return;
    if (dsk.lastDisk < CPMDrive)
    {
        printf("*error* - CP/M disk [%c] not found!\n", CPMDrive+'A');
        return;
    }
    // 㥬 䠩[]
    if (!disk_Mount(p, dsk.AbsAddr[CPMDrive]))
        return;
    disk_CopyFiles(p, SrcFiles);

    free(SrcFiles);
    while (kbhit()) getch();
}


int main(int argc, char *argv[])
{
    printf("Copy files for PK8000.\n");
    do_Save(argc, argv);
    printf("Bye!\n");
    return 0;
}

