
//  i-input o-output n-active low
module I8259(
	input	wire		clock_i,
	input	wire		cs_in, 
	input	wire		wr_in,
	input	wire		rd_in,
	input	wire [7:0]	d_i,
	output	wire [7:0]	d_o,
	
	input	wire [2:0]	cas_i,
	output	wire [2:0]	cas_o,
	input	wire		sp_in,
	output	wire		en_on,
	
	output	wire		int_o,
	input	wire [7:0]	ir_i,
	input	wire		inta_in,
	input	wire		a_i
	);

wire [7:0]	IMR, IRR, REQ;	  
wire		AEOI, WR_OCW2, LTIM;	 
wire [7:0]	ICW3;
wire		SNGL, ADI, CPU_MODE;
wire [1:0]	BUF_MODE;

wire [7:0]	ISR_SET, ISR;	   
wire [2:0]	VECTOR;
wire		FREEZE, SPMASK;	

wire		CPU_INT, CPU_INTA;
assign		CPU_INTA = ~inta_in;
assign		int_o = CPU_INT;  

wire		INTA1, INTA2;	
wire [4:0]	I8086VECT;
wire [10:0]	I8080ADDR;			  

//   
wire [7:0]	IG_DATA, CTRL_DATA;
wire		IG_SEL;
assign		d_o = IG_SEL ? IG_DATA : CTRL_DATA;

//   ******************************
//  IMR
I8259_BusCtrl u1(
	.clock_i(clock_i), 
	.reset_o(RESET),

	.cs_in(cs_in), 
	.wr_in(wr_in), 
	.rd_in(rd_in),
	.a_i(a_i),
	.d_i(d_i),
	.d_o(CTRL_DATA),
	
	.IRR(IRR),	
	.ISR(ISR),	
	.IRM(IMR),		
	
	.int_i(INT),
	.vector_i(VECTOR),
	
	.ocw2_wr_o(WR_OCW2),
	.icw3_o(ICW3),	
	.sngl_o(SNGL),
	.adi_o(ADI),
	.buf_mode_o(BUF_MODE),
	.cpu_mode_o(CPU_MODE), 
	.i8080_addr_o(I8080ADDR),
	.i8086_vect_o(I8086VECT),
	
	.aeoi_o(AEOI),
	.ltim_o(LTIM),
	.spmask_o(SPMASK),
	.poll_o(POLL),
	.poll_inta_o(POLL_INTA)
);	 

//   *****************************
//  IRR
I8259_IRR u2(
	.clock_i(clock_i), 
	.reset_i(RESET),
	.ir_i(ir_i), 
	.imr_i(IMR), 
	.isr_set(ISR_SET),
	.freeze_i(FREEZE), 
	.ltim_i(LTIM),	
	.req_o(REQ), 
	.irr_o(IRR)
);

//     ************
//  ISR	
//     ********
I8259_PriorityDec u3(
	.clock_i(clock_i), 
	.reset_i(RESET),
	
	.req_i(REQ),
	.d_i(d_i),
	.wr_cmd(WR_OCW2),
	.aeoi_i(AEOI),	
	.inta1_i(INTA1 || POLL_INTA),
	.inta2_i(INTA2),
	.spmask_i(SPMASK),
	
	.ISR(ISR),	
	.ISR_SET(ISR_SET),
	.freeze_o(FREEZE),
	.vector_o(VECTOR),
	.int_o(INT)
); 

//    **************
I8259_IntGenerator u4(
	.clock_i(clock_i),
	.reset_i(RESET),
	
	.int_i(INT),
	.vector_i(VECTOR),	 
	.inta1_o(INTA1),
	.inta2_o(INTA2),
	
	.cas_i(cas_i),
	.cas_o(cas_o),
	
	.buf_mode_i(BUF_MODE),
	.cpu_mode_i(CPU_MODE),
	.icw3_i(ICW3),		  
	.sngl_i(SNGL),
	.adi_i(ADI),  
	.i8080_addr_i(I8080ADDR),
	.i8086_vect_i(I8086VECT),
	
	.cpu_int_o(CPU_INT),
	.cpu_inta_i(CPU_INTA),
	.cpu_d_o(IG_DATA),
	.cpu_data_o(IG_SEL),
	.en_on(en_on)
);

endmodule 	 

 