

module I8259_BusCtrl(
	input	wire		clock_i,
	
	input	wire		cs_in, 
	input	wire		wr_in,
	input	wire		rd_in,	
	input	wire		a_i,
	input	wire [7:0]	d_i,
	output	reg	 [7:0]	d_o,
	
	input	wire [7:0]	IRR,	
	input	wire [7:0]	ISR,	
	output	reg  [7:0]	IRM,	
	
	input	wire		int_i,
	input	wire [2:0]	vector_i,
	
	output	wire [7:0]	icw3_o,
	output	wire		sngl_o,
	output	wire		adi_o,
	output	wire [1:0]	buf_mode_o,
	output	wire		cpu_mode_o,	
	output	wire [10:0]	i8080_addr_o,
	output	wire [4:0]	i8086_vect_o,
	
	output	reg			reset_o,
	output	reg			ocw2_wr_o,
	output	wire		aeoi_o,
	output	wire		ltim_o,
	output	wire		spmask_o,
	output	wire		poll_o,
	output	wire		poll_inta_o
	);		
	
wire		rd, wr;	   
reg	[7:0]	ICW1, ICW2, ICW3, ICW4;	

// ICW1 ***************************************
wire		LTIM	= ICW1[3];
wire		ADI		= ICW1[2];
wire		SNGL	= ICW1[1];
wire		IC4		= ICW1[0];

// ICW4 ***************************************
wire		SFNM	= ICW4[4];
wire		BUF		= ICW4[3];
wire		MS		= ICW4[2];
wire		AEOI	= ICW4[1];
wire		JUMP	= ICW4[0]; 	

assign		aeoi_o	= AEOI;	 
assign		ltim_o  = LTIM;					
assign		icw3_o  = ICW3;
assign		sngl_o	= SNGL;
assign		adi_o	= ADI;	  
assign		buf_mode_o = {BUF, MS};
assign		cpu_mode_o = JUMP;
assign		i8080_addr_o = {ICW2, ICW1[7:5]};
assign		i8086_vect_o = {ICW2[7:3]};		
	
I8259_CtrlDetect u1(
	.clock_i(clock_i),
	.cs_in(cs_in), 
	.wr_in(wr_in),
	.rd_in(rd_in),
	
	.wr_o(wr),
	.rd_o(rd)
);			  

// WRITE ***********************************************************

reg	[1:0]	initState;		 
reg [1:0]	nxReadMode;	 
reg			spmask;		 
reg			poll;

assign		spmask_o = spmask;

localparam 
	isWork		= 0,
	isWaitICW2	= 1,
	isWaitICW3	= 2,
	isWaitICW4	= 3;

always @ (posedge wr)
begin
	reset_o    <= 0;
	nxReadMode <= 0;
	ocw2_wr_o  <= 0;
	
	if (a_i == 0) 
	begin		  
		if (d_i[4] == 1)
		begin // ICW1
			initState <= isWaitICW2;
			ICW1      <= d_i;
			reset_o   <= 1;
			IRM       <= 0;
			spmask    <= 0;
			poll      <= 0;
			
			if (d_i[0] == 0) ICW4 <= 0; // IC4
			if (d_i[1] == 1) ICW3 <= 0; // SNGL
		end
		else
			if (d_i[3] == 2'b0) ocw2_wr_o <= 1;
			else 
			begin // OCW3			   
				if (d_i[6]) //   spmask
					spmask <= d_i[5];  
					
				poll <= d_i[2];
				nxReadMode <= d_i[1:0];	
			end
	end
	else
		case (initState)
			isWaitICW2:	
			begin
				initState <= (SNGL == 0) ? isWaitICW3 : isWork;
				ICW2 <= d_i;
			end
			isWaitICW3:
			begin
				initState <= (IC4) ? isWaitICW4 : isWork;
				ICW3 <= d_i;
			end
			isWaitICW4: 
			begin 
				initState <= isWork;
				ICW4 <= d_i;
			end
			isWork: // OCW1
				IRM <= d_i;
		endcase
end	

// READ *************************************************************
always @ (posedge rd)
begin
	if (a_i == 1)
		d_o = IRM;
	else   	
	begin		
		if (poll)
			d_o = {int_i, 4'b000, vector_i};
		else			
			case (nxReadMode)
				2'b10: d_o = IRR;
				2'b11: d_o = ISR;
			endcase
	end
end	  

//     *********************
reg			poll_inta;
always @ (posedge rd or posedge int_i or posedge reset_o)
if (int_i || reset_o)
	poll_inta = 0;
else
	poll_inta = poll;
	
assign		poll_o = poll;
assign		poll_inta_o = int_i ? poll_inta : 0;

endmodule 		  