					  
//      

module I8259_CtrlDetect(
	input	wire		clock_i,
	input	wire		cs_in, 
	input	wire		wr_in,
	input	wire		rd_in,
	
	output	reg			wr_o,
	output	reg			rd_o
	);	
	
reg [2:0]	sync_wr, sync_rd;

always @ (posedge clock_i)
begin
	sync_wr = {sync_wr[1:0], wr_in};
	sync_rd = {sync_rd[1:0], rd_in};
end
	
always @ (posedge clock_i or posedge cs_in)	
if (cs_in)
begin
	wr_o = 0;
	rd_o = 0;
end
else
begin			  
	//    
	wr_o = sync_wr == 3'b100 && cs_in == 0;
	rd_o = sync_rd == 3'b100 && cs_in == 0 && sync_wr != 3'b100;
end
	
endmodule