		 
//   IRR

module I8259_IRR(
	input	wire		clock_i,
	input	wire		reset_i,
	
	input	wire [7:0]	ir_i,  
	input	wire [7:0]	imr_i, 
	input	wire [7:0]	isr_set,
	input	wire		freeze_i,
	input	wire		ltim_i,	
	
	output	wire [7:0]	req_o,
	output	wire [7:0]	irr_o
	);						 
	
generate 	
genvar i;
	for (i=0; i<8; i=i+1)
	begin
		I8259_Pin u1(
			.clock_i(clock_i),
			.reset_i(reset_i | isr_set[i]),
			
			.ir_i(ir_i[i]),
			.freeze_i(freeze_i),
			.ltim_i(ltim_i),
			.imr_i(imr_i[i]),
			
			.latch_o(irr_o[i]),
			.req_o(req_o[i])
		);		
	end

endgenerate 
	

	
endmodule 