

module I8259_IntGenerator(
	input	wire		clock_i,
	input	wire		reset_i,
	
	input	wire		int_i,
	input	wire[2:0]	vector_i,  
	output	reg			inta1_o,
	output	reg			inta2_o,
	
	input	wire[2:0]	cas_i,
	output	reg [2:0]	cas_o,
	
	input	wire[1:0]	buf_mode_i,
	input	wire		cpu_mode_i,
	input	wire[7:0]	icw3_i,
	input	wire		sngl_i,
	input	wire		adi_i,
	input	wire [10:0]	i8080_addr_i,
	input	wire [4:0]	i8086_vect_i,
	
	output	reg 		cpu_int_o,
	input	wire		cpu_inta_i,
	output	reg	[7:0]	cpu_d_o,		//   
	output	reg			cpu_data_o,		//      
	output	wire		en_on			//   
	
	);	
// cpu_mode = 0-8080 1-8086
reg			inta_cycle;
reg[1:0]	inta_cnt;	

//   INTA
reg[3:0]	shift;
reg			inta_b; //  INTA
reg			inta_e; //  INTA

always @ (posedge clock_i)
begin
	shift = {shift[2:0], cpu_inta_i};
	inta_b = shift[3:1] == 3'b011;
	inta_e = shift[3:1] == 3'b110;
end

reg			end_inta;  
reg			buf_block;
assign		en_on = ~buf_block;

//   8080
wire[7:0]	ADDR_L = adi_i ? {i8080_addr_i[2:0], vector_i, 2'b00} : {i8080_addr_i[2:1], vector_i, 3'b000};
wire[7:0]	ADDR_H = i8080_addr_i[10:3];


always @ (posedge clock_i or posedge reset_i)
if (reset_i)
begin
	cpu_int_o = 0;
	cas_o = 0;	
	cpu_d_o = 0;   
	cpu_data_o = 0;	 
	inta1_o = 0;
	inta2_o = 0;   
	end_inta = 0;	
	inta_cycle = 0;
end				 
else
begin			
	inta1_o = 0;
	inta2_o = 0;
	
	if (inta_cycle == 0 && int_i)
	begin
		cpu_int_o = 1;
		inta_cycle = 1;
		inta_cnt = 0;
	end				 
	else if (inta_cycle == 1 && inta_b)
	begin 				   
		end_inta = 0;
		case ({cpu_mode_i, inta_cnt})
			// 8080
			3'b0_00: // CALL
			begin
				cpu_d_o = 8'hCD;
				cpu_data_o = 1;
			end		
			3'b0_01: //   
			begin
				cpu_d_o = ADDR_L;
				cpu_data_o = 1;
			end
			3'b0_10: //   
			begin
				cpu_d_o = ADDR_H;
				cpu_data_o = 1;
				end_inta = 1;
			end	 
			
			// 8086
			3'b1_01: //  
			begin			 
				cpu_d_o = {i8086_vect_i, vector_i};
				cpu_data_o = 1;
				end_inta = 1;
			end
		endcase		
		
		if (inta_cnt == 0) inta1_o = 1;		
	end
	else if (inta_cycle == 1 && inta_e)
	begin		
		cpu_data_o = 0;		  
		buf_block = 0;   
		inta_cycle = end_inta ? 0 : inta_cycle;	
		
		if (inta_cnt == 1)
		begin
			cpu_int_o = 0;
			inta2_o = 1;
		end
		
		inta_cnt = inta_cnt + 1;
	end
end
	
endmodule 