		
//   IR

module I8259_Pin(
	input	wire		clock_i,
	input	wire		reset_i,
	
	input 	wire		ir_i,
	input	wire		freeze_i,
	input	wire		ltim_i,
	input	wire		imr_i,
	
	output	wire		latch_o,
	output	wire		req_o
	);				 
	
// 
//     ************************************
reg	[3:0]	shift;
always @ (posedge clock_i)
	shift <= {shift[2:0], ir_i};
	
wire		s_edge  = (shift[3:1] == 3'b001);
wire		s_level = (shift[3:2] == 3'b000);
wire		s_event = ltim_i ? s_level : s_edge;

//  IR LATCH ******************************************
reg			latch;								  
assign		latch_o = latch;
assign		req_o = latch & ~imr_i;			  

always @ (posedge clock_i or posedge reset_i )
	if (reset_i)									
		latch <= 0;
	else
		if (!freeze_i) latch <= latch | s_event;
	
endmodule