
module I8259_PriorityDec(
	input	wire		clock_i,
	input	wire		reset_i,
	
	input	wire [7:0]	req_i,
	input	wire [7:0]	d_i,
	input	wire		wr_cmd,
	input	wire		aeoi_i,
	input	wire		inta1_i,
	input	wire		inta2_i,
	input	wire		spmask_i,
	
	output	reg  [7:0]	ISR,
	output	reg	 [7:0]	ISR_SET,
	output	reg			freeze_o,
	output	reg  [2:0]	vector_o,
	output	reg  		int_o
);

wire[2:0]	max_isr; //   ISR      
reg [2:0]	min_level;
wire[2:0]	req_pin, req_level, isr_level;
wire		req;
reg			autorot;

I8259_PriorityEncoder u1(
	.req_i(req_i), 
	.isr_i(ISR),
	.min_level_i(min_level),
	.spmask_i(spmask_i),  
	
	.req_pin_o(req_pin),
	.req_level_o(req_level),	
	.req_pres_o(req),
	.max_isr_o(max_isr),
	.isr_level_o(isr_level)
);

//  OCW2 ***************************************************************************

wire		EOI = d_i[5];
wire		SL	= d_i[6];
wire		R	= d_i[7];
wire[2:0]	LEV = d_i[2:0];	 

reg			eoi;	   
reg	[2:0]	eoi_bit;


always @ (posedge clock_i or posedge reset_i)
if (reset_i)
begin		
	min_level = 7;
	autorot   <= 0;	
	eoi       <= 0;
	eoi_bit   <= 0;
end					   
else
begin	
	eoi	<= 0;		
	
	if (inta2_i & autorot) min_level = min_level + 1;
	
	if (wr_cmd)	// OCW2
	begin
		eoi <= EOI;
		
		if (EOI) //    
			case ({R, SL})
				2'b00 : // EOI    
					eoi_bit <= max_isr;
				2'b10 : // EOI       
				begin
					eoi_bit <= max_isr;
					min_level <= min_level + 1;
				end	  
				2'b01 : // EOI   
					eoi_bit <= LEV;
				2'b11 : // EOI       
				begin
					eoi_bit <= LEV;
					min_level <= LEV;
				end
			endcase
		else //    
			case ({R, SL})	
				2'b11:
					min_level <= LEV;
				2'b10: 
					autorot <= 1;
				2'b00:			 
					autorot <= 0;
			endcase
	end
end	   

//   ISR ***********************************************************************
always @ (posedge clock_i or posedge reset_i)
if (reset_i)
begin
	ISR       <= 0;
	ISR_SET   <= 0;
	freeze_o  <= 0;	
	vector_o  <= 0;
end				
else
begin		   
	ISR_SET <= 0;
	
	if (inta1_i)
	begin
		freeze_o         <= 1;
		ISR_SET[req_pin] <= 1;
		ISR[req_pin]     <= 1; 
		vector_o		 <= req_pin;
	end
	else if (inta2_i)
	begin	 
		freeze_o         <= 0;
		if (aeoi_i) 
			ISR[max_isr] <= 0;
	end
	else if (eoi)
		ISR[eoi_bit]	 <= 0;
end	   

//      ******************************************
always @ (posedge clock_i or posedge reset_i)
if (reset_i)
	int_o    <= 0;		
else
	if (!int_o)
		int_o <=  spmask_i ? req : (req && req_level < isr_level);
	else if (inta1_i)
		int_o <= 0;

endmodule 