			 
//  ,    

module I8259_PriorityEncoder(
	input	wire [7:0]	req_i,		
	input	wire [7:0]	isr_i,
	input	wire [2:0]	min_level_i, 
	input	wire		spmask_i,		//   ,  
	
	output	reg  [2:0]	req_pin_o,		//     
	output	reg  [2:0]	req_level_o,	//  
	output	reg	 [2:0]	req_pres_o,		//  
	output	reg  [2:0]	max_isr_o,
	output	reg  [2:0]	isr_level_o
	);	  
	
//      							  
wire[2:0] 		sel_pin [0:7]; //      		
wire[7:0]		req_pin;       //      	 
wire[7:0]		isr_pin; 

wire[2:0]		min_level = spmask_i ? 7 : min_level_i;

generate 
genvar i;
	for(i=7; i >= 0; i = i-1)
	begin					
		assign sel_pin[i] = (i == 7) ? min_level : sel_pin[i+1] - 1;
		assign req_pin[i] = req_i[sel_pin[i]];
		assign isr_pin[i] = isr_i[sel_pin[i]];
	end						
endgenerate   

wire [7:0]		spmask = spmask_i ? (isr_i ^ 8'hFF) : 8'hFF;
wire [7:0]		req = req_pin & spmask;

//  
always @ *
begin		   
	req_pres_o = 1;
	casex (req)
		8'bxxxx_xxx1: req_level_o = 0;
		8'bxxxx_xx10: req_level_o = 1;
		8'bxxxx_x100: req_level_o = 2;
		8'bxxxx_1000: req_level_o = 3;
		8'bxxx1_0000: req_level_o = 4;
		8'bxx10_0000: req_level_o = 5;
		8'bx100_0000: req_level_o = 6;
		8'b1000_0000: req_level_o = 7;
		default: req_pres_o = 0;
	endcase 
	
	casex (isr_pin)
		8'bxxxx_xxx1: isr_level_o = 0;
		8'bxxxx_xx10: isr_level_o = 1;
		8'bxxxx_x100: isr_level_o = 2;
		8'bxxxx_1000: isr_level_o = 3;
		8'bxxx1_0000: isr_level_o = 4;
		8'bxx10_0000: isr_level_o = 5;
		8'bx100_0000: isr_level_o = 6;
		8'b1000_0000: isr_level_o = 7;
		default: isr_level_o = 7;
	endcase 
	
	req_pin_o = sel_pin[req_level_o];
	max_isr_o = sel_pin[isr_level_o];
end
	
endmodule 