/* REXX */
/* sdccscl.rex */
/*
Short:			Rexx macro for automatic compilation SDCC C-source to ZX-BASIC-monolader in SCL.
Author:		Amixgris / Red Triangle
Uploader:		Amixgris / Red Triangle
Type:			rexx script
Version		1.0
Architecture: x86/win
Date:		  	06-07-2014
Usage: 		sdccscl.rex source_name.c
*/

/*Compiling options BEGIN:*/
CODE_ORG = "23897"	  /* for BASIC string value */
DATA_ORG = "0x0000"	  /* not used for zx */
LIB_LIST = ""  		  /* write used library names list here by white space separated */
STACK	  = "65535"	  /* BASIC stack value */
/*Compiling options END*/

OPTIONS AREXX_SEMANTICS
OPTIONS AREXX_BIFS

/* SCL data BEGIN:*/
T0 = '53 49 4e 43 4c 41 49 52 01 62 6f 6f 74 20 20 20 20 42 00 00 00 00 00'x
T1 = '00 01'x
/* LENGTH OF BASIC STRING HERE, 2 bytes */
T2 = 'fd b0 22'x
/* STACK HERE, 5 chars */
T3 = '22 3a f9 c0 b0 22'x
/* CODE START addres here, 5 chars (23897) */
T4 = '22 3a f1 42 24 3d 22'x
/* TARGET CODE HERE */
T5 = '22 0d'x
/*  SCL data END: */
T0L = LENGTH(T0) ; T1L = LENGTH(T1) ; T2L = LENGTH(T2) ; T3L = LENGTH(T3) ; T4L = LENGTH(T4) ; T5L = LENGTH(T5)

PARSE ARG infpathname .

IF ~OPEN("in0", infpathname, "READ")	THEN DO
											CALL CLOSE('in0')
											SAY "Can`t open" infpathname "for input."
											SAY "OPERATION ABORTED!" ; RETURN
											END

inf_drive = FILESPEC('D',infpathname)
inf_path  = FILESPEC('P',infpathname)
inf_name  = FILESPEC('N',infpathname)

outopt = " -o "
if LENGTH(inf_path) == 0 THEN outopt = " "

PARSE VAR inf_name in_name "." in_ext
A = "-c -mz80 "||inf_drive||inf_path||in_name||"."||in_ext||outopt||inf_drive||inf_path
B = "-mz80 --code-loc "||CODE_ORG||" --data-loc "||DATA_ORG||" --no-std-crt0 "||inf_drive||inf_path||in_name||".rel "||LIB_LIST||outopt||inf_drive||inf_path

CALL sdcc A
CALL sdcc B

/* CREATING BINARY FROM INTEL HEX*/
ihxfpathname = inf_drive||inf_path||in_name||".ihx"
IF ~OPEN("in1",  ihxfpathname, "READ")	THEN DO
											CALL CLOSE('in1')
											SAY "Can`t open" in_name||".ihx"
											SAY "OPERATION ABORTED!" ; RETURN
											END
ihx_len = CHARS(ihxfpathname)

binfpathname = inf_drive||inf_path||in_name||".bin"
IF ~OPEN("out0",  binfpathname, "WRITE")	THEN DO
												CALL CLOSE('out0')
												SAY "Can`t open" binfpathname
												SAY "OPERATION ABORTED!" ; RETURN
												END

ihx_loop = ihx_len+1
DO i = 1 WHILE i < ihx_loop
	DO
	ich = CHARIN(ihxfpathname,,)
	IF(ich=':')	THEN DO
					datalen = X2D(CHARIN(ihxfpathname,,2)) 	; i = i+2
					offset	 = CHARIN(ihxfpathname,,4) 			; i = i+4
					rectype = CHARIN(ihxfpathname,,2) 			; i = i+2
					data 	 = CHARIN(ihxfpathname,,2*datalen)	; i = i+datalen
					crc 	 = CHARIN(ihxfpathname,,2)
					a 		 = CHAROUT(binfpathname,X2C(data),)
					END
	END
END
a = CALL CLOSE("out0")

/* REMOVING TEMPORARY FILES*/
l = inf_drive||inf_path||in_name||"."
CALL del l||"asm" l||"lk" l||"lst" l||"map" l||"noi" l||"rel" l||"sym"

/* NEEDLE LENGTHS CALCULATING*/
code_len = CHARS(binfpathname)
bline_len = code_len + 28
bas_len  = T1L+2+T2L+5+T3L+5+T4L+code_len+T5L
bas_slen = (bas_len+255)%256	/* BASIC len in sectors*/
add_len = 256 - bas_len//256	/* align value to sector boundary*/
scl_len = T0L+bas_len+add_len
free_len = STACK - 23867 - bas_len

say "Code length      ="RIGHT(code_len,5,' ') "/ 0x"RIGHT(D2X(code_len),4,'0')
say "BASIC line len   ="RIGHT(bline_len,5,' ') "/ 0x"RIGHT(D2X(bline_len),4,'0')
say "BASIC length     ="RIGHT(bas_len,5,' ') "/ 0x"RIGHT(D2X(bas_len),4,'0')
say "Space to stack   ="RIGHT(free_len,5,' ') "/ 0x"RIGHT(D2X(free_len),4,'0')
say "BASIC sectors    ="RIGHT(bas_slen,5,' ') "/ 0x"RIGHT(D2X(bas_slen),4,'0')
say "Align to sector  ="RIGHT(add_len,5,' ') "/ 0x"RIGHT(D2X(add_len),4,'0')
say "SCL size w/o CRC ="RIGHT(scl_len,5,' ') "/ 0x"RIGHT(D2X(scl_len),4,'0')


/* CREATING SCL FILE*/
sclpathname = inf_drive||inf_path||in_name||".scl"
IF ~OPEN("out2", sclpathname, "WRITE")	THEN DO ; CALL CLOSE("out2")
											SAY "Can`t open" sclpathname
											SAY "OPERATION ABORTED!" ; RETURN
											END

a = CHAROUT(sclpathname, T0,)
a = CHAROUT(sclpathname, T1,)
a = CHAROUT(sclpathname, d2c(bline_len//256),)
a = CHAROUT(sclpathname, d2c(bline_len%256),)
a = CHAROUT(sclpathname, T2,)
a = CHAROUT(sclpathname, RIGHT(STACK, 5),)
a = CHAROUT(sclpathname, T3,)
a = CHAROUT(sclpathname, RIGHT(CODE_ORG, 5),)
a = CHAROUT(sclpathname, T4,)
a = CHARIN(binfpathname, 1, code_len)
a = CHAROUT(sclpathname, a, )
a = CHAROUT(sclpathname, T5,)

count = add_len+1
DO	i = 1 WHILE i<> count
	a = CHAROUT(sclpathname, '0'x, )
END		

b = d2c(bas_len//256)
c = d2c(bas_len%256)

a = CHAROUT(sclpathname, b, 19)
a = CHAROUT(sclpathname, c, )
a = CHAROUT(sclpathname, b, )
a = CHAROUT(sclpathname, c, )
a = CHAROUT(sclpathname, D2C(bas_slen), )

count = scl_len+1
crc = 0
DO	i=1 WHILE i <> count
	a = CHARIN(sclpathname,i , 1)
	crc = crc + C2D(a)
END	

say "SCL CRC          =    0x"RIGHT(D2X(crc),8,'0')

x3 = d2c(crc%16777216)	; 	crc = crc//16777216
x2 = d2c(crc%65536) 		;	crc = crc//65536
x1 = d2c(crc%256)
x0 = d2c(crc//256)
a = charout(sclpathname, x0, count)
a = charout(sclpathname, x1, )
a = charout(sclpathname, x2, )
a = charout(sclpathname, x3, )

a = CALL CLOSE("out2")	

EXIT
