/*REXX*/
OPTIONS AREXX_SEMANTICS
OPTIONS AREXX_BIFS

byEXT   = '00'x
byLOAD  = '01'x
byTIME  = '02'x
byMENU  = '03'x

/***** WC Plugin SetUp: *****/
DataPg0   = "WC_ILBM.a80" 
DataPg1   = "decode.bin"
DataPg2   = " "
DataPg3   = " "
DataPg4   = " "
DataPg5   = " "
Plugname  = "IFF/ILBM viewer v.0.3"
Extentions= "IFF ILB LBM"
Call_by   = byEXT
MaxSize   = 512*1024
PlugFormat= 3
/*****************************/
s1 = 'MAGICWC (R)  WildCommander plugin make utility'
s2 = 'Version 1.0  13-Jul-2014'
s3 = '(c) 2014, Amixgris / Red Triangle'
SAY " "
SAY CENTRE('-',LENGTH(s1)+7,'-')
SAY CENTRE(s1,LENGTH(s1)+7, ' ')
SAY CENTRE(s2,LENGTH(s1)+7, ' ')
SAY CENTRE(s3,LENGTH(s1)+7, ' ')
SAY CENTRE('-',LENGTH(s1)+7,'-')
SAY ""
NumUsedPages = 0

valcnt = 0
DO i =1 UNTIL i = 6
	valstr = "DataPg"||valcnt
	valign = "AlignDPg"||valcnt
	valbyt = "BytesDPg"||valcnt
	valblok= "BlocksDPg"||valcnt

	s = "DataPg = "||valstr
	INTERPRET s
	IF(DataPg \= ' ') THEN,
		DO
		NumUsedPages = NumUsedPages + 1
		PARSE VAR DataPg DataPg "," LIB_LIST .
		s = valstr||"= DataPg" ; INTERPRET s
		PARSE VAR DataPg t_name "." t_ext .
		a = TRANSLATE(t_ext)
		IF(a == "C") THEN,
			DO
			/* C source file processing begin: */
			IF(valcnt = 0)	THEN DO ; CODE_ORG = "0x8000" ; END
							ELSE 	  CODE_ORG = "0xc000"

			A = "-c -mz80 "||DataPg
			B = "-mz80 --code-loc "||CODE_ORG||" --data-loc 0 --no-std-crt0 "||t_name||".rel "||LIB_LIST

			CALL sdcc A
			CALL sdcc B

			ihxfpathname = t_name||".ihx"
			binfpathname = t_name||".bin"
			a = OPEN('IIHX' ihxfpathname, 'READ')
			a = OPEN('OBIN' binfpathname, 'WRITE')
			ihx_len = CHARS(ihxfpathname)

			ihx_loop = ihx_len+1
			DO ihx_l = 1 WHILE ihx_l < ihx_loop
				DO
				ich = CHARIN(ihxfpathname,,)
				IF(ich=':')	THEN,
							DO
							datalen = X2D(CHARIN(ihxfpathname,,2)) 		; ihx_l = ihx_l+2
							offset	= CHARIN(ihxfpathname,,4) 			; ihx_l = ihx_l+4
							rectype = CHARIN(ihxfpathname,,2) 			; ihx_l = ihx_l+2
							data 	= CHARIN(ihxfpathname,,2*datalen)	; ihx_l = ihx_l+datalen
							crc 	= CHARIN(ihxfpathname,,2)
							a 		= CHAROUT(binfpathname,X2C(data),)
							END
				END
			END

			CALL CLOSE('IIHX')
			CALL CLOSE('OBIN')

			l = t_name||"."
			CALL del l||"asm" l||"lk" l||"lst" l||"map" l||"noi" l||"rel" l||"sym" l||"ihx"
			s = valstr||" = "||binfpathname ; INTERPRET s
			/* C source file processing END: */
			END
		IF(a == "ASM") THEN,
			DO
			/* sdasz80 source file processing begin: */
			A = " -g "||t_name||".ihx"|| DataPg
			CALL sdasz80 A

			ihxfpathname = t_name||".ihx"
			binfpathname = t_name||".bin"
			a = OPEN('IIHX' ihxfpathname,'READ')
			a = OPEN('OBIN' binfpathname,'WRITE')
			ihx_len = CHARS(ihxfpathname)

			ihx_loop = ihx_len+1
			bin_size = 0
			DO ihx_l = 1 WHILE ihx_l < ihx_loop
				DO
				ich = CHARIN(ihxfpathname,,)
				IF(ich=':')	THEN,
							DO
							datalen = X2D(CHARIN(ihxfpathname,,2)) 		; ihx_l = ihx_l+2
							bin_size = bin_size + datalen
							offset	 = CHARIN(ihxfpathname,,4) 			; ihx_l = ihx_l+4
							rectype = CHARIN(ihxfpathname,,2) 			; ihx_l = ihx_l+2
							data 	 = CHARIN(ihxfpathname,,2*datalen)	; ihx_l = ihx_l+datalen
							crc 	 = CHARIN(ihxfpathname,,2)
							a 		 = CHAROUT(binfpathname,X2C(data),)
							END
				END
			END

			a = CALL CLOSE("IIHX")
			a = CALL CLOSE("OBIN") 

			s = valstr||" = "||t_name||".bin" ; INTERPRET s		
			/* sdasz80 source file processing END:   */
			END

		IF(a == "A80") THEN,
			DO
			/* SJASMPLUS source file processing begin: */
			CALL sjasmplus "--raw="t_name||".bin" DataPg
			s = valstr||" = "||t_name||".bin" ; INTERPRET s			
			/* SJASMPLUS source file processing END:   */
			END

		s = valbyt||" = CHARS("||valstr||")"   ; INTERPRET s
		s = valign||" = 512-"||valbyt||"//512" ; INTERPRET s
		s = "t = ("||valbyt||"+511)%512" 	   ; INTERPRET s

		IF (t>32),
			THEN  SAY "WARNING:" valstr "too long to load in Page"valcnt
			ELSE  DO
				  SAY "Page"valcnt "has "||RIGHT(t,2,' ')||" blocks of data ("||,
					  LEFT(t/32*100, 5,' ')||"%), "||RIGHT(32-t, 3,' ')||" blocks free"
				  s = valblok||" = D2C("||valcnt||")||D2C(t)" ; INTERPRET s
				  END
		END
	ELSE s = valblok||" = '00 00'x" ; INTERPRET s
valcnt=valcnt+1
END

PARSE VAR DataPg0 pluginname "." b .
pluginname = pluginname||".WMF"

IF ~OPEN("O0", pluginname, "WRITE") THEN DO ; CALL CLOSE('O0')  ; SAY "Can`t open" pluginname "for output."
																  SAY "OPERATION ABORTED!" ; RETURN ; END
					
s = LEFT('00'x,16,'00'x)||"WildCommanderMDL"||D2C(PlugFormat)||'00'x||D2C(NumUsedPages)||D2C(0)||,
	BlocksDPg0||BlocksDPg1||BlocksDPg2||BlocksDPg3||BlocksDPg4||BlocksDPg5||,
	LEFT('00'x,2*8,'00'x)||LEFT(COMPRESS(Extentions),3*32,'00'x)||'00'x
a = CHAROUT(pluginname, s, )	

x3 = d2c(MaxSize%16777216) ; MaxSize = MaxSize//16777216
x2 = d2c(MaxSize%65536)    ; MaxSize = MaxSize//65536
x1 = d2c(MaxSize%256)
x0 = d2c(MaxSize//256)
a = CHAROUT(pluginname, x0, ) ; a = charout(pluginname, x1, )
a = CHAROUT(pluginname, x2, ) ; a = charout(pluginname, x3, )
a = CHAROUT(pluginname, CENTRE(Plugname,32,' ')||Call_by||LEFT('00'x,314,'00'x), )

SAY " "

valcnt = 0
DO i =1 UNTIL i = 6
	valstr = "DataPg"||valcnt
	valign = "AlignDPg"||valcnt
	valbyt = "BytesDPg"||valcnt
	valblok= "BlocksDPg"||valcnt

	s = "DataPg = "||valstr
	INTERPRET s

	IF(DataPg \= ' ') THEN,
		DO
		SAY "Page"||valcnt||' = '||DataPg
		a = CHARS(DataPg)
		a = CHARIN(DataPg, ,a)
		a = CHAROUT(pluginname, a, )
		s = "a = CHAROUT(pluginname,LEFT('77'x,"||valign||",'77'x), )" ; INTERPRET s
		END
	valcnt = valcnt+1
END

SAY NumUsedPages " memory pages used"

CALL CLOSE('O0') 

EXIT
/* USAGE:
RUS:
1. Имена используемых в проекте файлов присваиваем переменным DataPgN.
Имя, состоящее из одного пробела означает, что страница не используется.
Допустимы любые имена на латинице и типы файлов.
Файлы с расширением "с", "asm" и "a80" будут автоматически откомпилированы
и результат будет добавлен в тело плагина.

2. Исходники на Си (расширение "с") компилируются SDCC,
Исходники на ассемблере (расширение "asm") компилируются sdasmz80 (ассемблер из комплекта SDCC),
Исходники на ассемблере (расширение "a80") компилируются sjasmplus,
Файлы с другими расширениями имплантируются как есть.
3. Стартовая страница всега 0, - DataPg0 - указывается главный исходник.
4. При этом, если используются исходники на Си, то указанный для стартовой странице будет откомпилирован
с адреса 0x8000 (32768), остальные - с адреса 0xc000 (49152).
Если в проекте на Си используются библиотеки, то их имена разделяются пробелами и
указываются в строке после имени исходника через запятую, например:
DataPg0 = "main.c , mylib1.lib mylib2.lib sdl.lib"
Для исходников на ассемблере, адрес задаёте в исходнике САМИ.
5. Все имена генерятся собиралкой автоматически, за исключением файлов SJASMPLUS,
которому нельзя задать имя выходного файла из коммандной строки. В этом случае
придётся вручную в исходнике SAVEBIN задавать имя, ожидаемое собиралкой:
Name.a80 -> Name.bin

После того, как собиралка отредактирована, сохраняете её в папке с проектом.
Запускаете собиралку без параметров.

И, да, все файлы должны лежать в одной папке с собралкой, - под полные пути скрипт пока не затачивал.
Сомневаюсь, что в этом есть необходимость.
*/