#!/usr/bin/perl
#
# Converting UDI to DSK.
# Only ISO/ IBM ISO format supported
#
# (c) 2014 PortaOne, Inc.
# kapitan@portaone.com
#
# Usage:
# udi-iso-decode.pl <udi file> <dsk file>
#
use Digest::CRC qw( crcccitt );

open(IN, "<$ARGV[0]") 
   || die "File $ARGV[0] not found.";

my $byte, $next_byte;

# Read file header
#
my $header_buff;
sysread(IN, $header_buff, 19);
( $file_signature,
  $file_unknowng )  = unpack ( 'A3 C16', $header_buff);

$file_signature eq 'UDI' 
   || die "Not UDI file.";

unlink($ARGV[1]);
open(OUT, ">$ARGV[1]")
   || die "Can not create output file $ARGV[1]";
   

# Start
#
my @decoded_track =();
my $decoder_state = 'SYNC';
my $prev_bit = 0;
my $marker_expected = 0xFE;
my $expected_sector_len, $sector_count = 0, $gap_len = 0;
my @sector_len = ( 0, 256, 512, 1024 );

# How many zero bytes to look in SYNC
#
my $sync_len = 8;

# How many bytes to look in DESYNC
#
my $desync_len = 3;

my $desync_cursor, $idam_cursor, $data_cursor, $crc_buff, $crc, $hfe_crc, $bit_counter, $byte_decoded;

$i = 0;
my $sync_cursor = $sync_len;
my $desync_cursor = $desync_len;

while( sysread(IN, $header_buff, 1) ) {

   $byte_decoded = unpack ( 'C', $header_buff);

   if( $decoder_state eq 'DESYNC' || $decoder_state eq 'SYNC' || $decoder_state eq 'SYNC_2' ) {
      $gap_len++;
   }

   # 0x00 SYNC Seqense search
   #
   if( $decoder_state eq 'SYNC'
    && ($byte_decoded == 0x00 ) ) {
      $sync_cursor--;
   } else {
      $sync_cursor = $sync_len;
   }
   
   if( $decoder_state eq 'SYNC' && $sync_cursor == 0 ) {
      $gap_len -= $sync_len;
      print "\nGAP length $gap_len bytes";
      $gap_len = 0;
      print "\nSYNC ";

      $sync_cursor = $sync_len;
      $crc_buff = '';
      $decoder_state = 'SYNC_2';
   }

   # DESYNC Seqense search
   #
   if( $decoder_state eq 'SYNC_2'
    && ($byte_decoded == 0xC2 || $byte_decoded == 0xA1) ) {
       $desync_cursor--;
   }
 
    if( $decoder_state eq 'SYNC_2' && $desync_cursor == 0 ) {
      print "\nDESYNC ";

      $desync_cursor = $desync_len;
      $crc_buff = chr(0xA1).chr(0xA1).chr(0xA1);
      $decoder_state = 'DESYNC';
   }
  
   # Marker Processing
   #
   elsif( $decoder_state eq 'DESYNC' ) {
      $crc_buff .= chr($byte_decoded);

      # TRACK Marker 0xFC
      #
      if( $byte_decoded == 0xFC ) {
         print "\nTRACK Marker found\n";
         $decoder_state = 'SYNC';
         $marker_expected = 0xFE;
      }

      # IDAM Marker 0xFE
      #
      if( $byte_decoded == 0xFE ) {
         if( $marker_expected != 0xFE ) {
            print "\ERROR: Expecting DATA AM marker 0xFB";
         }
         print "\nIDAM Marker found\n";
         $decoder_state = 'SECTOR_HEADER';
         $marker_expected = 0xFB;
         $idam_cursor = 0;
         $sector_count++;
      }

      # DATA AM Marker 0xFB
      #
      if( $byte_decoded == 0xFB ) {
         if( $marker_expected != 0xFB ) {
            print "\ERROR: Expecting IDAM marker 0xFB";
         }
         $decoder_state = 'SECTOR_DATA';
         $marker_expected = 0xFE;
         $data_cursor = 0;
         print "\nDATA AM Marker found\nDATA $expected_sector_len bytes:\n";
 
      }
   }

   # IDAM Processing
   #
   # IDAM is 6 bytes: Track, Side, Sector, Sector Size, CRC MSB, CRC LSB
   #
   elsif( $decoder_state eq 'SECTOR_HEADER' ) {
      $idam_cursor++;
      if( $idam_cursor < 5 ) {
        $crc_buff = $crc_buff.chr($byte_decoded);
      }
      if( $idam_cursor == 6 ) {
	$crc = crcccitt($crc_buff);
      }
      if( $idam_cursor == 1 ) {
         print "\nTrack number=$byte_decoded\n";
      }
      if( $idam_cursor == 2 ) {
         print "\nSide number=$byte_decoded\n";
      }
      if( $idam_cursor == 3 ) {
         print "\nSector number=$byte_decoded\n";
      }
      if( $idam_cursor == 4 ) {
         $expected_sector_len = $sector_len[$byte_decoded];
         print "\nSector Size=$expected_sector_len Bytes\n";
      }
      if( $idam_cursor == 5 ) {
         $hfe_crc = $byte_decoded << 8;
      }
      if( $idam_cursor == 6 ) {
         $hfe_crc = $hfe_crc | $byte_decoded;
      }
      if( $idam_cursor == 7 ) {
         $gap_len = 0;
         printf "\nDecoded    CRC=0x%04X", $hfe_crc;
         printf "\nCalculated CRC=0x%04X", $crc;
         if( $hfe_crc != $crc ) {
            print " CRC ERROR !!!"
         }
         print "\nGAP2\n";
         $decoder_state = 'SYNC';
      }

   }

   # DATA Processing
   #
   elsif ( $decoder_state eq 'SECTOR_DATA' ) {
      if( $data_cursor < $expected_sector_len ) {
        $crc_buff .= chr($byte_decoded);
      } elsif ( $data_cursor == $expected_sector_len ) {
        $crc = crcccitt($crc_buff);
      }

      if( $data_cursor < $expected_sector_len && ($data_cursor & 0x000F) == 0 ) {
         printf "\n%04X: ", $data_cursor;
      }
      if( $data_cursor < $expected_sector_len ) {    
         print OUT chr($byte_decoded);
         printf "%02X ", $byte_decoded;
      }
   
      if( $data_cursor == $expected_sector_len ) {
         $hfe_crc = $byte_decoded << 8;
      }
      if( $data_cursor == $expected_sector_len+1 ) {
         $hfe_crc = $hfe_crc | $byte_decoded;
      }
      if( $data_cursor == $expected_sector_len+2 ) {
         printf "\nDecoded    CRC=0x%04X", $hfe_crc;
         printf "\nCalculated CRC=0x%04X", $crc;
         if( $hfe_crc != $crc ) {
            print " CRC ERROR !!!"
         }
         $gap_len = 0;
         if( $sector_count == 10 ) {
            print "\nGAP4\n";
         } else {
            print "\nGAP3\n";
         }
         $decoder_state = 'SYNC';
      }
      $data_cursor++;
   }

}

close(IN);
close(OUT);
