	DEVICE ZXSPECTRUM128

	include "defs.asm"
	include "data.asm"

	org 0x6000
	incbin "pal.tsp"
	db 0x00,0x40,0x00,0x00,0x00,0x00	; dummy sprites (3 x leap)
	db 0x00,0x40,0x00,0x00,0x00,0x00
	db 0x00,0x40,0x00,0x00,0x00,0x00

	savebin "page5",0x4000,0x4000

	org 0x817e
	
	jp start

intupt	push af,bc,de,hl
	exx
	exa
	push af,bc,de,hl,ix,iy

	call shiftTiles
	call putSprites
animFlag
	scf
	call nc,animAll

	pop iy,ix,hl,de,bc,af
	exx
	exa
	pop hl,de,bc,af
	ei
	ret

animOn	ld a,0xa7
	ld (animFlag),a
	ret
animOff	ld a,0x37
	ld (animFlag),a
	ret

start	di
	ld hl,0x8000
	ld de,0x8001
	ld bc,0x100
	ld a,h
	ld i,a
	inc a
	ld (hl),a
	ldir
	im 2
	ei
	
	ld bc,0x15af
	ld a,0x10
	out (c),a
	ld hl,0x6000
	ld de,0x0000
	ld bc,0x400
	ldir
	ld bc,0x15af
	xor a
	out (c),a

	ld hl,initPort
	ld c,0xaf
ipo_1	ld a,(hl)
	cp 0xff
	jr z,ipo_ex
	ld b,a
	inc hl
	ld a,(hl)
	inc hl
	out (c),a
	jr ipo_1
ipo_ex	xor a
	call setmap
	call animOn

;game_res
;	ld a,(heroTab + htAniCount)
;	and a
;	call nz,stopHAni
game_cyc
	halt
	ld hl,keyMap
	call inpKeys
;	jr z,game_res
	jr game_cyc
	
inpKeys	ld a,(hl)
	and a
	ret z
	inc hl
	cp 0xff
	jr z,ikeyALL
	in a,(0xfe)
	and (hl)
	inc hl
	jr z,ikeyALL
	inc hl
	inc hl
	jr inpKeys
ikeyALL	ld a,(hl)
	inc hl
	ld h,(hl)
	ld l,a
	jp (hl)

stopHAni
	ld a,(heroTab + htAniCount)
	and a
	ret z
	xor a
	ld (heroTab + htAniCount),a
	ld a,(heroTab + htDir)
	and 3
	ld hl,dirSprTab
	ld ix,heroTab
	ADDA h,l
	ld a,(hl)
	jp setSprite

dirSprTab
	db 7,1,4,1

keyMap	dw 0x01df,movRight
	dw 0x02df,movLeft
	dw 0x01fb,movUp
	dw 0x01fd,movDown
	dw 0x017f,keySpace
	dbw 0xff,stopHAni

movRight
	ld ix,heroTab
	ld a,(ix + htDir)
	ld (ix + htDir),1
	cp 1
	jr nz,mvr01
	ld a,(ix + htAniCount)
	and a
	ret nz
mvr01	ld de,anmHRight
	jp setAnim

movLeft	ld ix,heroTab
	ld a,(ix + htDir)
	ld (ix + htDir),3
	cp 3
	jr nz,mvl01
	ld a,(ix + htAniCount)
	and a
	ret nz
mvl01	ld de,anmHLeft
	jp setAnim

movDown	ld ix,heroTab
	ld a,(ix + htDir)
	ld (ix + htDir),2
	cp 2
	jr nz,mvd01
	ld a,(ix + htAniCount)
	and a
	ret nz
mvd01	ld de,anmHDown
	call setAnim
	ret

movUp	ld ix,heroTab
	ld a,(ix + htDir)
	ld (ix + htDir),0
	and a
	jr nz,mvu01
	ld a,(ix + htAniCount)
	and a
	ret nz
mvu01	ld de,anmHUp
	call setAnim
	ret

	include "game_menu.asm"
	
initPort
	db 0x00,%00100001	; nogfx 256x192 16c
	db 0x06,%11100100	; sen t1en t0en t0zen
	db 0x07,%00000000	; t0pal 0; t1pal 0; gpal 0
	db 0x0f,0xf0		; border 0xf0 (black)
	db 0x17,0x08	; t0gpage
	db 0x18,0x08	; t1gpage
	db 0x19,0x18	; sgpage
	db 0xff

setbank	ld (curbank),a
	push bc
	ld bc,0x13af
	out (c),a
	pop bc
	ret

curbank	db 0

setmap	ld (curmap),a
	add a,0x20
	ld (mapbank),a
	ld bc,0x16af
	out (c),a
	ret

curmap	db 0
mapbank	db 0x20

shiftTiles
	ld hl,(heroTab + htPosX)
	ld de,120
	ld bc,256
	ld a,0x40
	call stil_sub
	ld (xscr),hl
	ld hl,(heroTab + htPosY)
	ld de,88
	ld bc,320
	ld a,0x42
	call stil_sub
	ld (yscr),hl
	ret
stil_sub
	and a
	sbc hl,de
	jr c,stil_z
	sbc hl,bc
	jr nc,stil_bc
	add hl,bc
	jr stil_out
stil_bc	ld h,b
	ld l,c
	jr stil_out	
stil_z	ld hl,0
stil_out
	ld b,a
	ld c,0xaf
	out (c),l
	inc b
	out (c),h
	inc b
	inc b
	inc b
	out (c),l
	inc b
	out (c),h
	ret

xscr	dw 0
yscr	dw 0

putSprites	ld ix,heroTab
	ld hl,0x6201
	ld (hl),0x40
	ld l,6
puts_cyc	ld a,(ix)
	cp 0xff
	jr z,puts_sort
	ld a,(curmap)
	cp (ix+1)
	jr nz,puts_next
	ex de,hl
	ld l,(ix + htPosY)
	ld h,(ix + htPosYh)
	ld bc,(yscr)
	and a
	sbc hl,bc
	ex de,hl
	ld a,d
	and 0x01
	or 0x20		; act
	ld c,a		; ysize
	ld a,(ix + htSizeY)
	sub 8
	rra
	rra
	and 0x0e
	or c
	ld (hl),e
	inc hl
	ld (hl),a
	inc hl
	ex de,hl
	ld l,(ix + htPosX)
	ld h,(ix + htPosXh)
	ld bc,(xscr)
	and a
	sbc hl,bc
	ex de,hl
	ld a,d
	and 0x01
	ld c,a		; xsize
	ld a,(ix + htSizeX)
	sub 8
	rra
	rra
	and 0x0e
	or c
	ld d,(ix + htDir)
	dec d
	jr nz,puts01
	or 0x80
puts01	ld (hl),e
	inc hl
	ld (hl),a
	inc hl
	ld e,(ix + htTileNum)
	ld d,(ix + htTileNumh)
	ld a,d
	and 0x0f
	or (ix + htPal)
	ld (hl),e
	inc hl
	ld (hl),a
	inc hl
puts_next	ld de,heroDscSize
	add ix,de
	jr puts_cyc

puts_sort	ld de,6
	inc hl
	ld (hl),0x40
	add hl,de
	ld (hl),0x40
	add hl,de
	ld (hl),0x40
psrt_1	ld c,0
	ld ix,0x6206
psrt_1a	ld a,(ix+7)		; check next is leap
	and 0x40
	jr nz,psrt_x
	ld a,(ix+1)		; hl:currentY
	and 1
	ld h,a
	ld l,(ix)
	ld a,(ix+7)		; de:nextY
	and 1
	ld d,a
	ld e,(ix+6)
	and a		; check hl <= de
	sbc hl,de
	jr c,psrt_nx
	ld a,h
	or l
	jr z,psrt_nx

	ld e,lx		; swap (ix, ix+6, 6)
	ld d,hx
	ld hl,6
	add hl,de
	ld b,6
psrt_2	ld a,(de)
	exa
	ld a,(hl)
	ld (de),a
	exa
	ld (hl),a
	inc hl
	inc de
	djnz psrt_2
	ld c,1
psrt_nx	ld de,6
	add ix,de
	jr psrt_1a
psrt_x	ld a,c
	and a
	jr nz,psrt_1

	ld bc,0x15af
	ld a,0x10
	out (c),a
	ld hl,0x6200
	ld de,0x0200
	ld bc,0x200
	ldir
	ld bc,0x15af
	xor a
	out (c),a
	ret

noKey	xor a
	in a,(0xfe)
	cpl
	and 0x1f
	jr nz,noKey
	ret
	
waitKey	xor a
	in a,(0xfe)
	cpl
	and 0x1f
	jr z,waitKey
	ret

div8	and a
	rr h
	rr l
	rr h
	rr l
	rr h
	rr l
	ret

	include "animate.asm"
	include "checks.asm"
	include "vars.asm"
	
	savebin "page2",0x8000,0x4000
