program Simplex_method;

{uses CRT,PRINTER;}

const
  HEADTXT1='SIMPLEX Ver 1.03 (C) 15.Mar.1993 ASC';
  HEADTXT2='Resolving task of linear programming';

type
  DHEX=string[2];
  DSTR=string[5];
  ISTR=string[255];

const
  MAXVAR=10;
  MAXEQU=20;

  VA=10;
  VF=3;

  EPSP=0.001;
  EPSM=-0.001;

var
  FL_NAM,IN_NAM,OT_NAM: string[20];
  IN_FIL,OT_FIL: text;
  ILIN: ISTR;
  I,J,K,NPAR,PPOS: integer;
  CH: char;
  OT_DEV: (CON,FIL,PRN);

  SYNTAX: (OKAY,INWR,MNMX);
  MAXTSK,VALIDS: boolean;
  NUMVAR,NUMBAS: 1..MAXVAR;
  NUMEQU: 1..MAXEQU;
  VAR_NAMES: array [1..MAXVAR] of string[2];
  SIM_TABLE: array [1..MAXEQU,0..MAXVAR] of real;
  BASVAR: array [1..MAXEQU] of 1..MAXVAR;
  VARSTT: array [1..MAXVAR] of 1..MAXEQU;
  ITERAT: integer;
  LEDVAR,OUTVAR: 1..MAXVAR;
  LEDVAL: real;
  LEDEQU: 1..MAXEQU;

function DCHR(var I:integer; SUB: integer): char;
var D: byte;
begin
D:=ord('0');
while (I>=SUB) or (I<0) do begin I:=I-SUB; D:=succ(D) end;
DCHR:=chr(D)
end;

function DPRINT(VALUE: integer): DSTR;
var
  I: integer;
  DPR: DSTR;
begin
I:=VALUE;
DPR:=DCHR(I,10000)+DCHR(I,1000)+DCHR(I,100)
    +DCHR(I,10)+DCHR(I,1);
I:=1;
while (DPR[I]='0') and (I<5) do
  begin DPR[I]:=' '; I:=succ(I) end;
DPRINT:=DPR
end;

function HEX(VAL: byte): DHEX;
var
  TVL: byte;
  THX: char;
begin
TVL:=VAL div 16;
THX:=chr(48+TVL+7*byte(TVL>9));
TVL:=VAL mod 16;
HEX:=THX+chr(48+TVL+7*byte(TVL>9))
end;

procedure SEELINE(var ILIN: ISTR);
type
  ItemClass=(NTH,NAM,NUM,SGN,EQU,ERR);
const
  ItemChSets: array [NTH..ERR,1..2] of set of char=(
    ([],[]),
    (['A'..'Z'],['A'..'Z','0'..'9']),
    (['0'..'9'],['0'..'9','.']),
    (['+','-'],[]),
    (['='],[]),
    ([#$00..#$FF],[#$00..#$FF]));

var
  InpPtr: integer;
  ITMS: ISTR;
  ITEM,PITEM: ItemClass;
  TVAR,I: integer;
  TVAL,SVAL: real;
procedure GETITEM;
var
  LITEM: ItemClass;
  LCNT,I: integer;
begin
ITEM:=NTH;
LITEM:=NTH;
ITMS:='';
LCNT:=1;
while (ITEM=LITEM) and (ITEM<>ERR) and (InpPtr<=length(ILIN)) do
  begin
  LITEM:=ITEM;
  while not(ILIN[InpPtr] in ItemChSets[LITEM,LCNT]) do
    LITEM:=succ(LITEM);
  if ITEM=NTH then begin ITEM:=LITEM; LCNT:=2 end;
  if ITEM=LITEM then
    begin
    ITMS:=ITMS+ILIN[InpPtr];
    InpPtr:=succ(InpPtr)
    end;
  end
end;

begin
SYNTAX:=OKAY;
InpPtr:=1;
PITEM:=NTH;
TVAR:=0;
TVAL:=1.0;
SVAL:=1.0;
repeat
  GETITEM;
  case ITEM of
    NTH: SIM_TABLE[NUMEQU,TVAR]:=SVAL*TVAL;
    NAM:
      begin
      TVAR:=0;
      for I:=1 to NUMVAR do if VAR_NAMES[I]=ITMS then TVAR:=I;
      if TVAR=0 then
        begin
        NUMVAR:=succ(NUMVAR);
        TVAR:=NUMVAR;
        VAR_NAMES[TVAR]:=ITMS
        end;
      SIM_TABLE[NUMEQU,TVAR]:=SVAL*TVAL;
      SVAL:=1.0;
      TVAL:=1.0
      end;
    NUM: val(ITMS,TVAL,I);
    SGN: if ITMS='-' then SVAL:=-1.0;
    EQU: begin TVAR:=0; SVAL:=1.0; TVAL:=1.0 end
    end;
until (ITEM=NTH) or (ITEM=ERR)
end;

procedure WRTHOR;
begin
for I:=1 to 6+NUMVAR*VA+7 do write(OT_FIL,'');
writeln(OT_FIL)
end;

procedure WRTEQU(EQU: integer);
var I: integer;
begin
write(OT_FIL,VAR_NAMES[BASVAR[EQU]]:2,':');
for I:=1 to NUMVAR do
  write(OT_FIL,SIM_TABLE[EQU,I]:VA:VF);
writeln(OT_FIL,SIM_TABLE[EQU,0]:VA:VF)
end;

procedure WRTTAB;
var I: integer;
begin
WRTHOR;
WRTEQU(1);
WRTHOR;
for I:=2 to NUMEQU do WRTEQU(I);
WRTHOR
end;

procedure DEFLEDVAR;
var I: integer;
begin
LEDVAR:=0;
LEDVAL:=0.0;
for I:=2 to NUMVAR do
  if VARSTT[I]=0 then
    case MAXTSK of
      true: if SIM_TABLE[1,I]<LEDVAL then
              begin LEDVAR:=I; LEDVAL:=SIM_TABLE[1,I] end;
      false:if SIM_TABLE[1,I]>LEDVAL then
              begin LEDVAR:=I; LEDVAL:=SIM_TABLE[1,I] end;
      end;
end;

procedure DEFLEDEQU;
var
  I: integer;
  TDIV: real;
begin
LEDEQU:=0;
LEDVAL:=MAXINT;
for I:=2 to NUMBAS do
  if SIM_TABLE[I,LEDVAR]>0 then
    begin
    TDIV:=SIM_TABLE[I,0]/SIM_TABLE[I,LEDVAR];
    if TDIV<LEDVAL then
      begin
      LEDEQU:=I;
      LEDVAL:=TDIV
      end;
    end;
end;

procedure NEWLEDEQU;
var I: integer;
begin
for I:=0 to NUMVAR do
  if I<>LEDVAR then SIM_TABLE[LEDEQU,I]:=
    SIM_TABLE[LEDEQU,I]/SIM_TABLE[LEDEQU,LEDVAR];
SIM_TABLE[LEDEQU,LEDVAR]:=1.0
end;

procedure NEWSIMEQU;
var I,J: integer;
begin
for I:=1 to NUMEQU do
  if I<>LEDEQU then
    begin
    for J:=0 to NUMVAR do
      if J<>LEDVAR then SIM_TABLE[I,J]:=SIM_TABLE[I,J]-
        SIM_TABLE[I,LEDVAR]*SIM_TABLE[LEDEQU,J];
    SIM_TABLE[I,LEDVAR]:=0.0
    end;
end;

function EQUZ(V: real): boolean;
begin
EQUZ:=(V<EPSP) and (V>EPSM)
end;

procedure CHECKSIM;
var
  I,J: integer;
  F: boolean;
begin
VALIDS:=true;
F:=false;
I:=1;
repeat
  I:=succ(I);
  F:=EQUZ(SIM_TABLE[I,0])
until (I=NUMEQU) or F;
if F then writeln(OT_FIL,'஦ 襭');

F:=false;
I:=1;
repeat
  I:=succ(I);
  if VARSTT[I]=0 then F:=EQUZ(SIM_TABLE[1,I]);
until (I=NUMVAR) or F;
if F then writeln(OT_FIL,' ୠ⨢ 襭');

{
F:=false;
I:=1;
repeat
  I:=succ(I);
  J:=1;
  repeat
    J:=succ(J);
    if VARSTT[J]=0 then F:=SIM_TABLE[I,J]<=0;
  until (J=NUMVAR) or F
until (I>NUMEQU) or F;
if F then
  begin
  VALIDS:=false;
  writeln(OT_FIL,'࠭祭 ࠭⢮ 襭');
  case MAXTSK of
    true: F:=SIM_TABLE[1,J]<0.0;
    false:F:=SIM_TABLE[1,J]>0.0;
    end;
  if F then writeln(OT_FIL,'࠭祭 楫 㭪');
  end;
}

end;

procedure CHECKPRM;
var
  I: integer;
  F: boolean;
begin
I:=1;
repeat
  I:=succ(I);
  F:=(pos('R',VAR_NAMES[BASVAR[I]])>0) and (SIM_TABLE[I,0]<>0.0)
until (I=NUMEQU) or F;
if F then
  begin
  VALIDS:=false;
  writeln(OT_FIL,'⢥ ६',VAR_NAMES[BASVAR[I]]:3,'<>0.0')
  end;
end;

begin
writeln(HEADTXT1);
writeln(HEADTXT2);
writeln;
NPAR:=paramcount;
if not(NPAR in [1..2]) then
  begin
  writeln('Invalid parameters');
  writeln;
  writeln('Call me:');
  writeln('SIMPLEX [d:]filename[.TLP] [d: | PRN | filename[.TRS]]');
  exit
  end;
FL_NAM:=paramstr(1);
PPOS:=pos('.',FL_NAM);
if (PPOS=0) and (length(FL_NAM)>10) then
  begin
  writeln('Invalid source filename');
  exit
  end;
IN_NAM:=FL_NAM;
if PPOS>0 then FL_NAM:=copy(FL_NAM,1,PPOS-1);
if NPAR=2 then
  begin
  OT_NAM:=paramstr(2);
  if (length(OT_NAM)=2) and (OT_NAM[2]=':') then
    begin
    PPOS:=pos(':',FL_NAM);
    if PPOS>0 then FL_NAM:=copy(FL_NAM,PPOS+1,length(FL_NAM)-PPOS);
    OT_NAM:=OT_NAM+FL_NAM
    end;
  end
else OT_NAM:=FL_NAM;
for I:=1 to LENGTH(IN_NAM) do IN_NAM[I]:=upcase(IN_NAM[I]);
for I:=1 to LENGTH(OT_NAM) do OT_NAM[I]:=upcase(OT_NAM[I]);
if pos('.',IN_NAM)=0 then IN_NAM:=IN_NAM+'.TLP';
if OT_NAM<>'PRN' then
  begin
  if pos('.',OT_NAM)=0 then OT_NAM:=OT_NAM+'.TRS';
  OT_DEV:=FIL
  end
else OT_DEV:=PRN;

{$I-}
assign(IN_FIL,IN_NAM);
reset(IN_FIL);
I:=ioresult;
if I<>0 then
  begin
  case I of
    1: writeln('No source file');
    2: writeln('Can''t open SOURCE file')
    else writeln('Disk I/O error')
    end;
  exit
  end;

if OT_DEV=FIL then
  begin
  assign(OT_FIL,OT_NAM);
  rewrite(OT_FIL);
  I:=ioresult;
  if I<>0 then
    begin
    case I of
      3: writeln('Can''t open DESTIN file')
      else writeln('Disk I/O error')
      end;
    exit
    end;
  {$I+}
  end;

writeln('Convert  file ',IN_NAM);
writeln('Into file/dev ',OT_NAM);
writeln;

writeln(OT_FIL,^O,HEADTXT1);
writeln(OT_FIL,HEADTXT2);
writeln(OT_FIL);

write('Reading source data ...');

readln(IN_FIL,ILIN);
writeln(OT_FIL,ILIN);
if ILIN='MAX' then MAXTSK:=true
  else if ILIN='MIN' then MAXTSK:=false
    else begin
      writeln('Direction of task not defined:');
      writeln(ILIN);
      close(IN_FIL);
      if OT_DEV=FIL then begin close(OT_FIL); erase(OT_FIL) end;
      end;
for I:=1 to MAXEQU do for J:=0 to MAXVAR do SIM_TABLE[I,J]:=0.0;

NUMVAR:=0;
NUMEQU:=0;
SYNTAX:=OKAY;
while (SYNTAX=OKAY) and not eof(IN_FIL) do
  begin
  readln(IN_FIL,ILIN);
  writeln(OT_FIL,ILIN);
  NUMEQU:=succ(NUMEQU);
  SEELINE(ILIN)
  end;

writeln(' O.K.');

for I:=1 to NUMVAR do VARSTT[I]:=0;

write('Computing SIMPLEX tables ...');

NUMBAS:=1;
BASVAR[NUMBAS]:=1;
for I:=2 to NUMVAR do
  if (SIM_TABLE[1,I]=0.0) and
     (SIM_TABLE[succ(NUMBAS),I]<>0.0) then
    begin
    NUMBAS:=succ(NUMBAS);
    BASVAR[NUMBAS]:=I;
    VARSTT[I]:=NUMBAS
    end;

writeln(OT_FIL);
write(OT_FIL,'');
for I:=1 to NUMVAR do write(OT_FIL,' ':2,VAR_NAMES[I]:2,' ':VA-4);
writeln(OT_FIL,'襭');

ITERAT:=0;
repeat
WRTTAB;
writeln(OT_FIL,':',ITERAT:3,' ':15,'饥 襭:',SIM_TABLE[1,0]:VA:VF);
CHECKSIM;
if VALIDS then
  begin
  DEFLEDVAR;
  if LEDVAR>0 then
    begin
    DEFLEDEQU;
    if LEDEQU>0 then
      begin
      ITERAT:=succ(ITERAT);
      OUTVAR:=BASVAR[LEDEQU];
      writeln(OT_FIL,' ६:',VAR_NAMES[LEDVAR]:3,
        '    뢮 ६:',VAR_NAMES[OUTVAR]:3);
      VARSTT[OUTVAR]:=0;
      VARSTT[LEDVAR]:=LEDEQU;
      BASVAR[LEDEQU]:=LEDVAR;
      NEWLEDEQU;
      NEWSIMEQU;
      end;
    end;
  end;
until (LEDVAR=0) or (LEDEQU=0) or not VALIDS;

CHECKPRM;

writeln(OT_FIL);
if VALIDS then
  writeln(OT_FIL,'⨬쭮 襭:',VAR_NAMES[1]:3,'=',SIM_TABLE[1,0]:VA:VF)
  else writeln(OT_FIL,' ⨬쭮 襭');

close(IN_FIL);
if OT_DEV=FIL then close(OT_FIL);
writeln; writeln;
writeln('End of resolving. Have a nice work !!!')
end.
