; Chameleon DOS 7.7
; Disassebled by PortaOne, Inc. 2014
;

	CPU Z80

; RAM Locations
;

Read_Buffer:	EQU $BD00			
End_Of_DIR_Work_Area: EQU $BD11	
File_Name_Buffer: EQU $BE00
KYB_BEEP:	EQU $BE1E
File_Name:	EQU $BE1F
File_Status:	EQU $BE2A			
File_First_Sector:EQU $BE2B
File_First_Track: EQU $BE2C	
File_Start_RAM:	EQU $BE2D		
File_Sector_Length: EQU $BE2F
BORDER:		EQU $BE38 
unk_BE3A:	EQU $BE3A
unk_BE40:	EQU $BE40
Stack_TOP_2:	EQU $BE80
RAM_Start_Address: EQU $BEA4
RAM_End_Address: EQU $BEA6
CODFL_RUN:	EQU $BEA9
Disk_Attributes: EQU $BED0
Disk_First_Free_Sector: EQU $BEDB
Disk_First_Free_Track: EQU $BEDC
Disk_Hidden_DIR_Flag: EQU $BEDE
Disk_Write_Protection: EQU $BEDF
unk_BEF0:	EQU $BEF0
LOAD_ERR:	EQU $BEF1
INIT_STACK_TOP:	EQU $BF99
Track_Number:	EQU $BFB0
Sector_Number:	EQU $BFB1
Disk_Side:	EQU $BFB2
Physical_Track_Number: EQU $BFB3
Drive_Number:	EQU $BFB4
File_RUN_Flag:	EQU $BFB5
Sector_Length:	EQU $BFB6
Current_Drive_Number: EQU $BFB7
Sectors_Per_Track: EQU $BFB8
Dencity_Bit:	EQU $BFB9
JMP_Command_Line_Prompt: EQU $BFE8
Command_Line_Prompt_Vector: EQU $BFE9
JMP_Hot_Start_Vector: EQU $BFEB
Hot_Start_Vector_Address: EQU $BFEC

; SYS ROM Routines
;

SYS_MEM_TEST_Cont: EQU $E043
SYS_SYS_RESET:	EQU $E0F5
SYS_MEMCOPY:	Equ $E11F
SYS_RAM_FILL:	EQU $E12A
SYS_PRINT_ROM_CHKSUM: EQU $E14A
SYS_LONG_DELAY:	EQU $E260
SYS_CMP_DE_HL:	EQU $E425
SYS_PUTS:	EQU $E4A4
SYS_DELAY:	EQU $E5FB
SYS_COPY_SCR_To_PRN: EQU $E627
SYS_CRH_To_PRN:	EQU $E6A3
SYS_ESC_CRH_To_PRN: EQU $E6AA
SYS_CLS:	EQU $EBD0
SYS_GETCH: EQU $F803
SYS_GETCH2: EQU $F806
SYS_PUTCH: EQU $F809

		org 0C000h

Hardware_Reset_Vector:
		jp	Cold_Start

; =============== S U B	R O U T	I N E =======================================

; Read Sector from disk

Read_Sector:				; CODE XREF: Read_N_Sectors:Read_Next_Sectorp
					; Seek_Track_And_Read_Sector+7p ...

; FUNCTION CHUNK AT C530 SIZE 00000009 BYTES

		ld	b, 20h ; ' '

Retry_Read_Sector:			; CODE XREF: Read_Sector+Fj
		di
		push	hl
		call	sub_C018
		pop	hl
		in	a, (0E0h)	; Read VG93 Status
		and	11100b		; Record Not Found, CRC	Error, Lost Data
		ei
		ret	z		; READ OK !!!
		dec	b
		jp	nz, Retry_Read_Sector
		jp	Print_IO_ERROR_Message
; End of function Read_Sector


; =============== S U B	R O U T	I N E =======================================


sub_C018:				; CODE XREF: Read_Sector+4p

; FUNCTION CHUNK AT C7E6 SIZE 0000000E BYTES

		ld	a, (Sector_Number) ; BFB1
		out	(0E2h),	a	; Load VG93 Sector register
		jp	loc_C023	; IRQ/DRQ Status Bitmask
; ---------------------------------------------------------------------------
		db 0C3h	; 
		db  25h	; %
		db 0E4h	; 
; ---------------------------------------------------------------------------

loc_C023:				; CODE XREF: sub_C018+5j
		ld	c, 0C0h	; ''   ; IRQ/DRQ Status Bitmask
		ld	a, (Disk_Side)	; Disk Side
		or	a
		ld	a, 82h ; ''    ; Read Single Sector, Side 0, Compare Side
		jp	z, loc_C030
		ld	a, 8Ah ; ''    ; Read Single Sector, Side 1, Compare Side

loc_C030:				; CODE XREF: sub_C018+13j
		call	VG93_Command_and_Delay
		jp	VG93_Read_Data_Feed
; End of function sub_C018

; ---------------------------------------------------------------------------
		db 0FFh
		db 0FFh
		db 0FFh
		db 0FFh

; =============== S U B	R O U T	I N E =======================================

; Write	Sector to disk

Write_Sector:				; CODE XREF: Calc_Next_Sec_And_Tr_Numbers:Write_Next_Sectorp
					; Seek_Track_And_Write_Sector+7p ...

; FUNCTION CHUNK AT C105 SIZE 00000007 BYTES

		ld	b, 20h ; ' '

loc_C03C:				; CODE XREF: Write_Sector+CCj
		di
		push	hl
		call	sub_C04B
		pop	hl
		in	a, (0E0h)	; Read VG93 Status
		and	1111100b	; Write	Protect, Write Fault, Record Not Found,	CRC Error, Lost	Data
		ei
		ret	z		; WRITE	OK !!!
		jp	Retry_Write_Sector
; End of function Write_Sector


; =============== S U B	R O U T	I N E =======================================


sub_C04B:				; CODE XREF: Write_Sector+4p
		ld	a, (Sector_Number) ; BFB1
		out	(0E2h),	a	; Load sector number to	VG93
		ld	c, 0C0h	; ''   ; Bit7, Bit6 bitmask for IRQ/DRQ Status Register
		ld	a, (Disk_Side)	; BFB2
		or	a
		ld	a, 0A2h	; ''   ; Write Single Sector, Side 0, Compare Side
		jp	z, loc_C05D	; Load Command to VG93
		ld	a, 0AAh	; ''   ; Write Single Sector, Side 0, Compare Side

loc_C05D:				; CODE XREF: sub_C04B+Dj
		call	VG93_Command_and_Delay ; Load Command to VG93

VG93_Write_Data_Feed:			; CODE XREF: sub_C04B+18j sub_C04B+1Fj
		in	a, (0E4h)	; Read IRQ/DRQ Status, Apply Mask, Wait	for DRQ
		and	c
		jp	z, VG93_Write_Data_Feed	; Read IRQ/DRQ Status, Apply Mask, Wait	for DRQ
		ld	a, (hl)		; Next Data byte
		out	(0E3h),	a	; Load VG93 DR
		inc	hl		; Next address in write	buffer
		jp	p, VG93_Write_Data_Feed	; IRQ=Bit7=0 Repeat
		ret
; End of function sub_C04B


; =============== S U B	R O U T	I N E =======================================

; ⠭  ᪮  ॡ ஦.
; ।	饭 ᨬ  祩 :
; BFB0 -  ஦ (0-165),
; BFB4 -  ᪮ (0-, 1-, 2-, 3-D).

Seek_Track:				; CODE XREF: Read_N_Sectorsp
					; Calc_Next_Sec_And_Tr_Numbers:Write_N_Sectorsp ...

; FUNCTION CHUNK AT C632 SIZE 00000024 BYTES

		push	hl
		push	bc
		ld	c, 0Ah		; Retry	Counter
		ld	hl, Current_Drive_Number ; Current drive number
		ld	a, (Drive_Number) ; Desired Drive number
		cp	(hl)
		jp	z, NO_Drive_Change ; Logical Track number to Physical Track Number + Side Number Translation
		ld	(hl), a

Select_Drive_Retry:			; CODE XREF: Seek_Track+5E2j
		call	Select_Drive	; Change drive

NO_Drive_Change:			; CODE XREF: Seek_Track+Bj
		ld	a, (Track_Number) ; Logical Track number to Physical Track Number + Side Number	Translation
		or	a
		rra
		ld	(Physical_Track_Number), a ; BFB3
		ld	a, 0
		rla
		ld	(Disk_Side), a	; BFB2
		or	a
		ld	a, (hl)		; Current Drive	Number
		ld	b, 0Ch		; For Side 0
		jp	nz, loc_C097	; Combine Side and Drive Numbers for OUT E4
		ld	b, 1Ch		; For Side 1

loc_C097:				; CODE XREF: Seek_Track+24j
		or	b		; Combine Side and Drive Numbers for OUT E4
		ld	b, a
		inc	hl
		inc	hl		; HL = BFB9
		ld	a, (hl)
		or	a		; Dencity Bit (FM/MFM) for OUT E4
		jp	z, MFM_Seek

MFM_Seek_Failure:			; CODE XREF: Seek_Track+5D3j
		ld	a, b		; Switch to FM mode
		xor	40h ; '@'
		call	Select_Side_And_Track
		jp	Select_FM_Mode
; End of function Seek_Track

; ---------------------------------------------------------------------------
		db    0

; =============== S U B	R O U T	I N E =======================================


Read_N_Sectors:				; CODE XREF: Read_N_Sectors+14j
					; Read_File+Cp	...
		call	Seek_Track	; ⠭  ᪮  ॡ ஦.
					; ।	饭 ᨬ  祩 :
					; BFB0 -  ஦ (0-165),
					; BFB4 -  ᪮ (0-, 1-, 2-, 3-D).

Read_Next_Sector:			; CODE XREF: Read_N_Sectors+11j
		call	Read_Sector	; Read Sector from disk
		ld	a, (Sector_Length) ; BFB6
		dec	a
		ret	z
		ld	(Sector_Length), a ; BFB6
		call	Calc_Next_Sec_And_Tr_Numbers
		jp	c, Read_Next_Sector
		jp	Read_N_Sectors
; End of function Read_N_Sectors


; =============== S U B	R O U T	I N E =======================================


Calc_Next_Sec_And_Tr_Numbers:		; CODE XREF: Read_N_Sectors+Ep
					; Calc_Next_Sec_And_Tr_Numbers+29p
		ld	bc, 256
		add	hl, bc
		push	hl
		ld	hl, Sector_Number ; BFB1
		ld	a, (Sectors_Per_Track) ; BFB8
		inc	(hl)
		cp	(hl)
		jp	nc, Same_Track
		ld	(hl), 1
		dec	hl		; Now HL points	to Track_Number
		ld	a, (hl)
		cp	164		;  Max track number? 82*2
		jp	IO_ERROR?
; ---------------------------------------------------------------------------
		db 0FFh
		db 0FFh
; ---------------------------------------------------------------------------

Write_N_Sectors:			; CODE XREF: Calc_Next_Sec_And_Tr_Numbers+2Fj
					; Write_File+2Fp ...
		call	Seek_Track	; ⠭  ᪮  ॡ ஦.
					; ।	饭 ᨬ  祩 :
					; BFB0 -  ஦ (0-165),
					; BFB4 -  ᪮ (0-, 1-, 2-, 3-D).

Write_Next_Sector:			; CODE XREF: Calc_Next_Sec_And_Tr_Numbers+2Cj
		call	Write_Sector	; Write	Sector to disk
		ld	a, (Sector_Length) ; BFB6
		dec	a
		ret	z
		ld	(Sector_Length), a ; BFB6
		call	Calc_Next_Sec_And_Tr_Numbers
		jp	c, Write_Next_Sector
		jp	Write_N_Sectors
; ---------------------------------------------------------------------------

IO_ERROR?:				; CODE XREF: Calc_Next_Sec_And_Tr_Numbers+16j
		jp	nc, Print_IO_ERROR_Message
		inc	(hl)		; Next track

Same_Track:				; CODE XREF: Calc_Next_Sec_And_Tr_Numbers+Dj
		ccf
		pop	hl
		ret
; End of function Calc_Next_Sec_And_Tr_Numbers

; ---------------------------------------------------------------------------
; START	OF FUNCTION CHUNK FOR Select_Side_And_Track

VG93_Execute_Command:			; CODE XREF: Select_Side_And_Track+Cj
		call	VG93_Command_and_Delay
		call	Wait_VG93_Ready_Status
		in	a, (0E0h)
		and	11000b		; Seek Error, CRC Error	(Index field on	verification)
		ret
; END OF FUNCTION CHUNK	FOR Select_Side_And_Track
; ---------------------------------------------------------------------------
; START	OF FUNCTION CHUNK FOR Write_Sector

Retry_Write_Sector:			; CODE XREF: Write_Sector+Ej
		dec	b
		jp	nz, loc_C03C
		jp	Print_IO_ERROR_Message
; END OF FUNCTION CHUNK	FOR Write_Sector
; ---------------------------------------------------------------------------
		db 0FFh
		db 0FFh

; =============== S U B	R O U T	I N E =======================================


Seek_Track_And_Read_Sector:		; CODE XREF: Read_File_Attributes:Read_Next_DIR_Sectorp
					; Read_Disk_Attr+8p ...
		call	Seek_Track	; ⠭  ᪮  ॡ ஦.
					; ।	饭 ᨬ  祩 :
					; BFB0 -  ஦ (0-165),
					; BFB4 -  ᪮ (0-, 1-, 2-, 3-D).

loc_C111:				; CODE XREF: sub_C2AE+Ap
		push	hl
		ld	hl, Read_Buffer	; BD00
		call	Read_Sector	; Read Sector from disk
		pop	hl
		ret
; End of function Seek_Track_And_Read_Sector


; =============== S U B	R O U T	I N E =======================================


Seek_Track_And_Write_Sector:		; CODE XREF: Write_File+29p
					; Write_File+5Bp ...
		push	hl
		ld	hl, Read_Buffer	; BD00
		call	Seek_Track	; ⠭  ᪮  ॡ ஦.
					; ।	饭 ᨬ  祩 :
					; BFB0 -  ஦ (0-165),
					; BFB4 -  ᪮ (0-, 1-, 2-, 3-D).
		call	Write_Sector	; Write	Sector to disk
		pop	hl
		ret
; End of function Seek_Track_And_Write_Sector


; =============== S U B	R O U T	I N E =======================================


Read_File_Attributes:			; CODE XREF: Read_File:_Read_Filep
					; Write_File+Bp ...

; FUNCTION CHUNK AT C17F SIZE 0000000D BYTES

		xor	a
		ld	(Track_Number),	a ; Track 0
		inc	a
		ld	(Sector_Number), a ; Sector 1

Read_Next_DIR_Sector:			; CODE XREF: Read_File_Attributes+2Fj
		call	Seek_Track_And_Read_Sector
		ld	hl, Read_Buffer	; BD00

Next_File_Name:				; CODE XREF: Read_File_Attributes+23j
		push	hl
		push	de
		call	Compare_File_Names ; Compare File Names
					; A=0 DIR end
					; A=1 Match
					; A=2 Missmatch
		pop	de
		pop	hl
		or	a
		ret	z
		cp	1
		jp	z, Copy_File_Attributes
		ld	bc, 11h
		add	hl, bc
		ld	a, l
		cp	0FFh
		jp	nz, Next_File_Name
		ld	a, (Sector_Number) ; BFB1
		inc	a
		ld	(Sector_Number), a ; BFB1
		cp	0Ah		; DIR End reached ? Directory sectors are 1 - 9
		jp	c, Read_Next_DIR_Sector
; End of function Read_File_Attributes

; START	OF FUNCTION CHUNK FOR Compare_File_Names

loc_C158:				; CODE XREF: Compare_File_Names+7j
		ld	a, 2
		ret
; END OF FUNCTION CHUNK	FOR Compare_File_Names

; =============== S U B	R O U T	I N E =======================================

; Compare File Names
; A=0 DIR end
; A=1 Match
; A=2 Missmatch

Compare_File_Names:			; CODE XREF: Read_File_Attributes+10p

; FUNCTION CHUNK AT C158 SIZE 00000003 BYTES

		ld	a, (hl)
		or	a
		ret	z
		ld	c, 0Bh		; File length+ Extension length	8+3+1

loc_C160:				; CODE XREF: Compare_File_Names:loc_C179j
		ld	a, (de)
		cp	(hl)
		jp	nz, loc_C158
		inc	hl
		inc	de
		dec	c
		jp	loc_C179
; ---------------------------------------------------------------------------
		db    0
		db  7Bh	; {
		db 0FEh	; 
		db 0FFh
		db 0CAh	; 
		db  5Ch	; \
		db    6
		db 0B8h	; 
		db 0DAh	; 
		db  65h	; e
		db 0F0h	; 
		db 0C3h	; 
		db  68h	; h
		db 0F1h	; 
; ---------------------------------------------------------------------------

loc_C179:				; CODE XREF: Compare_File_Names+Dj
		jp	nz, loc_C160
		ld	a, 1		; File name matched
		ret
; End of function Compare_File_Names

; ---------------------------------------------------------------------------
; START	OF FUNCTION CHUNK FOR Read_File_Attributes

Copy_File_Attributes:			; CODE XREF: Read_File_Attributes+19j
		ex	de, hl
		ld	hl, File_Name	; BE1F
		ld	bc, 17
		call	SYS_MEMCOPY
		ld	a, 1
		ret
; END OF FUNCTION CHUNK	FOR Read_File_Attributes

; =============== S U B	R O U T	I N E =======================================


Read_File:				; CODE XREF: ROM:C439p	ROM:C625p ...
		ld	de, File_Name	; BE1F

_Read_File:				; CODE XREF: RUN_COMMAND_COM+7j
		call	Read_File_Attributes
		cp	1
		ret	nz
		call	Copy_File_Attr
		call	Read_N_Sectors
		ld	hl, (File_Start_RAM) ; BE2D
		call	Test_RUN_Flag
		ret	z
		pop	af
		jp	(hl)
; End of function Read_File


; =============== S U B	R O U T	I N E =======================================


Copy_File_Attr:				; CODE XREF: Read_File+9p
					; Write_File+2Cp
		ld	a, (File_First_Sector) ; BE2B
		ld	(Sector_Number), a ; BFB1
		ld	a, (File_First_Track) ;	BE2C
		ld	(Track_Number),	a ; BFB0
		ld	a, (File_Sector_Length)	; BE2F
		ld	(Sector_Length), a ; BFB6
		ld	hl, (File_Start_RAM) ; BE2D
		ret
; End of function Copy_File_Attr


; =============== S U B	R O U T	I N E =======================================

; ⥭ ਡ⮢ ᪠   BED0-BEDF.
; ।	饭:
; BED0-BEDA -  ᪠,
; BEDB - 	᢮ ᥪ  ᪥,
; BEDC - ࢠ	᢮ ஦  ᪥,
; BEDD - unknown
; BEDE - hidden	directory
; BEDF - 		SAVE.

Read_Disk_Attr:				; CODE XREF: Write_Filep Print_DIRp ...
		xor	a
		ld	(Track_Number),	a ; Track 0
		inc	a
		ld	(Sector_Number), a ; Sector 1
		call	Seek_Track_And_Read_Sector
		ld	hl, Disk_Attributes ; Destination address
		ld	de, Read_Buffer	; Source address
		ld	bc, 10h		; 16 bytes to copy
		jp	SYS_MEMCOPY
; End of function Read_Disk_Attr


; =============== S U B	R O U T	I N E =======================================


Write_File:				; CODE XREF: ROM:C526p	ROM:C74Fj ...
		call	Read_Disk_Attr	; ⥭ ਡ⮢ ᪠   BED0-BEDF.
					; ।	饭:
					; BED0-BEDA -  ᪠,
					; BEDB - 	᢮ ᥪ  ᪥,
					; BEDC - ࢠ	᢮ ஦  ᪥,
					; BEDD - unknown
					; BEDE - hidden	directory
					; BEDF - 		SAVE.
		ld	a, (Disk_Write_Protection) ; BEDF
		or	a
		ret	nz
		ld	de, File_Name	; BE1F
		call	Read_File_Attributes
		or	a
		ret	nz
		ld	a, (Disk_First_Free_Sector) ; BEDB
		ld	(File_First_Sector), a ; BE2B
		ld	a, (Disk_First_Free_Track) ; BEDC
		ld	(File_First_Track), a ;	BE2C
		xor	a
		ld	(File_Status), a ; BE2A
		ld	de, File_Name	; BE1F
		ld	bc, 17
		call	SYS_MEMCOPY
		call	Seek_Track_And_Write_Sector
		call	Copy_File_Attr
		call	Write_N_Sectors
		ld	a, (Sector_Number) ; BFB1
		inc	a
		cp	0Ah
		jp	z, loc_C231
		ld	(Disk_First_Free_Sector), a ; BEDB
		ld	a, (Track_Number) ; BFB0

loc_C212:				; CODE XREF: Write_File+6Ej
		ld	(Disk_First_Free_Track), a ; BEDC
		xor	a
		ld	(Track_Number),	a ; BFB0
		inc	a
		ld	(Sector_Number), a ; BFB1
		call	Seek_Track_And_Read_Sector
		ld	hl, Read_Buffer	; BD00
		ld	de, Disk_Attributes ; BED0
		ld	bc, 16
		call	SYS_MEMCOPY
		call	Seek_Track_And_Write_Sector
		xor	a
		ret
; ---------------------------------------------------------------------------

loc_C231:				; CODE XREF: Write_File+38j
		ld	a, 1
		ld	(Disk_First_Free_Sector), a ; BEDB
		ld	a, (Track_Number) ; BFB0
		cp	164		; Maximum Logical track	number 82*2
		call	z, sub_C7FC
		inc	a
		jp	loc_C212
; End of function Write_File


; =============== S U B	R O U T	I N E =======================================


sub_C242:				; CODE XREF: sub_C242+7j Print_DIR+13p ...
		ld	c, (hl)
		call	SYS_PUTCH
		inc	hl
		dec	b
		ret	z
		jp	sub_C242
; End of function sub_C242

; ---------------------------------------------------------------------------
Disk_Name_String: DB	'imq diska:  ',0 ; DATA XREF: Print_DIR+8o

; =============== S U B	R O U T	I N E =======================================


Print_DIR:				; CODE XREF: ROM:C448p	ROM:C7B5j
		call	Read_Disk_Attr	; ⥭ ਡ⮢ ᪠   BED0-BEDF.
					; ।	饭:
					; BED0-BEDA -  ᪠,
					; BEDB - 	᢮ ᥪ  ᪥,
					; BEDC - ࢠ	᢮ ஦  ᪥,
					; BEDD - unknown
					; BEDE - hidden	directory
					; BEDF - 		SAVE.
		ld	a, (Disk_Hidden_DIR_Flag) ; BEDE
		or	a
		ret	nz
		ld	hl, Disk_Name_String ; "imq diska:  "
		call	SYS_PUTS
		ld	hl, Disk_Attributes ; BED0
		ld	b, 10
		call	sub_C242
		call	Print_New_Line
		ld	hl, End_Of_DIR_Work_Area ; BD11

loc_C275:				; CODE XREF: Print_DIR+2Dj
					; Print_DIR+52j
		ld	a, (hl)
		or	a
		ret	z
		call	sub_C2BF
		cp	0FFh
		call	z, sub_C2AE
		cp	0Ah
		ret	z
		ld	a, e
		cp	1
		jp	z, loc_C275
		call	Print_Space
		ld	c, ':'          ; Symbol to print
		call	SYS_PUTCH
		call	Print_Space

loc_C294:				; CODE XREF: Print_DIR+4Cj
		ld	a, (hl)
		or	a
		ret	z
		call	sub_C2BF
		cp	0FFh
		call	z, sub_C2AE
		cp	0Ah
		ret	z
		ld	a, e
		cp	1
		jp	z, loc_C294
		call	Print_New_Line
		jp	loc_C275
; End of function Print_DIR


; =============== S U B	R O U T	I N E =======================================


sub_C2AE:				; CODE XREF: Print_DIR+24p
					; Print_DIR+43p
		ld	a, (Sector_Number) ; BFB1
		inc	a
		ld	(Sector_Number), a ; BFB1
		cp	0Ah
		ret	z
		call	loc_C111
		ld	hl, Read_Buffer	; BD00
		ret
; End of function sub_C2AE


; =============== S U B	R O U T	I N E =======================================


sub_C2BF:				; CODE XREF: Print_DIR+1Fp
					; Print_DIR+3Ep
		ld	a, (hl)
		cp	1
		jp	z, loc_C2EA
		push	hl
		ld	bc, 0Bh
		add	hl, bc
		ld	a, (hl)
		pop	hl
		cp	2
		jp	nc, loc_C2EA
		push	hl
		ld	b, 8
		call	sub_C242
		ld	c, '.'
		call	SYS_PUTCH
		ld	b, 3
		call	sub_C242
		pop	hl
		ld	e, 0

loc_C2E4:				; CODE XREF: sub_C2BF+2Dj
		ld	bc, 11h
		add	hl, bc
		ld	a, l
		ret
; ---------------------------------------------------------------------------

loc_C2EA:				; CODE XREF: sub_C2BF+3j sub_C2BF+Fj
		ld	e, 1
		jp	loc_C2E4
; End of function sub_C2BF


; =============== S U B	R O U T	I N E =======================================


Select_Drive_0:				; CODE XREF: ROM:C371p
		xor	a
		ld	(Drive_Number),	a ; BFB4
		ld	(Current_Drive_Number),	a ; Save Drive Number
; End of function Select_Drive_0


; =============== S U B	R O U T	I N E =======================================


Select_Drive:				; CODE XREF: Seek_Track:Select_Drive_Retryp
		xor	a
		out	(0E4h),	a	; Bad practice!
					; It make sense	to interupt any	VG93 command first
					; (i.e.	write command) and then	change drive.
		ld	a, (Current_Drive_Number) ; Restore Drive Number
		ld	b, 1Ch
		or	b
		out	(0E4h),	a
		ld	a, 0D8h	; ''   ; Forced Interupt, Immidiate Interupt
		call	VG93_Command_and_Delay

Wait_for_VG93_Reset:			; CODE XREF: Select_Drive+13j
		in	a, (0E0h)
		rra			; Bit 0	- Busy
		jp	c, Wait_for_VG93_Reset
		ld	a, 8		; Restore, Load	Head
		call	VG93_Command_and_Delay
		call	Wait_VG93_Ready_Status
		call	SYS_LONG_DELAY
		jp	SYS_LONG_DELAY
; End of function Select_Drive


; =============== S U B	R O U T	I N E =======================================


Wait_VG93_Ready_Status:			; CODE XREF: Select_Side_And_Track-559p
					; Select_Drive+1Bp ...
		in	a, (0E0h)
		rla			; Bit7 - Not Ready
		jp	c, Wait_VG93_Ready_Status

Wait_VG93_Busy_Status:			; CODE XREF: Wait_VG93_Ready_Status+9j
		in	a, (0E0h)
		rra			; Bit 0	- Busy
		jp	c, Wait_VG93_Busy_Status
		ret
; End of function Wait_VG93_Ready_Status


; =============== S U B	R O U T	I N E =======================================


RUN_COMMAND_COM:			; CODE XREF: ROM:C37Ap
		ld	de, COMMAND_COM_String ; "COMMAND COM"
		ld	a, d
		ld	(File_RUN_Flag), a ; BFB5
		jp	_Read_File
; End of function RUN_COMMAND_COM

; ---------------------------------------------------------------------------
COMMAND_COM_String: DB 'COMMAND COM' ; DATA XREF: RUN_COMMAND_COMo
CHAMELEON_DOS_String: DB 'CHAMELEON-DOS 7.7', 0Dh, '(C)MASKSOFT&144Kb', 0Dh, 0
					; DATA XREF: ROM:C36Bo
; ---------------------------------------------------------------------------

Hot_Start_Cont:				; CODE XREF: ROM:C6E5j	ROM:C7DBj
		xor	a
		ld	(BORDER), a	; BE38   ࠬ
		call	SYS_CLS

Hot_Start_Vector:			; DATA XREF: Init_Hot_Start_Vectors+14o
		ld	sp, Stack_TOP_2	; BE80
		ld	hl, CHAMELEON_DOS_String ; "CHAMELEON-DOS 7.7", 0Dh, "(C)MASKSOFT&144Kb", 0Dh, ""
		call	SYS_PUTS
		call	Select_Drive_0
		call	Init_Hot_Start_Vectors
		call	Read_Disk_Attr	; ⥭ ਡ⮢ ᪠   BED0-BEDF.
					; ।	饭:
					; BED0-BEDA -  ᪠,
					; BEDB - 	᢮ ᥪ  ᪥,
					; BEDC - ࢠ	᢮ ஦  ᪥,
					; BEDD - unknown
					; BEDE - hidden	directory
					; BEDF - 		SAVE.
		call	RUN_COMMAND_COM

Command_Line_Prompt:			; CODE XREF: ROM:C417j	ROM:C41Dj
					; DATA XREF: ...
		ld	sp, Stack_TOP_2	; BE80
		call	Init_Hot_Start_Vectors
		call	Read_Disk_Attr	; ⥭ ਡ⮢ ᪠   BED0-BEDF.
					; ।	饭:
					; BED0-BEDA -  ᪠,
					; BEDB - 	᢮ ᥪ  ᪥,
					; BEDC - ࢠ	᢮ ஦  ᪥,
					; BEDD - unknown
					; BEDE - hidden	directory
					; BEDF - 		SAVE.
		call	Print_New_Line
		ld	a, (Drive_Number) ; Physical Drive number to Logical letter conversion
		add	a, 'A'
		ld	c, a
		call	SYS_PUTCH
		ld	c, ':'
		call	SYS_PUTCH
		ld	c, '>'
		call	SYS_PUTCH
		ld	hl, File_Name_Buffer ; BE00
		push	hl
		ld	bc, 0Fh
		ld	e, 20h ; ' '
		call	SYS_RAM_FILL
		pop	hl
		call	SYS_GETCH2 ; Wait for key pressed
		cp	7		; F0
		jp	z, DIR
		cp	12h		; F2
		jp	z, SAVE
		cp	15h		; F1
		jp	z, LOAD
		cp	16h		; F3
		jp	z, REN
		cp	14h		; F4
		jp	z, ERA
		cp	13h		; F5
		jp	z, TYPE
		cp	6		;  P/D
		jp	z, BOOT_CPM36	; ⥭  ᪠ CP/M36	 ᫥騬 ᪮.
		cp	0Bh		; SU+K
		jp	z, SYS_PRINT_ROM_CHKSUM	; Print	System ROM checksum's
		cp	0Ch		; SU+L
		jp	z, Seek_Track_Test ; Move Head From track 0 to 83 and back continiously
		ld	(hl), a
		call	Print_CHR_Reg_A
		inc	hl

Wait_For_Next_Key_Pressed:		; CODE XREF: ROM:C3F2j	ROM:C3F6j ...
		call	SYS_GETCH
		cp	7Fh ; ''       ; ZB - Backspace key pressed
		jp	z, Backspace
		cp	0Dh		; BK - Enter key pressed
		jp	z, Drive_Change_OR_RUN_File
		ld	(hl), a
		call	Print_CHR_Reg_A
		ld	a, l
		cp	0Fh
		jp	nc, Wait_For_Next_Key_Pressed
		inc	hl
		jp	Wait_For_Next_Key_Pressed
; ---------------------------------------------------------------------------

Backspace:				; CODE XREF: ROM:C3E3j
		ld	a, l
		or	a
		jp	z, Wait_For_Next_Key_Pressed
		dec	hl
		ld	c, 7Fh ; ''    ; "Zaboj"
		call	SYS_PUTCH
		ld	a, ' '
		ld	(hl), a
		jp	Wait_For_Next_Key_Pressed
; ---------------------------------------------------------------------------

Drive_Change_OR_RUN_File:		; CODE XREF: ROM:C3E8j
		dec	hl
		ld	a, (hl)
		cp	':'
		jp	nz, RUN_File_Name ; add	COM to filename	and try	to run
		dec	hl		; Drive	Change
		ld	a, (hl)
		sub	'A'             ; Drive letter to Drive Number conversion
		cp	4
		jp	nc, Command_Line_Prompt
		ld	(Drive_Number),	a ; BFB4
		jp	Command_Line_Prompt
; ---------------------------------------------------------------------------

RUN_File_Name:				; CODE XREF: ROM:C40Ej
		ld	hl, 0BE1Fh	; add COM to filename and try to run
		ld	de, 0BE00h
		ld	bc, 8
		call	SYS_MEMCOPY
		ld	(hl), 43h ; 'C'
		inc	hl
		ld	(hl), 4Fh ; 'O'
		inc	hl
		ld	(hl), 4Dh ; 'M'
		ld	a, 1
		ld	(File_RUN_Flag), a ; BFB5
		call	Read_File
		jp	Print_NO_FILE_Message
; ---------------------------------------------------------------------------

DIR:					; CODE XREF: ROM:C3AEj
		ld	hl, DIR_String	; "DIR"
		call	SYS_PUTS
		call	Keyboard_Wait_For_BK_Key
		call	Print_DIR
		jp	JMP_Command_Line_Prompt

; =============== S U B	R O U T	I N E =======================================


Keyboard_Wait_For_BK_Key:		; CODE XREF: ROM:C445p
					; Keyboard_Wait_For_BK_Key+8j ...
		call	SYS_GETCH
		cp	0Dh		; BK - Enter Key
		jp	z, Print_New_Line
		jp	Keyboard_Wait_For_BK_Key
; End of function Keyboard_Wait_For_BK_Key

; ---------------------------------------------------------------------------

LOAD:					; CODE XREF: ROM:C3B8j
		ld	hl, LOAD_String	; "LOAD "
		call	SYS_PUTS
		call	Keyboard_Wait_For_BK_Key
		ld	hl, 0BE8Ch
		ld	bc, 6
		ld	e, 20h ; ' '
		call	SYS_RAM_FILL
		call	0DD94h
		ld	hl, (CODFL_RUN)	; BEA9 Word  CODE-䠩
		jp	(hl)

; =============== S U B	R O U T	I N E =======================================


sub_C474:				; CODE XREF: HEX_To_BIN_8_Bit+1Cp
					; HEX_To_BIN_8_Bit+21p
		sub	30h ; '0'
		cp	10h
		ret	c
		sub	7
		ret
; End of function sub_C474


; =============== S U B	R O U T	I N E =======================================


sub_C47C:				; CODE XREF: HEX_To_BIN_8_Bit+4p
					; HEX_To_BIN_8_Bit+11p
		cp	30h ; '0'
		jp	c, loc_C492
		cp	3Ah ; ':'
		jp	c, loc_C490
		cp	41h ; 'A'
		jp	c, loc_C492
		cp	47h ; 'G'
		jp	nc, loc_C492

loc_C490:				; CODE XREF: sub_C47C+7j
		or	a
		ret
; ---------------------------------------------------------------------------

loc_C492:				; CODE XREF: sub_C47C+2j sub_C47C+Cj ...
		scf
		ret
; End of function sub_C47C


; =============== S U B	R O U T	I N E =======================================


HEX_To_BIN_8_Bit:			; CODE XREF: HEX_To_BIN_16_Bitp
					; HEX_To_BIN_16_Bit+4p	...
		push	hl
		call	SYS_GETCH2
		call	sub_C47C
		jp	c, loc_C548
		ld	h, a
		call	Print_CHR_Reg_A
		call	SYS_GETCH2
		call	sub_C47C
		jp	c, loc_C548
		ld	l, a
		call	Print_CHR_Reg_A
		ld	a, l
		call	sub_C474
		ld	b, a
		ld	a, h
		call	sub_C474
		rlca
		rlca
		rlca
		rlca
		or	b
		pop	hl
		ret
; End of function HEX_To_BIN_8_Bit


; =============== S U B	R O U T	I N E =======================================


HEX_To_BIN_16_Bit:			; CODE XREF: ROM:C511p	ROM:C51Bp ...
		call	HEX_To_BIN_8_Bit
		ld	h, a
		call	HEX_To_BIN_8_Bit
		ld	l, a
		ret
; End of function HEX_To_BIN_16_Bit


; =============== S U B	R O U T	I N E =======================================


Print_CHR_Reg_A:			; CODE XREF: ROM:C3DAp	ROM:C3ECp ...
		ld	c, a
		jp	SYS_PUTCH
; End of function Print_CHR_Reg_A


; =============== S U B	R O U T	I N E =======================================


sub_C4CC:				; CODE XREF: ROM:C50Bp	ROM:C5A4p ...

; FUNCTION CHUNK AT C53C SIZE 00000006 BYTES
; FUNCTION CHUNK AT C548 SIZE 00000006 BYTES

		ld	hl, 0BE1Fh

loc_C4CF:				; CODE XREF: sub_C4CC+13j
		call	SYS_GETCH2
		cp	13h		;  F5
		jp	z, loc_C548
		ld	(hl), a
		call	Print_CHR_Reg_A
		ld	a, l
		cp	26h ; '&'
		inc	hl
		jp	c, loc_C4CF
		ld	c, '.'
		call	SYS_PUTCH

loc_C4E7:				; CODE XREF: sub_C4CC+2Cj
		call	SYS_GETCH2
		cp	13h		; F5
		jp	z, loc_C548
		ld	(hl), a
		call	Print_CHR_Reg_A
		inc	hl
		ld	a, l
		cp	2Ah ; '*'
		ret	nc
		jp	loc_C4E7
; End of function sub_C4CC


; =============== S U B	R O U T	I N E =======================================


Print_Space:				; CODE XREF: Print_DIR+30p
					; Print_DIR+38p ...
		ld	c, ' '
		jp	SYS_PUTCH
; End of function Print_Space


; =============== S U B	R O U T	I N E =======================================


Print_New_Line:				; CODE XREF: Print_DIR+16p
					; Print_DIR+4Fp ...
		ld	c, 0Dh
		jp	SYS_PUTCH
; End of function Print_New_Line

; ---------------------------------------------------------------------------

SAVE:					; CODE XREF: ROM:C3B3j	ROM:C7C1j
		ld	hl, SAVE_String	; "SAVE "
		call	SYS_PUTS
		call	sub_C4CC
		call	Print_Space
		call	HEX_To_BIN_16_Bit
		push	hl
		ld	(File_Start_RAM), hl ; BE2D
		call	Print_Space
		call	HEX_To_BIN_16_Bit
		ex	de, hl
		pop	hl
		call	Calc_File_Sector_Length	; ᫥  ணࠬ  ᥪ.
					; ।	饭:
					; HL - .,
					; DE - ..
					; 室 :
					; BE2F -   ᥪ.
		call	Keyboard_Wait_For_BK_Key
		call	Write_File
		or	a
		jp	nz, Print_NO_SAVE_Message
		jp	JMP_Command_Line_Prompt
; ---------------------------------------------------------------------------
; START	OF FUNCTION CHUNK FOR Read_Sector

Print_IO_ERROR_Message:			; CODE XREF: Read_Sector+12j
					; Calc_Next_Sec_And_Tr_Numbers:IO_ERROR?j ...
		ld	hl, ERROR_IO_String ; "\r*ERORR I/O*\r"
		call	SYS_PUTS
		jp	unk_BEF0
; END OF FUNCTION CHUNK	FOR Read_Sector
; ---------------------------------------------------------------------------

Print_NO_FILE_Message:			; CODE XREF: ROM:C43Cj	ROM:C5B2j ...
		ld	hl, NO_FILE_String ; "\r*NO FILE*"
; START	OF FUNCTION CHUNK FOR sub_C4CC

_SYS_PUTS:				; CODE XREF: ROM:C545j	sub_C4CC+7Fj ...
		call	SYS_PUTS
		jp	JMP_Command_Line_Prompt
; END OF FUNCTION CHUNK	FOR sub_C4CC
; ---------------------------------------------------------------------------

Print_NO_SAVE_Message:			; CODE XREF: ROM:C52Aj
		ld	hl, NO_SAVE_String ; "\r*NO SAVE*"
		jp	_SYS_PUTS
; ---------------------------------------------------------------------------
; START	OF FUNCTION CHUNK FOR sub_C4CC

loc_C548:				; CODE XREF: HEX_To_BIN_8_Bit+7j
					; HEX_To_BIN_8_Bit+14j	...
		ld	hl, SN_ERROR_String ; "\r*SN.ERROR*"
		jp	_SYS_PUTS
; END OF FUNCTION CHUNK	FOR sub_C4CC
; ---------------------------------------------------------------------------
ERROR_IO_String: DB 0Dh, '*ERORR I/O*', 0Dh, 0 ; DATA XREF: Read_Sector:Print_IO_ERROR_Messageo
DIR_String:	 DB 'DIR',0          ; DATA XREF: ROM:DIRo
LOAD_String:	 DB 'LOAD ',0        ; DATA XREF: ROM:LOADo
SAVE_String:	 DB 'SAVE ',0        ; DATA XREF: ROM:SAVEo
ERA_String:	 DB 'ERA ',0         ; DATA XREF: ROM:ERAo
REN_String:	 DB 'REN ',0         ; DATA XREF: ROM:RENo
NO_FILE_String:	 DB 0Dh, '*NO FILE*',0  ; DATA XREF: ROM:Print_NO_FILE_Messageo
NO_SAVE_String:	 DB 0Dh, '*NO SAVE*',0  ; DATA XREF: ROM:Print_NO_SAVE_Messageo
TYPE_String:	 DB 'TYPE ',0        ; DATA XREF: ROM:TYPEo
SN_ERROR_String: DB 0Dh, '*SN.ERROR*',0 ; DATA XREF: sub_C4CC:loc_C548o
; ---------------------------------------------------------------------------

ERA:					; CODE XREF: ROM:C3C2j	ROM:C7B8j
		ld	hl, ERA_String	; "ERA "
		call	SYS_PUTS
		call	sub_C4CC
		call	Keyboard_Wait_For_BK_Key
		ld	de, 0BE1Fh
		call	Read_File_Attributes
		cp	1
		jp	nz, Print_NO_FILE_Message
		ex	de, hl
		ld	bc, 17
		call	SUB_HL_BC	; HL=HL-BC (⠭).
		push	hl
		ld	bc, 11
		add	hl, bc
		ld	a, (hl)
		pop	hl
		cp	1
		jp	nc, Print_NO_FILE_Message
		ld	a, 1
		ld	(hl), a
		call	Seek_Track_And_Write_Sector
		jp	JMP_Command_Line_Prompt
; ---------------------------------------------------------------------------

REN:					; CODE XREF: ROM:C3BDj	ROM:C7BBj
		ld	hl, REN_String	; "REN "
		call	SYS_PUTS
		call	sub_C4CC
		ld	hl, File_Name_Buffer ; BE00
		ld	de, 0BE1Fh
		ld	bc, 11
		call	SYS_MEMCOPY
		ld	c, '='
		call	SYS_PUTCH
		call	sub_C4CC
		ld	de, 0BE1Fh
		call	Read_File_Attributes
		cp	1
		jp	nz, Print_NO_FILE_Message
		ex	de, hl
		ld	bc, 17
		call	SUB_HL_BC	; HL=HL-BC (⠭).
		ld	de, File_Name_Buffer ; BE00
		ld	bc, 11
		call	SYS_MEMCOPY
		call	Seek_Track_And_Write_Sector
		jp	JMP_Command_Line_Prompt

; =============== S U B	R O U T	I N E =======================================

; HL=HL-BC (⠭).

SUB_HL_BC:				; CODE XREF: ROM:C5B9p	ROM:C5FDp
		ld	a, l
		sub	c
		ld	l, a
		ld	a, h
		sbc	a, b
		ld	h, a
		ret
; End of function SUB_HL_BC

; ---------------------------------------------------------------------------

TYPE:					; CODE XREF: ROM:C3C7j	ROM:C7BEj
		ld	hl, TYPE_String	; "TYPE "
		call	SYS_PUTS
		ld	(File_RUN_Flag), a ; BFB5
		call	sub_C4CC
		call	Keyboard_Wait_For_BK_Key
		call	Read_File
		dec	a
		jp	nz, Print_NO_FILE_Message
		ld	hl, (File_Start_RAM) ; BE2D
		jp	_SYS_PUTS
; ---------------------------------------------------------------------------
; START	OF FUNCTION CHUNK FOR Seek_Track

Select_FM_Mode:				; CODE XREF: Seek_Track+38j
		ld	(hl), 1
		jp	nz, Seek_Error
		dec	hl
		ld	(hl), 9		; Sectors Per Track
		pop	bc
		pop	hl
		ret
; ---------------------------------------------------------------------------

MFM_Seek:				; CODE XREF: Seek_Track+2Fj
		ld	a, b
		call	Select_Side_And_Track
		jp	nz, MFM_Seek_Failure ; Switch to FM mode
		ld	(hl), 0		; Dencity Bit
		dec	hl
		ld	(hl), 16	; Sectors Per Track
		pop	bc
		pop	hl
		ret
; ---------------------------------------------------------------------------

Seek_Error:				; CODE XREF: Seek_Track+5C6j
		dec	(hl)
		dec	hl
		dec	hl
		dec	c		; Retry	Counter
		jp	nz, Select_Drive_Retry ; Change	drive
		jp	Print_IO_ERROR_Message
; END OF FUNCTION CHUNK	FOR Seek_Track

; =============== S U B	R O U T	I N E =======================================


Select_Side_And_Track:			; CODE XREF: Seek_Track+35p
					; Seek_Track+5D0p

; FUNCTION CHUNK AT C0FA SIZE 0000000B BYTES

		out	(0E4h),	a
		call	Delay
		ld	a, (Physical_Track_Number) ; BFB3
		out	(0E3h),	a	; VG93 Data Register - Desired Track Number
		ld	a, 1Ch		; Seek,	Load Head, Verify on destination track
		jp	VG93_Execute_Command
; End of function Select_Side_And_Track

; ---------------------------------------------------------------------------

Cold_Start:				; CODE XREF: ROM:Hardware_Reset_Vectorj
		out	(0), a
		ld	sp, INIT_STACK_TOP ; OUT - disengage cold start	trigger
		ld	a, 88h ; ''
		out	(0C3h),	a	; System VV55A Mode
		ld	a, 8Ah ; ''
		out	(0D3h),	a	; Keyboard VV55	Mode
		ld	a, 2
		out	(0C2h),	a	; Port C - Memory controll
		ld	a, 8Fh ; ''
		out	(0C1h),	a	; Port B - Color Palette
		ld	a, 10111111b
		out	(0D0h),	a	; Keyboard Port	A6=0
		in	a, (0D1h)
		cp	0FBh ; ''      ; Key "SU" depressed at reset
		jp	nz, Cold_Start_Cont
		ld	hl, 0

Mem_Test_0000_C000:			; CODE XREF: ROM:C693j
		ld	a, (hl)
		cpl
		ld	(hl), a
		cp	(hl)
		jp	nz, SYS_MEM_TEST_Cont
		inc	hl
		ld	a, h
		cp	0C0h ; ''
		jp	nz, Mem_Test_0000_C000

Cold_Start_Cont:			; CODE XREF: ROM:C682j
		call	Print_Screen_If_P_Pressed ; "P" Key pressed during reset ? - Print screen if yes
		ld	a, 11011111b
		out	(0D0h),	a	; Keyboar Port A5=0
		in	a, (0D1h)
		cp	7Fh		; Key "C" pressed during reset
		jp	z, C_Pressed_On_Reset
		ld	hl, Hot_Start	; Destination Address
		ld	(Hot_Start_Vector_Address), hl ; BFEC

C_Pressed_On_Reset:			; CODE XREF: ROM:C6A1j
		ld	a, 0C3h	; ''
		ld	(JMP_Hot_Start_Vector),	a ; BFEB
		ld	hl, 0B000h
		ld	bc, 0EEFh
		ld	e, 0
		call	SYS_RAM_FILL
		ld	hl, 0B880h
		ld	(unk_BE40), hl	; BE40 PRN_SHIFT ᬥ饭 㪢 ਫ.??
		ld	a, 1
		ld	(unk_BE3A), a	; BE3A
		ld	a, 0FFh
		ld	(KYB_BEEP), a	; BE1E ./몫.  .
		jp	SYS_SYS_RESET
; ---------------------------------------------------------------------------

Hot_Start:				; DATA XREF: ROM:C6A4o
		ld	hl, Read_Buffer	; Destination Address
		ld	de, 80C0h	; Source Address
		ld	bc, 256		; # of bytes to	copy 256 bytes = 1 sector
		push	hl
		push	de
		push	bc
		call	SYS_MEMCOPY
		call	Lviv_Splash_Screen ; Copy part of SYS ROM and execute in RAM
		pop	bc		; Restore 256 bytes in 80C0h
		pop	hl
		pop	de
		call	SYS_MEMCOPY
		jp	Hot_Start_Cont
; ---------------------------------------------------------------------------
		db    0

; =============== S U B	R O U T	I N E =======================================

; ᫥  ணࠬ  ᥪ.
; ।	饭:
; HL - .,
; DE - ..
; 室 :
; BE2F -   ᥪ.

Calc_File_Sector_Length:		; CODE XREF: ROM:C520p	ROM:C74Cp
		push	hl
		push	de
		ld	a, 1
		ld	(File_Sector_Length), a	; BE2F
		call	_Calc_File_Sector_Length
		pop	de
		pop	hl
		ret
; End of function Calc_File_Sector_Length


; =============== S U B	R O U T	I N E =======================================


_Calc_File_Sector_Length:		; CODE XREF: Calc_File_Sector_Length+7p
					; _Calc_File_Sector_Length+Fj
		ld	bc, 256
		add	hl, bc
		call	SYS_CMP_DE_HL
		ret	nc
		ld	a, (File_Sector_Length)	; BE2F
		inc	a
		ld	(File_Sector_Length), a	; BE2F
		jp	_Calc_File_Sector_Length
; End of function _Calc_File_Sector_Length

; ---------------------------------------------------------------------------

BOOT_CPM36:				; CODE XREF: ROM:C3CCj
		xor	a		; ⥭  ᪠ CP/M36	 ᫥騬 ᪮.
		ld	(Track_Number),	a ; BFB0
		inc	a
		ld	(Sector_Number), a ; BFB1
		ld	a, 31
		ld	(Sector_Length), a ; BFB6
		ld	hl, 9000h
		call	Read_N_Sectors
		jp	0A600h

; =============== S U B	R O U T	I N E =======================================

; Add <space><space>"COM" to the file name

Add_File_Ext_COM:			; CODE XREF: ROM:Tape_Write_Substp
					; ROM:Tape_Read_Substp
		ld	de, 0BE8Ch
		jp	_Add_File_Ext_COM
; ---------------------------------------------------------------------------
		db  11h
		db  92h	; 
		db 0BEh	; 
; ---------------------------------------------------------------------------

_Add_File_Ext_COM:			; CODE XREF: Add_File_Ext_COM+3j
		ld	hl, 0BE1Fh
		ld	bc, 6
		call	SYS_MEMCOPY
		ld	(hl), 20h ; ' '
		inc	hl
		ld	(hl), 20h ; ' '
		inc	hl
		ld	(hl), 43h ; 'C'
		inc	hl
		ld	(hl), 4Fh ; 'O'
		inc	hl
		ld	(hl), 4Dh ; 'M'
		ret
; End of function Add_File_Ext_COM

; ---------------------------------------------------------------------------

Tape_Write_Subst:			; CODE XREF: ROM:C7D0j
		call	Add_File_Ext_COM ; Add <space><space>"COM" to the file name
		ld	hl, (RAM_End_Address) ;	BEA6
		ex	de, hl
		ld	hl, (RAM_Start_Address)	; BEA4
		ld	(File_Start_RAM), hl ; BE2D
		call	Calc_File_Sector_Length	; ᫥  ணࠬ  ᥪ.
					; ।	饭:
					; HL - .,
					; DE - ..
					; 室 :
					; BE2F -   ᥪ.
		jp	Write_File
; ---------------------------------------------------------------------------

Tape_Read_Subst:			; CODE XREF: ROM:C7CDj
		call	Add_File_Ext_COM ; Add <space><space>"COM" to the file name
		xor	a
		ld	(File_RUN_Flag), a ; BFB5
		jp	Read_File

; =============== S U B	R O U T	I N E =======================================


Init_Hot_Start_Vectors:			; CODE XREF: ROM:C374p	ROM:C380p
		ld	a, 0C3h	; ''
		ld	(JMP_Command_Line_Prompt), a ; BFE8
		ld	(unk_BEF0), a	; BEF0
		ld	(JMP_Hot_Start_Vector),	a ; BASIC Hot Start
		ld	hl, Command_Line_Prompt
		ld	(LOAD_ERR), hl	; BEF1 word ..  ./
		ld	(Command_Line_Prompt_Vector), hl ; BFE9
		ld	hl, Hot_Start_Vector
		ld	(Hot_Start_Vector_Address), hl ; BFEC
		ret
; End of function Init_Hot_Start_Vectors


; =============== S U B	R O U T	I N E =======================================


Lviv_Splash_Screen:			; CODE XREF: ROM:C6DCp
		ld	hl, 80C0h
		ld	de, 0FCA6h	; Source address
		ld	bc, 234		; # of bytes to	copy
		call	SYS_MEMCOPY
		jp	80D4h		; System Lviv Splash Screen Routine Executed in	RAM
; End of function Lviv_Splash_Screen


; =============== S U B	R O U T	I N E =======================================

; "P" Key pressed during reset ? - Print screen if yes

Print_Screen_If_P_Pressed:		; CODE XREF: ROM:Cold_Start_Contp
		cp	0F7h ; ''
		ret	nz
		ld	hl, 0B880h
		ld	(unk_BE40), hl	; BE40 PRN_SHIFT ᬥ饭 㪢 ਫ.??
		ld	c, '3'
		call	SYS_ESC_CRH_To_PRN
		ld	c, 17h
		call	SYS_CRH_To_PRN
		jp	SYS_COPY_SCR_To_PRN
; End of function Print_Screen_If_P_Pressed

; ---------------------------------------------------------------------------
		db  80h	; 
; ---------------------------------------------------------------------------
		jp	Seek_Track	; ⠭  ᪮  ॡ ஦.
					; ।	饭 ᨬ  祩 :
					; BFB0 -  ஦ (0-165),
					; BFB4 -  ᪮ (0-, 1-, 2-, 3-D).
; ---------------------------------------------------------------------------
		jp	Read_Sector	; ⥭ ᥪ  ᪠.
					; ।	饭 ᭠砫   믮 / C79D,  ⠪ ᨬ  祩:
					; BFB1 -  ᥪ (1-9).
					; HL - Data buffer address
; ---------------------------------------------------------------------------
		jp	Write_Sector	;  ᥪ. ।	饭 ᭠砫   믮 / C79D,  ⠪ ᨬ  祩:
					; BFB1 -  ᥪ (1-9).
					; HL - Data buffer address
; ---------------------------------------------------------------------------
		jp	Read_N_Sectors	; ⥭ ।񭭮 ⢠ ᥪ஢  .
					; ।	饭:
					; BFB0 -  ஦,
					; FB1 -  ᥪ,
					; BFB4*	- 	᪮,
					; BFB6 - ᫮ ⠥	ᥪ஢ (1-255),
					; HL - 砫  㤠 .
; ---------------------------------------------------------------------------
		jp	Write_N_Sectors	;  । ⢠ ᥪ஢    .
					;  ࠬ ⠪ 	  / C7A6,	⮫쪮  HL ᨬ . 
					;     .
; ---------------------------------------------------------------------------
		jp	Read_File_Attributes ;  ਡ 䠩  ᪠.
					; ।	饭:
					; DE - ,  室 	䠩 	७ (11	ᨬ),
					; BFB4*	- ..
					; 室 :
					;  = 00 -  ⠫,
					;  = 02 -  ⠫  ,
					;  = 01 - 䠩	,	  BE1F-BE2F ᯮ	ਡ 䠩.
; ---------------------------------------------------------------------------
		jp	Read_File	; ⥭ 䠩  ᪠.
					; ।	饭:
					; BE1F-BE29 -  䠩	 ७,
					; BFB4*	- c.,
					; BFB5 - , ᫨ 祭 ⮩ 祩  .
					; 室 :
					;  = 01 - 䠩	⠭,	 䠩  .
; ---------------------------------------------------------------------------
		jp	Write_File	;  䠩  .
					; ।	饭:
					; BE1F-BE29 - . ணࠬ C7AF,
					; BE2D - 砫  䠩,
					; BE2F -  䠩  ᥪ.
					; 室 :
					; A = 00 -  ந ଠ쭮,
					; A = 01 -  ᪥ 㦥	 䠩  ⠪ ,
					; A = 02 -  ⠫  .
; ---------------------------------------------------------------------------
		jp	Print_DIR	; 뢮	⠫ ᪠ (筮  Dir)
; ---------------------------------------------------------------------------
		jp	ERA		; ணࠬ RA.     ०. ᫥ 襭 / 室	  BFE8.
; ---------------------------------------------------------------------------
		jp	REN		; ணࠬ REN.     ०. 室    RA.
; ---------------------------------------------------------------------------
		jp	TYPE		; ணࠬ TYPE.   	 ०. 室	  	ERA.
; ---------------------------------------------------------------------------
		jp	SAVE		; ணࠬ SAVE. o    ०. 室    RA.
; ---------------------------------------------------------------------------
		jp	HEX_To_BIN_8_Bit ; 	  16-筮 ᫠.
					; 室 :
					;  = 16-筮	᫮.
					;   訡  㤥 ந 室	  BFE8.
; ---------------------------------------------------------------------------
		jp	sub_C4CC
; ---------------------------------------------------------------------------
		jp	HEX_To_BIN_16_Bit ;   ॣ. HL 16-筮 塠⮢	᫠.
					; 室 :
					; HL = 16-筮 塠⮢ ᫮.
					;  訡 室    / C7C4.
; ---------------------------------------------------------------------------
		jp	Tape_Read_Subst	; ⮩ ணࠬ  / DD94	(⥭	 ).
					; 室 ࠬ:
					; BE8C - ..
; ---------------------------------------------------------------------------
		jp	Tape_Write_Subst ; ⮩	ணࠬ 	/ DD31 (뢮  ), ।⢮	 ணࠬ  뭮 	 ,   .
					; 室 ࠬ:
					; BEA4 - .,
					; BEA6 - .,
					; BE8C -  䠩(6 ᨬ).
					;  , ࠬ	⠪ ,  	 DD31. 뭮ᨬ 䠩  ७ .
; ---------------------------------------------------------------------------

Seek_Track_Test:			; CODE XREF: ROM:C3D6j
		ld	a, 165		; Move Head From track 0 to 83 and back	continiously
		ld	(Track_Number),	a ; BFB0
		call	Seek_Track	; ⠭  ᪮  ॡ ஦.
					; ।	饭 ᨬ  祩 :
					; BFB0 -  ஦ (0-165),
					; BFB4 -  ᪮ (0-, 1-, 2-, 3-D).
		jp	Hot_Start_Cont

; =============== S U B	R O U T	I N E =======================================


Test_RUN_Flag:				; CODE XREF: Read_File+12p
		ld	a, (File_RUN_Flag) ; BFB5
		or	a
		ld	a, 1
		ret	z
		ret
; End of function Test_RUN_Flag

; ---------------------------------------------------------------------------
; START	OF FUNCTION CHUNK FOR sub_C018

VG93_Read_Data_Feed:			; CODE XREF: sub_C018+1Bj
					; sub_C018+7D1j ...
		in	a, (0E4h)
		and	c
		jp	z, VG93_Read_Data_Feed ; Read IRQ/DRQ Status Register, Apply Mask, Repeat
		in	a, (0E3h)	; Read VG93 DR
		ret	m		; Return if IRQ=Bit7=1
		ld	(hl), a		; Store	in Read	Buffer
		inc	hl		; Next address in read buffer
		jp	VG93_Read_Data_Feed
; END OF FUNCTION CHUNK	FOR sub_C018

; =============== S U B	R O U T	I N E =======================================


VG93_Command_and_Delay:			; CODE XREF: sub_C018:loc_C030p
					; sub_C04B:loc_C05Dp ...
		out	(0E0h),	a
; End of function VG93_Command_and_Delay


; =============== S U B	R O U T	I N E =======================================


Delay:					; CODE XREF: Select_Side_And_Track+2p
		ld	a, 0Fh
		jp	SYS_DELAY
; End of function Delay

; ---------------------------------------------------------------------------
		db    0

; =============== S U B	R O U T	I N E =======================================


sub_C7FC:				; CODE XREF: Write_File+6Ap
		ld	(Disk_First_Free_Sector), a ; BEDB
		ret
; End of function sub_C7FC


