
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

/* Spectrum screen compressor
   Based on Burial Laser Compact 1.03
   Nikita Burnashev, 2005 */


   /* Bug Fixed, add header LCMP5...  add optimal LZH: Hrumer, 21.10.2014.
        add depacker Hrumer, 28.10.2014.

        За 2 вечера добавил алгоритм OLZH для проверки.
        http://www.compression.ru/fido/ru.compress.0016.htm
        Я не программирую на си, опыта почти никакого, поэтому не ругайте.
        Компилилось в MinGW на WinXP.
    */

//#define DEBUG
#define DEBUG1

void reorder(unsigned char *pIn, unsigned char *pOut)
{
    int i;
    unsigned char *po = pOut;

    for (i = 0; i < 6144; i++)
    {
        *po++ = pIn[i & 0xf800 | (i & 7) << 8 | (i & 0x38) << 2 | (i & 0x7c0) >> 6];
    }
    
    memcpy(po, pIn + 6144, 768);
}

unsigned char *po, *pb;
int bbuf;

void bit(int value)
{
    if (bbuf == 1) pb = po++;
    bbuf = (bbuf << 1) | value;
    if (bbuf & 0x100)
    {
        *pb = bbuf & 0xff;
        bbuf = 1;
    }
}

void vlc(int num)
{
    if (num == 0) bit(1);
    else if (num <= 2)
    {
        bit(0);
        bit(num & 1);
        bit(1);
    }
    else if (num <= 6)
    {
        num = 6 - num;
        bit(0);
        bit(num >> 1);
        bit(0);
        bit(num & 1);
        bit(1);
    }
    else if (num <= 22)
    {
        num = 22 - num;
        bit(0);
        bit(num >> 3);
        bit(0);
        bit(num >> 2 & 1);
        bit(0);
        bit(num >> 1 & 1);
        bit(num & 1);
    }
}
int vlclen(int num)
{
    if      (num == 0) return 1;
    else if (num <= 2) return 3;
    else if (num <= 6) return 5;
    else if (num <= 22)return 7;
}

int getpricei(int len, int mofs)
{
    int pricei = 1; // признак упакованного
    int msizei = len; // временная для длины; 

    if (mofs > 0x300) msizei--; 
    if (msizei >= 23)
    {
        pricei += vlclen(6);
        pricei += 8;
    }
    else
    {
        if (msizei < 7) msizei--;
        pricei += vlclen(msizei);
    }
    pricei += vlclen((mofs - 1) >> 8);
    pricei++; //вверх или вниз
    pricei +=8; //младший байт дистанции            
    // получили цену
    return pricei;
}




int compress(unsigned char *pIn, unsigned char *pInEnd, unsigned char *pOut, int wnd)
{
    unsigned char *pi = pIn; //указатель на вх. увеличивается по мере. pointer input

    unsigned char optimal = 1;

    unsigned int price[6913]; // цена пути.
    int jumpfrom[6912]; // откуда прыгнули
    int jumplen[6912]; // длина (с учетом, минус 1 от реальной)
    int jumpoffset[6912]; //дистанция
    int jumpdirect[6912]; // 2 - обычно, 3 - вверхногами. 0 - непакуемый байт.

    unsigned char offtype[6912];
    int offoffset[6912];
    int offlen[6912];

    for (int i = 0; i <= 6912; price[i++]=0xffff){} // 6912*9 = 62208, хватает 2 байт

    po = pOut; //point output - сюда потихоньку складываем байты, увеличивая по ходу...
    bbuf = 1;
    *po++ = *pi++;

    if (optimal)
    {
        price[1]=8;
        jumpdirect[1]=0; // можно не делать
    }

    do
    {
        unsigned char *ps, *pw;
        int mtype, msize, mofs;//mtype - тип кода. 0-символ, 2-обычно, 3-перевернуто. Сделано так, чтобы далее &1 - и в поток.
                                //msize - макс длина. mofs - дистанция для длины.
        int pricei, ii;
        int len;
        /* find match */
        mtype = msize = 0;

        ps = pi - wnd;
        if (ps < pIn) ps = pIn;// ps - начало файла или окна pointer start

        pw = pi - 1;// ищем с -1 позиции от текущей. pw - ищем первое совпадение символа. pointer in window
        ii = pi - pIn; // этот ii-тый элемент пытаемся сжать.
        if ((price[ii] + 9) < (price[ii+1])) 
        {    
            price[ii+1] = price[ii] + 9;
            jumpfrom[ii+1] = ii;
            jumpdirect[ii+1] = 0;

         //   printf("0x%04x not packed price[0x%04x]:0x%04x\n", ii, ii+1, price[ii+1]);
        }
        while (1)
        {
            unsigned char *pwc, *pic;
            int nsize, minsize;

            while (pw >= ps && *pw != *pi) pw--; // нашли или вышли за предел
            if (pw < ps) break; //вышли за предел окна или за начало файла

            /* forward match */
            pwc = pw + 1;// pointer window char
            pic = pi + 1; // pointer input char
            nsize = 0;
            while (pic < pInEnd && nsize < 255 && *pwc == *pic) // пока не конец файла и длина не более 255(+1) при совпадении, увеличиваем счетчик
            { 
                pwc++;
                pic++;
                nsize++;
            }
            // Тут, кстати, в оригинальном LC5.2 применен быстрый поиск. Странно, что в си версии его нет. Видимо в, burial gfx поставили версию без быстрого поиска.
            // В LC5.2 чтобы не было торможения на файлах где много одинаковых байт, таблица поиска при длине = 256 не заполнялась полностью.
            // В результате си версия пакует так же, но в оригинальной версии можно чаще увидеть смещение 0x100 на длинных повторениях.
            // А здесь могут быть дистанции короче, например 0x40=64 байта. Но, поскольку дистанции от 1 до 256 кодируются равным числом бит, то
            // С вероятностью 99,9% файл будет той же длины. Но все же есть вероятность, что си версия может сделать короче файл.  
            
            minsize = (pi - pw > 0x300) ? 2 : 1;// дистанция более 768? то 2, иначе 1.!!! заменил >= на >, т.к. при длине = 2 макс дистанция 0x300 включительно.
                                                // ранее тут при длине = 2 и дистанции ровно 0x300 отбрасывался этот вариант. 

            if (nsize > msize && nsize >= minsize)// если новая длина больше самой длинной, и при длине=2 дистанция менее 768, то заменяем лучшей парой длина дистаниця
            {
                
                mtype = 2; // обычное повторение
                mofs = pi - pw;
                // тут надо добавить цикл от (msize если не 0, или от minsize) до nsize с заполнением цены для разных длин строк, для Optimal LZH.
                if (optimal)
                {
                    if (!msize) {msize = minsize - 1;}// если ранее никто не встречался, то начнем или с 2(-1) при дистанции <= 0x300 или с 3(-1) при дистанции > 0x300
                
                    for (int i = msize + 1; i <= nsize; i++) // msize = 0 если еще не встретились повторы. поэтому строкой ранее подправляем.
                    {
                        int pricei;
                        pricei = getpricei (i, mofs);
                        if ((price[ii] + pricei) < (price[ii+i+1]))        
                        {
                            int tmpdeb = (price[ii+i+1] != 0xffff) ? 1 : 0;
                            price[ii+i+1] = price[ii] + pricei;
                            jumpfrom[ii+i+1] = ii;
                            jumplen[ii+i+1] = i;
                            jumpoffset[ii+i+1] = mofs;
                            jumpdirect[ii+i+1] = mtype;

//    #ifdef DEBUG1
//            if (tmpdeb) printf("!");                
//            printf("0x%04x dist:0x%04x type:%d len:%d pricei:0x%04x price[0x%04x]:0x%04x\n", ii, mofs, mtype, i+1, pricei, ii+i+1, price[ii+i+1]);
//        
//    #endif
                        }
                    }
                }
                msize = nsize;
            }

            /* backward match */
            pwc = pw - 1;
            pic = pi + 1;
            nsize = 0;
            while (pic < pInEnd && pwc >= pIn && nsize < 255 && *pwc == *pic)
            {
                pwc--;
                pic++;
                nsize++;
            }

            minsize = (pi - pw > 0x300) ? 2 : 1; // дистанция более 768? то 2, иначе 1.!!! заменил >= на >, т.к. при длине = 2 макс дистанция 0x300 включительно.
            if (nsize > msize && nsize >= minsize)
            {
                mtype = 3; //перевернутое повторение
                mofs = pi - pw;
                // тут надо добавить цикл от (msize если не 0, или от minsize) до nsize с заполнением цены для разных длин строк
                if (optimal)
                {
                    if (!msize) {msize = minsize - 1;}// если ранее никто не встречался, то начнем или с 2(-1) при дистанции <= 0x300 или с 3(-1) при дистанции > 0x300
                
                    for (int i = msize + 1; i <= nsize; i++) // msize = 0 если еще не встретились повторы. поэтому строкой ранее подправляем.
                    {
                        int pricei;
                        pricei = getpricei (i, mofs);
                        if ((price[ii] + pricei) < (price[ii+i+1]))        
                        {
                            int tmpdeb = (price[ii+i+1] != 0xffff) ? 1 : 0;
                            price[ii+i+1] = price[ii] + pricei;
                            jumpfrom[ii+i+1] = ii;
                            jumplen[ii+i+1] = i;
                            jumpoffset[ii+i+1] = mofs;
                            jumpdirect[ii+i+1] = mtype;

//    #ifdef DEBUG1
//            if (tmpdeb) printf("!");                
//            printf("0x%04x dist:0x%04x type:%d len:%d pricei:0x%04x price[0x%04x]:0x%04x\n", ii, mofs, mtype, i+1, pricei, ii+i+1, price[ii+i+1]);
//            
//    #endif
                        }
                    }
                }
                msize = nsize;
            }

            pw--;  // продолжим искать в предыдущем байте совпадение.
        } // закончили поиски для i-той позиции.

//#ifdef DEBUG
//        if (mtype == 0) printf("0x%04x 0x%04x 0 0x%02x\n", pi - pIn, po - pOut + 9, *pi);
//        else printf("0x%04x 0x%04x %d %d 0x%04x\n", pi - pIn, po - pOut + 9, mtype, msize, mofs);
//#endif


        if (optimal)
        {
            pi++;
        } else 
        {
            /* store char or match */
            if (mtype == 0)
            {
                bit(1);
                *po++ = *pi++;
            }
            else
            {
                pi += msize + 1;
                bit(0);
                if (mofs > 0x300) msize--; // ранее  было mofs >= 0x300 что приводило к ошибке при дистанции ровно 0x300. !!!!!
                if (msize >= 23)
                {
                    vlc(6);
                    *po++ = (-msize) & 0xff;
                }
                else
                {
                    if (msize < 7) msize--;
                    vlc(msize);
                }
                vlc((mofs - 1) >> 8);
                bit(mtype & 1);
                *po++ = (-mofs) & 0xff;
            }
        }
    }
    while (pi < pInEnd);

    if (optimal)
    {
        //for (int ii = 6912; ii != 1; ii--)
        //    {printf("0x%04x - jumpfrom: 0x%04x\n", ii, jumpfrom[ii]);}



        // с хвоста собрать данные в таблицы off...
        for (int ii = 6912; ii != 1;)
        {
            offtype[jumpfrom[ii]] = jumpdirect[ii];
            offlen[jumpfrom[ii]] = jumplen[ii];
            offoffset[jumpfrom[ii]] = jumpoffset[ii];
            ii = jumpfrom[ii];
            
            //printf("0x%04x\n", ii);
        }


        for (int ii = 1; ii != 6912;)
        {


            /* store char or match */
            if (offtype[ii] == 0)
            {
                //printf("notpack0x%04x\n", ii);
                bit(1);
                *po++ = pIn[ii++];
            }
            else
            {

                //printf("0x%04x\n", ii);
                bit(0);
                unsigned char mtype, msize; 
                int mofs;
                mofs = offoffset[ii];
                msize = offlen[ii];
                mtype = offtype[ii];

                //printf("0x%04x 0x%04x %d %d 0x%04x\n", ii, po - pOut + 9, mtype, msize, mofs);

                if (mofs > 0x300) msize--; // ранее  было mofs >= 0x300 что приводило к ошибке при дистанции ровно 0x300. !!!!!
                if (msize >= 23)
                {
                    vlc(6);
                    *po++ = (-msize) & 0xff;
                }
                else
                {
                    if (msize < 7) msize--;
                    vlc(msize);
                }
                vlc((mofs - 1) >> 8);
                bit(mtype & 1);
                *po++ = (-mofs) & 0xff;

                ii = ii + offlen[ii] + 1;
            }
        }
    }   

    bit(0);
    vlc(6);
    *po++ = 0;

    if (bbuf != 1)
    {
        while (!(bbuf & 0x100)) bbuf <<= 1;
        *pb = bbuf & 0xff;
    }

    return (po - pOut);
}

unsigned char bufScr[6912];
unsigned char bufIn[6912];
unsigned char bufOut[7000];

// а. надо по english!
//depacker lasercompact. no optmal for full screen. depack 1/3, 2/3 (change a few bytes :). I can do even shorter. but it will be slower. 
unsigned char    delasercompact[154] = {
    0x11, 0x00, 0x40, 0xd9, 0x11, 0x8e, 0x00, 0x1c, 0xcd, 0xc6, 0x1f, 0x19, 0x7e, 0x23, 0xdd, 0x2e, 
    0xff, 0xd9, 0x20, 0x5b, 0x06, 0x01, 0x08, 0xcb, 0x22, 0x20, 0x04, 0x56, 0x23, 0xcb, 0x32, 0x10, 
    0x30, 0x38, 0xe9, 0x04, 0x0e, 0x56, 0x3e, 0xfe, 0xcb, 0x22, 0x20, 0x04, 0x56, 0x23, 0xcb, 0x12, 
    0x17, 0xcb, 0x21, 0x28, 0x07, 0x38, 0xf1, 0x0f, 0x30, 0xee, 0xd6, 0x08, 0xc6, 0x09, 0x10, 0xd6, 
    0xfe, 0xf9, 0x20, 0x02, 0x7e, 0x23, 0xce, 0xff, 0xdd, 0x6f, 0x38, 0xd8, 0x21, 0x58, 0x27, 0xd9, 
    0xc9, 0x7e, 0x23, 0xd9, 0x6f, 0x08, 0x67, 0x19, 0xfe, 0xfd, 0x30, 0x02, 0xdd, 0x2d, 0x7c, 0xfe, 
    0x58, 0x30, 0x2b, 0xad, 0xe6, 0xf8, 0xad, 0x47, 0xad, 0xac, 0x07, 0x07, 0x4f, 0x08, 0x0a, 0x08, 
    0x7a, 0xfe, 0x58, 0x30, 0x1a, 0xab, 0xe6, 0xf8, 0xab, 0x47, 0xab, 0xaa, 0x07, 0x07, 0x4f, 0x08, 
    0x02, 0x13, 0x30, 0x02, 0x2b, 0x2b, 0x23, 0x08, 0xdd, 0x2c, 0x20, 0xd2, 0x18, 0x83, 0x37, 0xf5, 
    0xc6, 0x00, 0x47, 0xf1, 0x4b, 0x30, 0xe8, 0x4d, 0x18, 0xd3};

int main(int argc, char *argv[])
{
    int i, wnd;
    char *nameIn, *nameOut, *p;
    FILE *pfi, *pfo;
    int size;
    char zero = 0x00;
    char depacker = 0;
    nameIn = NULL;
    nameOut = NULL;
    wnd = 0x1700;
    for (i = 1; i < argc; i++)
    {
        p = argv[i];
        if (*p == '-')
        {
            if (strcmp(p, "-wnd") == 0) wnd = strtol(argv[++i], &p, 0);
            if (strcmp(p, "-d") == 0) depacker = 1;
        }
        else if (!nameIn) nameIn = p;
        else if (!nameOut) nameOut = p;
    }
    if (!nameIn || !nameOut || wnd < 1 || wnd > 0x1700)
    {
        printf( "---------------------------------------------------\n"
            "Usage: laser [-wnd <[0x]num>] [-d] <input.scr> <output.bin>\n"
            "Default window is 0x1700\n"
            "-d : save with depacker\n"
            "---------------------------------------------------\n"
            "Laser Compact 5.2.1, 28.10.2014.\n"
            "ZX Spectrum version: packer, depacker by Hrumer, 1994-1999\n"
            "PC version: Nikita Burnashev, 2005\n"
            "Bug fixed, improved compression ratio, add depacker: Hrumer, 2014\n");
        return 1;
    }

    pfi = fopen(nameIn, "rb");
    if (!pfi)
    {
        printf("Can't open %s for reading", nameIn);
        return 2;
    }
    fread(bufScr, 1, 6912, pfi);
    fclose(pfi);

    reorder(bufScr, bufIn);
    size = compress(bufIn, bufIn + 6912, bufOut, wnd);

    pfo = fopen(nameOut, "wb");
    //------------
    // В оригинальной версии без распаковщика файл записывается с заголовком:
    // LCMP5, 2Б - длина в месте с доп. байтом - типом картинки, 1Б=0 длина доп инфы, далее 1Б - тип картинки, далее упакованный экран.
    // Теперь сохраненные файлы без распаковщика можно просматривать в фаре с помощью плагинов.
    
    if (depacker)
    {
        fwrite(delasercompact, 1, sizeof(delasercompact), pfo);
    } else 
    {
    size++;
    fwrite("LCMP5", 1, 5, pfo);
    fwrite(&size, 1, 2, pfo);
    fwrite(&zero, 1, 1, pfo);//длина доп инфы
    fwrite(&zero, 1, 1, pfo);// 0 - признак того, что упакован весь экран, а не 1/3 или 2/3
    size--;
    }
    //------------
    
    fwrite(bufOut, 1, size, pfo);
    fclose(pfo);
    return 0;
}
