//Fuses LOW FUSE BYTE: 0xCF, HIGH FUSE BYTE: 0x18, LOCKOPT BYTE: 0x3F. 

#include <avr/io.h>
#include <avr/interrupt.h>
#include "usbdrv.h"
#include "uart.h"

uchar usbRxBuf[USB_BUFSIZE];  /* raw RX buffer: PID, 8 bytes data, 2 bytes CRC */
uchar FIFOBuf[(IN_SIZE+USB_BUFSIZE)*FIFO_BUF_SIZE]; // 3 bytes IN token + 11 bytes DATA token

uchar CurWritePos = 0;    //    IN-DATA (0-FIFO_BUF)
uchar CurReadPos  = 0;    //    IN-DATA (0-FIFO_BUF)

uchar strIN[] = "IN: ";
uchar strDATA[] = " DATAx: ";

/* ------------------------------------------------------------------------- */

void usbPoll(void)
{
	if(CurWritePos!=CurReadPos){
/*	 	msgout(strIN,4,0,0);
		msgout(usbRxBuf+CurReadPos*USB_BUFSIZE*2,3,1,0);
	 	msgout(strDATA,8,0,0);
		msgout(usbRxBuf+CurReadPos*USB_BUFSIZE*2+USB_BUFSIZE,USB_BUFSIZE,1,1);
*/		
		
		msgout(strIN,4,0,0);
		msgout(FIFOBuf+CurReadPos*(USB_BUFSIZE+IN_SIZE),IN_SIZE,1,0);
		msgout(strDATA,8,0,0);
		msgout(FIFOBuf+CurReadPos*(USB_BUFSIZE+IN_SIZE)+IN_SIZE,USB_BUFSIZE,1,1);
/*
		printHex(FIFOBuf[CurReadPos*(USB_BUFSIZE+IN_SIZE)+IN_SIZE+1]);
		printHex(FIFOBuf[CurReadPos*(USB_BUFSIZE+IN_SIZE)+IN_SIZE+2]);
		printHex(FIFOBuf[CurReadPos*(USB_BUFSIZE+IN_SIZE)+IN_SIZE+3]);
		printHex(FIFOBuf[CurReadPos*(USB_BUFSIZE+IN_SIZE)+IN_SIZE+4]);
		printHex(FIFOBuf[CurReadPos*(USB_BUFSIZE+IN_SIZE)+IN_SIZE+5]);
		printHex(FIFOBuf[CurReadPos*(USB_BUFSIZE+IN_SIZE)+IN_SIZE+6]);
		printHex(FIFOBuf[CurReadPos*(USB_BUFSIZE+IN_SIZE)+IN_SIZE+7]);
		printHex(FIFOBuf[CurReadPos*(USB_BUFSIZE+IN_SIZE)+IN_SIZE+8]); 	
*/
		CurReadPos++;
		if (CurReadPos>=FIFO_BUF_SIZE) CurReadPos = 0;		
	}

}

/* ------------------------------------------------------------------------- */

void usbInit(void)
{
	USB_INTR_CFG |= USB_INTR_CFG_SET;
	USB_INTR_ENABLE |= (1 << USB_INTR_ENABLE_BIT);
}


int main(void)
{
	usbInit();
 	USART_Init();
 	uchar msg[] = "UART init complet";
 	msgout(msg,17,0,1);
	sei();                  
	for(;;){                
      usbPoll();
	}	            
}
/* ------------------------------------------------------------------------- */ 
