/*
 * uart.h
 *
 * Created: 15.08.2013 15:25:55
 *  Author: 29ObrubovVU
 */ 


#ifndef UART_H_
#define UART_H_

//UART functions
void USART_Init()
{
	/* Set baud rate */
	UBRRL = F_CPU / (19200 * 16L) - 1;
	UCSRB = ( 1<<TXEN );//  
}


static void uartPutc(char c)
{
	while(!(UCSRA & (1 << UDRE)));    /* wait for data register empty */
	UDR = c;
}

static uchar hexAscii(uchar h)
{
	h &= 0xf;
	if(h >= 10)
	h += 'a' - (uchar)10 - '0';
	h += '0';
	return h;
}

static void printHex(uchar c)
{
	uartPutc(hexAscii(c >> 4));
	uartPutc(hexAscii(c));
}

//  
void msgout (uchar *data,uchar len, uchar hex, uchar eoln)
{

	while(len--){
		if (hex) {
			printHex(*data++);
			uartPutc(' ');
		}
		else
		{
			uartPutc(*data++);
		}
	}
	if (eoln) {
		uartPutc('\r');
		uartPutc('\n');
	}
}
// END UART funtions


#endif /* UART_H_ */