/* Name: usbconfig.h
 * Project: V-USB, virtual USB port for Atmel's(r) AVR(r) microcontrollers
 * Author: Christian Starkjohann
 * Creation Date: 2005-04-01
 * Copyright: (c) 2005 by OBJECTIVE DEVELOPMENT Software GmbH
 */

#ifndef __usbconfig_h_included__
#define __usbconfig_h_included__


/* ---------------------------- Hardware Config ----------------------------- */

/*USB_CFG_IOPORTNAME  ,     USB.    "B", 
       PORTB, PINB  DDRB.
 */
/* USB_CFG_DMINUS_BIT     USB_CFG_IOPORT,    D-,   
       .
 */
/* USB_CFG_DPLUS_BIT     USB_CFG_IOPORTNAME,    D+,   
       . ,   ,  D+    
      ]
 */



#define USB_CFG_IOPORTNAME      D
#define USB_INTR_CFG            MCUCR 

	 #define USB_CFG_DMINUS_BIT      5  //   
	 #define USB_CFG_DPLUS_BIT       2  //    PB2    INT0
	 #define USB_INTR_CFG_SET        ((1 << ISC00) | (1 << ISC01)) /* cfg for rising edge   INT0*/
	 #define USB_INTR_ENABLE         GIMSK
	 #define USB_INTR_ENABLE_BIT     INT0
	 #define USB_INTR_PENDING        GIFR
	 #define USB_INTR_PENDING_BIT    INTF0
	 #define USB_INTR_VECTOR         INT0_vect

#endif /* __usbconfig_h_included__ */
