		device zxspectrum128
        ORG #6001
cons
 db 25,239
pow
 db 16,4
divi
 db 5,239
begin
;ten=10,size=769

;    20 TEN=10: IF SIZE>200 THEN 50
;    30 TEN=100:SIZE=(SIZE+1)/2

;    50 POWER=4096:TERM=8192:RESULT=12288

;    60 DIV=1000:ADD=2000:SUB=3000:INIT=4000:COPY=5000

;;    70 DIM CONSTANT(2):CONSTANT(1)=25:CONSTANT(2)=239

power equ $4800
term equ $4000
result equ $5000
ten equ 10
size equ 10;769

;   100 REM  MAIN LOOP
;   125 FOR PASS=1 TO 2

pass_lp:
;   150 GOSUB INIT
 call init
;   200 GOSUB COPY
L200:; call copy
;  5000 REM  COPY "POWER" TO "TERM"
;  5010 FOR PLACE=0 TO SIZE
;  5020 POKE TERM+PLACE, PEEK (POWER+PLACE)
;  5030 NEXT PLACE
;  5040 RETURN 
 ld bc,size
 ld de,term
 ld hl,power
 ldir

; 210 POINT=TERM:DIVIDE=EXP: GOSUB DIV
 ld hl,term
 ld a,(exp_)
 ld (divide),a
 call div
;   220 IF SIGN>0 THEN GOSUB ADD
 ld a,(sign)
 or a
  push af
 jp m,L230
 call add_
L230:
;   230 IF SIGN<0 THEN GOSUB SUB
; ld a,(sign)
; or a
 pop af
 push af
 jp p,L240
 call sub_
L240:
;   240 EXP=EXP+2:SIGN=-SIGN
 pop af;ld a,(sign)
 neg
 ld (sign),a

 ld a,(exp_)
 add a,2
 ld (exp_),a
;   250 POINT=POWER:DIVIDE=CONSTANT(PASS): GOSUB DIV
 ld hl,power
 ld a,(pass)
 ld c,a
 ld b,cons/256
 ld a,(bc)
 ld (divide),a
  call div

;   260 IF PASS=2 THEN GOSUB DIV
 ld hl,power
 ld a,(pass)
 cp 2
 call z,div
;   270 IF ZERO<>0 THEN 200
 ld a,(zero)
 or a
 jp nz,L200
;   300 NEXT PASS
 ld a,(pass)
 inc a
 ld (pass),a
 cp 3:jp nz,pass_lp

;400 REM  PRINT THE RESULT
 ld hl,result
 ld de,#4000
print:
 push hl
 ld a,(hl);$3C00/8=$780
 add a,48+128
 ld l,a
 ld h,7
 add hl,hl
 add hl,hl
 add hl,hl

 ld b,8
 push de
pr1:
 ld a,(hl),(de),a
 inc hl,d
 djnz pr1

 pop de
 pop hl
 inc hl
 inc e:jr nz,print
 ld a,d:add a,8:ld d,a
 cp #58:jr nz,print
 
 jr $

;  1000 REM  DIVISION SUBROUTINE
div
;  1010 DIGIT=0:ZERO=0
;  1020 FOR PLACE=POINT TO POINT+SIZE
; ld hl,(point)
 ld bc,size
 xor a
 ld (zero),a
 ld ixh,a;ixh=DIGIT
L1030
 push bc
;  1030 DIGIT=DIGIT+ PEEK (PLACE)
 ld a,ixh
 add a,(hl)
 ld ixh,a
 ld d,a
;  1040 QUOTIENT=DIGIT/DIVIDE
;  1050 RESIDUE=DIGIT MOD DIVIDE
 call div_;Quot=D,A-remainder(residue)
 ld c,a;C=residue
;  1055 ZERO=ZERO OR (QUOTIENT+RESIDUE)
 add a,d;Q+R
 ld e,a
 ld a,(zero)
 or e
 ld (zero),a
;  1060 POKE PLACE,QUOTIENT
 ld (hl),d
 inc hl
;  1070 DIGIT=TEN*RESIDUE
 ld a,c
 add a,a
 ld c,a
 add a,a
 add a,a
 add a,c
 ld ixh,a
;  1080 NEXT PLACE
 pop bc
 dec bc
 bit 7,b
 jr z,L1030
;  1090 RETURN
 ret

;  2000 REM  ADDITION SUBROUTINE
add_
 ld hl,result+size
 ld de,term+size
 ld bc,size
;  2010 CARRY=0
 ld ixl,0
;  2020 FOR PLACE=SIZE TO 0 STEP -1
L2020
;  2030 SUM= PEEK (RESULT+PLACE)+ PEEK (TERM+PLACE)+CARRY
 ld a,(de)
 add a,(hl)
 add a,ixl
;  2040 CARRY=0
 ld ixl,0
;  2050 IF SUM<TEN THEN 2080
 cp ten
 jr c,L2080
;  2060 SUM=SUM-TEN
 sub ten
;  2070 CARRY=1
 inc ixl
L2080
;  2080 POKE RESULT+PLACE,SUM
 ld (hl),a
;  2090 NEXT PLACE
 dec hl
 dec de
 dec bc
 bit 7,b
 jr z,L2020
 ret;  2100 RETURN

;  3000 REM  SUBTRACTION SUBROUTINE
sub_
 ld ixl,0
;  3010 LOAN=0
 ld hl,term+size
 ld de,result+size
 ld bc,size
;  3020 FOR PLACE=SIZE TO 0 STEP -1
L3020
;  3030 DIFFERENCE= PEEK (RESULT+PLACE) - PEEK (TERM+PLACE)-LOAN
 ld a,(de)
 sub (hl)
 sub ixl
;  3040 LOAN=0
 ld ixl,0
;  3050 IF DIFFERENCE>=0 THEN 3080
 jp p,L3080
;  3060 DIFFERENCE=DIFFERENCE+TEN
;  3070 LOAN=1
 add a,ten
 inc ixl
L3080
;  3080 POKE RESULT+PLACE,DIFFERENCE
 ld (de),a
 dec hl
 dec de
 dec bc
;  3090 NEXT PLACE
 bit 7,b
 jr z,L3020
;  3100 RETURN
 ret


;  4000 REM  INITIALIZE REGISTERS
init
;  4010 FOR PLACE=0 TO SIZE
 ld bc,size
 ld hl,power
 ld de,term
 exx
 ld hl,result
 exx
init_lp
;  4020 POKE POWER+PLACE,0
;  4030 POKE TERM+PLACE,0
 xor a
 ld (hl),a
 ld (de),a
 inc hl
 inc de
;  4040 IF PASS=1 THEN POKE RESULT+PLACE,0
 ld  a,(pass)
 cp 1
 jr nz,next_i
 exx
 ld (hl),0
 inc hl
 exx
;  4050 NEXT PLACE
next_i
 dec bc
 bit 7,b
 jr z,init_lp

;  4060 POKE POWER,16/PASS ^ 2
 ld a,(pass)
 add a,2
 ld c,a
 ld b,pow/256
 ld a,(bc)
 ld (power),a
;  4070 IF PASS=1 THEN DIVIDE=5
;  4080 IF PASS=2 THEN DIVIDE=239
 inc c
 inc c
 ld a,(bc)
 ld (divide),a
;  4090 POINT=POWER: GOSUB DIV
 ld hl,power
 call div
;  4100 EXP=1:SIGN=3-2*PASS
;  4110 RETURN
 ld a,1
 ld (exp_),a
 ld a,(pass)
 ld c,a
 ld a,3
 sub c
 sub c
 ld (sign),a
 ret

pass db 1
exp_ db 1
sign db 1
divide db 0
zero db 0

;2.1 Restoring 8-bit / 8-bit Unsigned
;Input: D = Dividend, E = Divisor, A = 0
;Output: D = Quotient, A = Remainder
;
div_
 ld a,(divide)
 ld e,a
div_2:
 xor a
 ld b,8
div_lp
	sla	d		; unroll 8 times
	rla			; ...
	cp	e		; ...
	jr	c,$+4	; ...
	sub	e		; ...
	inc	d		; ...
 djnz div_lp
 ret

end
	display /d,end-begin
	savesna "!void.sna",begin
