@echo off
rem ----------------------------------------------------------------------------
rem There are two input parameters:
rem   1. filename (without path),
rem   2. project file name.
rem ----------------------------------------------------------------------------

set ASM="D:\\Spectrum\\Work\\SjasmPlus\\sjasmplus.exe"

if not exist %2 (
	%ASM% %1
	exit
)

set ProjectPath=%~dp2
set ProjectFileName=%~n2

chdir /d "%ProjectPath%"
if exist "Compile.bat" (
	call "Compile.bat" "%ProjectFileName%.a80"
	exit /B
	)

set MainFileFolder=""
for /R /D %%f in (.) do if exist %%f\%ProjectFileName%.a80 (
	set MainFileFolder=%%f
	goto :found
)

echo "Main file is not found"
exit -1

:found
chdir /d %MainFileFolder%

%ASM% --fullpath --sym="%ProjectFileName%.sym" "%ProjectFileName%".a80