#ifndef __TurboSoundFM_H__
#define __TurboSoundFM_H__

#if defined(__18F2550)

/** YM data bus ************************/

/** YM data bus port */
#define YMBUSPORT PORTB
/** YM data bus direction */
#define YMBUSDIR  TRISB

/** YM control pins ********************/

/** Write pin (0 - write mode) */
#define YMWR_PIN  PORTAbits.RA0
/** Read pin (0 - read mode) */
#define YMRD_PIN  PORTAbits.RA1
/** A0 pin (0 - address mode/1 - data mode) */
#define YMA0_PIN  PORTAbits.RA2
/** Reset pin (0 - reset) */
#define YMRES_PIN PORTAbits.RA3
/** FM enable bit (0 - enable/1-disable) */
#define YMFM_PIN  PORTAbits.RA4
/** Select chip pin */
#define YMSEL_PIN PORTCbits.RC0

/** Bootloader mode control ************/

/** Determine bootloader mode */
#define BOOTSEL   PORTCbits.RC1

/** LED control ************************/

/** LED pin */
#define LED       PORTCbits.RC2

/** Initial macroses *******************/
/** Reset YM, set control pin and bus direction */
#define YM_init()  {PORTA=0x13; TRISA&=0xE0; PORTCbits.RC0=0; TRISCbits.TRISC0=0; TRISB=0xFF; }
#define LED_init() {TRISCbits.TRISC2=0;}

#endif

#endif //__TurboSoundFM_H__
