#include <errno.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>


#define BUFSIZE		16384

#ifndef __dead
#define __dead		__attribute__((__noreturn__))
#endif

#ifndef O_BINARY
#define O_BINARY	0
#endif

#ifdef HAVE_PROGNAME
extern char *__progname;
#else
static const char *__progname;
#endif


static int combine;
static int split;


static __dead void
usage(void)
{
	(void)fprintf(stderr,
	    "usage: %s -c file_lsb file_msb file\n"
	    "       %s -s file file_lsb file_msb\n",
	    __progname, __progname);
	exit(1);
}

int
main(int argc, char *const argv[])
{
	char buf[BUFSIZE], lbuf[BUFSIZE / 2], mbuf[BUFSIZE / 2];
	int ch, fd, fl, fm;
	ssize_t sz, i;

#ifndef HAVE_PROGNAME
	const char *cp;

#ifdef _WIN32
	cp = strrchr(argv[0], '\\');
#else
	cp = strrchr(argv[0], '/');
#endif

	__progname = cp == NULL ? argv[0] : ++cp;

#endif	/* HAVE_PROGNAME */

	while ((ch = getopt(argc, argv, "cs")) != -1)
		switch (ch) {
		case 'c':
			combine++;
			break;
		case 's':
			split++;
			break;
		default:
			usage();
			/*NOTREACHED*/
		}
	argv += optind;

	if ((argc -= optind) != 3)
		usage();
	if ((!split && !combine) || (split && combine))
		usage();

	if (split) {
		if ((fd = open(argv[0], O_RDONLY | O_BINARY)) < 0) {
		err0:	(void)fprintf(stderr, "%s: open %s: %s\n",
			    __progname, argv[0], strerror(errno));
			return (1);
		}

		if ((fl = open(argv[1],
		    O_WRONLY | O_CREAT | O_TRUNC | O_BINARY, 0644)) < 0) {
		err1:	(void)fprintf(stderr, "%s: open %s: %s\n",
			    __progname, argv[1], strerror(errno));
			return (1);
		}

		if ((fm = open(argv[2],
		    O_WRONLY | O_CREAT | O_TRUNC | O_BINARY, 0644)) < 0) {
		err2:	(void)fprintf(stderr, "%s: open %s: %s\n",
			    __progname, argv[2], strerror(errno));
			return (1);
		}

		for (;;) {
			char *p;

			if ((sz = read(fd, buf, sizeof(buf))) < 0) {
				(void)fprintf(stderr,
				    "%s: read %s: %s\n", __progname,
				    argv[0], strerror(errno));
				return (1);
			}

			if (sz == 0)
				break;

			for (i = 0, p = buf; i < sz; i += 2) {
				lbuf[i / 2] = *(p++);
				mbuf[i / 2] = *(p++);
			}

			if (write(fl, lbuf, (size_t)sz / 2) < 0) {
				(void)fprintf(stderr,
				    "%s: write %s: %s\n", __progname,
				    argv[1], strerror(errno));
				return (1);
			}

			if (write(fm, mbuf, (size_t)sz / 2) < 0) {
				(void)fprintf(stderr,
				    "%s: write %s: %s\n", __progname,
				    argv[2], strerror(errno));
				return (1);
			}
		}

		(void)close(fl);
		(void)close(fm);
	} else {
		ssize_t sz1, sz2;

		if ((fl = open(argv[0], O_RDONLY | O_BINARY)) < 0)
			goto err0;

		if ((fm = open(argv[1], O_RDONLY | O_BINARY)) < 0)
			goto err1;

		if ((fd = open(argv[2],
		    O_WRONLY | O_CREAT | O_TRUNC | O_BINARY, 0644)) < 0)
			goto err2;

		for (;;) {
			char *p;

			if ((sz1 = read(fl, lbuf, sizeof(lbuf))) < 0) {
				(void)fprintf(stderr,
				    "%s: read %s: %s\n", __progname,
				    argv[0], strerror(errno));
				return (1);
			}

			if ((sz2 = read(fm, mbuf, sizeof(mbuf))) < 0) {
				(void)fprintf(stderr,
				    "%s: read %s: %s\n", __progname,
				    argv[1], strerror(errno));
				return (1);
			}

			if ((sz = sz1 < sz2 ? sz1 : sz2) == 0)
				break;

			for (i = 0, p = buf; i < sz; i++) {
				*(p++) = lbuf[i];
				*(p++) = mbuf[i];
			}

			if (write(fd, buf, (size_t)sz * 2) < 0) {
				(void)fprintf(stderr,
				    "%s: write %s: %s\n", __progname,
				    argv[2], strerror(errno));
				return (1);
			}
		}

		(void)close(fd);
	}

	return (0);
}
