MODULE Durak; (** non-portable *)
IMPORT L := Laser, B := Basic, Rsrc, Cfg := Config;

CONST
  PAPER = B.Paper;

PROCEDURE ^ PrepareGame;

(* ========================================================================== *)

PROCEDURE Main; (** Prepare title, init game data. *)
VAR
  x: (* UNSIGNED *) B.Coords; color: B.Color;
BEGIN (*$MAIN*)
  B.Init; L.InitSprites(Rsrc.SprStart, Rsrc.SprSize);

  (* Prepare screen & title, set up colors, write "WAIT...": *)
  (* ------------------------------------------------------- *)
  B.OVER(B.Off); B.INVERSE(B.Off);
  B.COLOR(B.LightGray); B.BORDER(B.Black); B.CLS;
  B.AT(21, 3); B.PRSTR("WAIT...");

  (* Draw invisible circles & prepare drawing logotype "M": *)
  (* ------------------------------------------------------ *)
  B.INVERSE(B.On); B.COLOR(B.Blue);
  x := 1; REPEAT (* FOR x := 1 TO 73 BY 8 DO *)
    B.CIRCLE(121, 85, x); INC(x, 8);
  UNTIL x = 73+8; (* END; *)
  IF Cfg.Classic THEN
    B.POKE(23112, B.Blue); (* Fix attrib for accuracy. *)
    B.POKE(23156, B.White); (* Fix attrib for accuracy. *)
  END;

  color := B.Red;
  FOR x := 43 TO 57 BY 7 DO
    B.INK(color); INC(color, 2); (* {Red=2, Green=4, Yellow=6} *)
    B.PLOT(x, 50);
    B.DRAW(40, 70); B.DRAW(30, -70); B.DRAW(40, 70); B.DRAW(30, -70);
  END;
  B.INVERSE(B.Off);


PrepareGame;


  B.Quit;
END Main;

(* ========================================================================== *)

PROCEDURE PrepareGame; (** DrawTitle, PlayMusic, Shuffle and give cards. *)
VAR
  x, y: (* UNSIGNED *) B.Coords;
BEGIN
  (* Draw "firmware" title with logotype "M": *)
  (* ---------------------------------------- *)
  L.ATOF;
  FOR x := 0 TO 32 BY 4 DO
    FOR y := 0 TO 16 BY 8 DO
      L.PTBL(x, y, Rsrc.LogotypeM); L.PTBL(30 - x, 20 - y, Rsrc.LogotypeM);
    END;
  END;
  L.ATON; B.BRIGHT(B.On);

  B.PAUSE(0);
END PrepareGame;

END Durak.

(* ToDo:
*)
