//
//  i8080debug.h
//
//  Disassembler / Debuger for i8080
//
//  Created by Alexander Medvedev on 19/05/14.
//  Copyright (c) 2014 Alexander Medvedev. All rights reserved.
//

#ifndef i8080debug_h
#define i8080debug_h

#define I8080HISTORYSIZE    2000      // Rollback steps

// Dump of memory from addr to addr2, 16 byte grain

void memory_dump(word addr, word addr2);

// Dump i8080 state to stdout

void i8080dump(i8080state * i8080);

// Disassemble i8080 instruction, returns its size in bytes

int  i8080disasm(char * text, word offset);

// Interactive debugger - just run it

void i8080debug(i8080state * i8080);

#endif
