//
//  i8080.h
//
//  Intel i8080 CPU emulation
//  Short and clean
//
//  Created by Alexander Medvedev on 03/04/14.
//  Copyright (c) 2014 Alexander Medvedev. All rights reserved.
//

#ifndef i8080_h
#define i8080_h

//
// Settings for code generation
//

#define I8080DEBUG          // If you nedd debug prints

#define I8080TRAPS          // If you need trap at some PC addr
#define I8080BIGTABLES      // If you have enought memory (~256K) for speedup of ADD/SUB flags

#define I8080ENGINE         // If you need additional per-instruction activity

//
// i8080 Flag register [ S | Z | 0 | H | 0 | P | 1 | C ]
//

#define I8080FLAGS   128     // negative
#define I8080FLAGZ   64      // zero
#define I8080FLAG5   32      // 0
#define I8080FLAGH   16      // half carry
#define I8080FLAG3   8       // 0
#define I8080FLAGP   4       // even
#define I8080FLAG1   2       // 1
#define I8080FLAGC   1       // carry

//
// CPU State
//

typedef struct {
    
    // i8080 state
    
    pair    af;
    pair    bc, de, hl;
    word    sp, pc;
    
    int     iff;    // Interrupt flip-flop (DI: IFF=0)
    
    // Other stuff
    
    int     t;      // Tacts left (decremented by execute)
    
    int     Ticks;  // if true - runs while t>0
    int     Debug;  // if true - stops when PC == Trap
    int     Halt;   // if true - stops on HLT
    
    word    Trap;   // Trap address for Debug
    
    int     DebugInfo;      // Debug info level
    char *  DebugName;      // Name to print before debug info
    
    void *  EngineState;    // Parameter for you engine function
    
    // Pointer to you engine and tacts left
    void    (*Engine)(void * state, int t);

} i8080state;

//
// Functions
//

// Call this before use, and change DebugName afterwards if neede

void i8080init(i8080state * i8080);

// Execute instructions
// Returns 0 if t<=0 and Ticks, 1 if PC at HLT and Halt, 2 if PC == Trap and Debug

int  i8080execute(i8080state * i8080);

// Initiate INT, data: cmd on data bus.
// Returns 0 - processed, -1 - rejected.
// Yet supports only RST N

int  i8080int(i8080state * i8080, byte data);

//
// I/O Handlers
//

// You need to define them somewhere:

extern byte memory_read(word addr);
extern void memory_write(word addr, byte data);

extern byte port_read(byte addr);
extern void port_write(byte addr, byte data);

#endif