//
//  i8255.h
//
//  Intel i8255 PPI Emulation
//
//  Created by Alexander Medvedev on 02/06/14.
//  Copyright (c) 2014 Alexander Medvedev. All rights reserved.
//

#ifndef i8255_h
#define i8255_h

#define I8255DEBUG      // If you want debug output switchable by .DebugInfo

//
// i8255 State
//

typedef struct {
    
    byte A;     // A
    byte B;     // B
    byte C1;    // C[3210]
    byte C2;    // C[7654]
    
    int AC2bidir;               // Bidirectional bus on A
    
    int AC2strobe;              // A & C2 Strobed
    int BC1strobe;              // B & C1 Strobed
    
    int Ain, Bin, C1in, C2in;   // In/Out
    
    // Stuff
    
    int     DebugInfo;
    char *  DebugName;
    
} i8255state;

// Call this before use
void i8255init(i8255state * i8255);

// Write and read, A = [ X ... X A1 A0]
void i8255write(i8255state * i8255, int A, byte data);
byte i8255read(i8255state * i8255, int A);

// Dump state to stdout
void i8255dump(i8255state * i8255);

#endif
