//
//  i8257.h
//  rk86
//
//  Created by Alexander Medvedev on 20/05/14.
//  Copyright (c) 2014 Alexander Medvedev. All rights reserved.
//

#ifndef rk86_i8257_h
#define rk86_i8257_h

//
// i8257 DMA controller
//
// ADDR FLIP=0  FLIP=1
// 0    CH0AL   CH0AH   AH=[A15..A8]     AL=[A7..A0]
// 1    CH0TL   CH0TH   TH=[R|W|T13..T8] TL=[T7..T0]
// 2    CH1AL   CH1AH
// 3    CH1TL   CH1TH   R W
// 4    CH2AL   CH2AH   0 0 Verify
// 5    CH2TL   CH2TH   1 0 Read
// 6    CH3AL   CH3AH   0 1 Write
// 7    CH3TL   CH3TH   1 1 Illegal
//
// 8W   MODE
// 8R   STATUS
//
// MODE is [ AL | TCS | EW | RP | E3 | E2 | E1 | E0 ]
//
// AL: 1 autoreload CH2 -> CH1 / 0 none  TCS: 1 stop on terminal count 0 none
// EW: 1 extended write time 0 none RP: 1 rotating priority 0 fixed
// E3..E0: 1 channel on 0 off
//
// STATUS is [ 0 0 0 | UP | TC3 | TC2 | TC1 | TC0 ]
//
// UP: 1 CH1 was reloaded from CH2 0 not
// TC3..TC0: 1 Terminal count reached 0 not

typedef struct {
    
    word Address[4];
    int Terminate[4];
    
    int Write[4], Read[4], Enable[4];
    
    int Autoload, TerminalStop;
    int Up;
    
    // Internal

    int Flip;
    int DebugInfo;

} i8257state;

void i8257init(i8257state * i8257);
void i8257write(i8257state * i8257, int A, byte data);
byte i8257read(i8257state * i8257, int A);

int  i8257dmaread(i8257state * i8257, byte * data, int channel);
int  i8257dmawrite(i8257state * i8257, int channel, byte data);

void i8257dump(i8257state * i8257);

#endif
