;***********************************************************************************************************************
;*   INTERRUPTS.asm   "SUPER JOYSTICK PORT 2"
;* (C) 2015  
;* 150219-02
;***********************************************************************************************************************
;***********************************************************************************************************************
;* 150216-02                                0
;***********************************************************************************************************************
TIM0_COMPA:
        SAVE_SREG                       ;  SREG
        SAVE_TEMP                       ;   temp
        inc     cnt_tim0                ;     

        cpi     cnt_tim0,9              ; ,   9
        brlo    Tim0_04

        cpi     cnt_tim0,48             ;    48 - 
        brne    Tim0_02
        ldi     cnt_tim0,0
Tim0_02:
        rjmp    Tim0_End

Tim0_04:
        cpi     cnt_tim0,1              ;      1  8
        breq    Tim0_10
        cpi     cnt_tim0,2
        breq    Tim0_20
        cpi     cnt_tim0,3
        breq    Tim0_30
        cpi     cnt_tim0,4
        breq    Tim0_40
        cpi     cnt_tim0,5
        breq    Tim0_50
        cpi     cnt_tim0,6
        breq    Tim0_60
        cpi     cnt_tim0,7
        breq    Tim0_70
        cpi     cnt_tim0,8
        breq    Tim0_80
        rjmp    Tim0_End

Tim0_10:
        ldi     temp,$FF               ;       "  "
        mov     sega1_byte1,temp
        mov     sega1_byte2,temp
        mov     sega2_byte1,temp
        mov     sega2_byte2,temp

        READ_SEGA1_LEFT                 ;      1
        READ_SEGA1_RIGHT
        READ_SEGA1_DOWN
        READ_SEGA1_UP
        READ_SEGA1_B
        READ_SEGA1_C

        CLR_SEGA_SYN                    ;  0    SEGA 
        rjmp    Tim0_End

Tim0_20:
        READ_SEGA1_A                    ;      1
        READ_SEGA1_START

        SET_SEGA_SYN                    ;  1    SEGA 
        rjmp    Tim0_End

Tim0_30:
        CLR_SEGA_SYN
        rjmp    Tim0_End

Tim0_40:
        SET_SEGA_SYN
        rjmp    Tim0_End

Tim0_50:
        CLR_SEGA_SYN
        rjmp    Tim0_End

Tim0_60:
        SET_SEGA_SYN
        rjmp    Tim0_End

Tim0_70:

        READ_SEGA1_X                    ;      1
        READ_SEGA1_Y
        READ_SEGA1_Z
        READ_SEGA1_SELECT

        ldi     sega_state,READY        ;      SEGA 

        CLR_SEGA_SYN
        rjmp    Tim0_End

Tim0_80:
        SET_SEGA_SYN
        rjmp    Tim0_End

Tim0_End:
        LOAD_TEMP                       ;   temp
        LOAD_SREG                       ;  SREG
        reti

;***********************************************************************************************************************
