;***********************************************************************************************************************
;*   MAIN.asm   "SUPER JOYSTICK PORT 2"
;* (C) 2015  
;*
;* 150219-05
;***********************************************************************************************************************
;***********************************************************************************************************************
;* 150219-05                              
;***********************************************************************************************************************
Main:
        ldi     temp,low(RAMEND)        ;     
        out     SPL,temp
        ldi     temp,high(RAMEND)
        out     SPH,temp

;--------------------------------------   - --------------------------------------------------

        INIT_PORTS                      ;   -
        CLR_REG_SHIFT                   ;       
        CLR_REG_LATCH                   ;       
        SET_SEGA_SYN                    ;     SEGA 

;--------------------------------------     ----------------------------------------

        ldi     xh,1                    ;     
        rcall   ClearOutBuf             ;    -    
        rcall   OutBufToRegs            ;      

;--------------------------------------    INT1 ----------------------------------------------

;         ldi     temp,(1<<ISC11)         ;   INT1     PS/2 
;         sts     EICRA,temp
;         ldi     temp,(1<<INT1)
;         out     EIMSK,temp
;--------------------------------------     0   50  ---------------------------

        ldi     temp,(1<<WGM01)         ;  CTC (  )
        out     TCCR0A,temp
        ldi     temp,(1<<CS01)          ;   clk/8
        out     TCCR0B,temp
        ldi     temp,68                 ;    0  68
        out     OCR0A,temp              ;    T=(8*69)/11.0592=49.9 
        ldi     temp,(1<<OCIE0A)        ;      =68
        sts     TIMSK0,temp

        ldi     temp,$FF                ;       "  "
        mov     sega1_byte1,temp
        mov     sega1_byte2,temp
        mov     sega2_byte1,temp
        mov     sega2_byte2,temp

        ldi     cnt_tim0,0              ;     0
        ldi     sega_state,PROCESS      ;       SEGA 

        ldi     zl,low(SINCLAIR1*2)     ;   SINCLAIR1  FLASH
        mov     SEGA1_zl,zl             ;  .    FLASH
        ldi     zh,high(SINCLAIR1*2)
        ldi     yl,low(SEGA1_table)     ;   1   SRAM
        ldi     yh,high(SEGA1_table)
        ldi     cnt,10                  ;  
Main_10:
        lpm     temp,z+                 ;  
        st      y+,temp
        dec     cnt
        brne    Main_10

        rcall   Delay1S                 ;  1 
        sei                             ;  

;--------------------------------------   -    -------------------------
;                                            

MainCycle:
        cpi     sega_state,READY        ;    SEGA  ?
        breq    SegaToOut

        rjmp    MainCycle


SegaToOut:
        rcall   ClearOutBuf             ;    -    
        rcall   WorkSegaData            ;    SEGA 
        ldi     sega_state,PROCESS      ;    SEGA  ,    
        rcall   OutBufToRegs            ;      

        rjmp    MainCycle

;***********************************************************************************************************************
