;***********************************************************************************************************************
;*   SRAM_DATA.asm   "SUPER JOYSTICK PORT 2"
;* (C) 2015  
;*
;* 150221-02
;***********************************************************************************************************************

;***********************************************************************************************************************
;* 150221-02                             PS/2 
;***********************************************************************************************************************

PS2_KEYBOARD_TABLE:                     ;  , 128 -   E0
;                   00        01        02        03        04        05        06        07
;                   --        F9        --        F5        F3        F1        F2        F12
              .DB   NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL

;                   08        09        0A        0B        0C        0D        0E        0F
;                   --        F10       F8        F6        F4        TAB       `         --
              .DB   NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL

;                   10        11        12        13        14        15        16        17
;                   --        L ALT     L SHIFT   --        L CTRL    Q         1         --
              .DB   NULL,     NULL,     KEY_CS,   NULL,     NULL,     KEY_Q,    KEY_1,    NULL

;                   18        19        1A        1B        1C        1D        1E        1F
;                   --        --        Z         S         A         W         2         --
              .DB   NULL,     NULL,     KEY_Z,    KEY_S,    KEY_A,    KEY_W,    KEY_2,    NULL

;                   20        21        22        23        24        25        26        27
;                   --        C         X         D         E         4         3         --
              .DB   NULL,     KEY_C,    KEY_X,    KEY_D,    KEY_E,    KEY_4,    KEY_3,    NULL

;                   28        29        2A        2B        2C        2D        2E        2F
;                   --        SPACE     V         F         T         R         5         --
              .DB   NULL,     KEY_SP,   KEY_V,    KEY_F,    KEY_T,    KEY_R,    KEY_5,    NULL

;                   30        31        32        33        34        35        36        37
;                   --        N         B         H         G         Y         6         --
              .DB   NULL,     KEY_N,    KEY_B,    KEY_H,    KEY_G,    KEY_Y,    KEY_6,    NULL

;                   38        39        3A        3B        3C        3D        3E        3F
;                   --        --        M         J         U         7         8         --
              .DB   NULL,     NULL,     KEY_M,    KEY_J,    KEY_U,    KEY_7,    KEY_8,    NULL

;                   40        41        42        43        44        45        46        47
;                   --        ,         K         I         O         0         9         --
              .DB   NULL,     NULL,     KEY_K,    KEY_I,    KEY_O,    KEY_0,    KEY_9,    NULL

;                   48        49        4A        4B        4C        4D        4E        4F
;                   --        .         /         L         ;         P         -         --
              .DB   NULL,     NULL,     NULL,     KEY_L,    NULL,     KEY_P,    NULL,     NULL

;                   50        51        52        53        54        55        56        57
;                   --        --        '         --        [         =         --        --
              .DB   NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL

;                   58        59        5A        5B        5C        5D        5E        5F
;                   CAPS      R SHIFT   ENTER     ]         --        \         --        --
              .DB   NULL,     KEY_SS,   KEY_EN,   NULL,     NULL,     NULL,     NULL,     NULL

;                   60        61        62        63        64        65        66        67
;                   --        --        --        --        --        --        BKSP      --
              .DB   NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL

;                   68        69        6A        6B        6C        6D        6E        6F
;                   --        KP 1      --        KP 4      KP 7      --        --        --
              .DB   NULL,     KEY_1,    NULL,     KEY_4,    KEY_7,    NULL,     NULL,     NULL

;                   70        71        72        73        74        75        76        77
;                   KP 0      KP .      KP 2      KP 5      KP 6      KP 8      ESC       NUM
              .DB   KEY_0,    NULL,     KEY_2,    KEY_5,    KEY_6,    KEY_8,    NULL,     NULL

;                   78        79        7A        7B        7C        7D        7E        7F
;                   F11       KP +      KP 3      KP -      KP *      KP 9      SCROLL    --
              .DB   NULL,     NULL,     KEY_3,    NULL,     NULL,     KEY_9,    NULL,     NULL
;-----------------------------------------------------------------------------------------------------------------------
                                        ;  , 128 -   E0
;                   00        01        02        03        04        05        06        07
;                   --        --        --        --        --        --        --        --
              .DB   NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL

;                   08        09        0A        0B        0C        0D        0E        0F
;                   --        --        --        --        --        --        --        --
              .DB   NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL

;                   10        11        12        13        14        15        16        17
;                   --        R ALT     PRNT1     --        R CTRL    --        --        --
              .DB   NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL

;                   18        19        1A        1B        1C        1D        1E        1F
;                   --        --        --        --        --        --        --        L GUI
              .DB   NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL

;                   20        21        22        23        24        25        26        27
;                   --        --        --        --        --        --        --        R GUI
              .DB   NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL

;                   28        29        2A        2B        2C        2D        2E        2F
;                   --        --        --        --        --        --        --        APPS
              .DB   NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL

;                   30        31        32        33        34        35        36        37
;                   --        --        --        --        --        --        --        --
              .DB   NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL

;                   38        39        3A        3B        3C        3D        3E        3F
;                   --        --        --        --        --        --        --        --
              .DB   NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL

;                   40        41        42        43        44        45        46        47
;                   --        --        --        --        --        --        --        --
              .DB   NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL

;                   48        49        4A        4B        4C        4D        4E        4F
;                   --        --        KP /      --        --        --        --        --
              .DB   NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL

;                   50        51        52        53        54        55        56        57
;                   --        --        --        --        --        --        --        --
              .DB   NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL

;                   58        59        5A        5B        5C        5D        5E        5F
;                   --        --        KP EN     --        --        --        --        --
              .DB   NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL

;                   60        61        62        63        64        65        66        67
;                   --        --        --        --        --        --        --        --
              .DB   NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL

;                   68        69        6A        6B        6C        6D        6E        6F
;                   --        END       --        LEFT      HOME      --        --        --
              .DB   NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL

;                   70        71        72        73        74        75        76        77
;                   INSERT    DELETE    DOWN      --        RIGHT     UP        --        --
              .DB   NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL

;                   78        79        7A        7B        7C        7D        7E        7F
;                   --        --        PG DN     --        PRNT2     PG UP     --        --
              .DB   NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL


;***********************************************************************************************************************
;* 150219-04                             SEGA 
;***********************************************************************************************************************

;                   UP        LEFT      RIGHT     DOWN      X         Y         Z         A         B         C
SINCLAIR1:    .DB   KEY_4,    KEY_1,    KEY_2,    KEY_3,    KEY_1,    KEY_2,    KEY_3,    KEY_4,    KEY_0,    KEY_5
SINCLAIR2:    .DB   KEY_9,    KEY_6,    KEY_7,    KEY_8,    KEY_1,    KEY_2,    KEY_3,    KEY_4,    KEY_0,    KEY_0
KEMPSTON:     .DB   KEMP_U,   KEMP_L,   KEMP_R,   KEMP_D,   KEY_1,    KEY_2,    KEY_3,    KEY_4,    KEY_0,    KEMP_F
CURSOR:       .DB   KEY_7,    KEY_5,    KEY_8,    KEY_6,    KEY_1,    KEY_2,    KEY_3,    KEY_4,    KEY_0,    KEY_EN
QAOPM:        .DB   KEY_Q,    KEY_O,    KEY_P,    KEY_A,    KEY_1,    KEY_2,    KEY_3,    KEY_4,    KEY_0,    KEY_M
ELITE:        .DB   KEY_S,    KEY_N,    KEY_M,    KEY_X,    KEY_T,    KEY_SP,   KEY_J,    KEY_F,    KEY_SS,   KEY_A
ROW1:         .DB   KEY_1,    KEY_2,    KEY_3,    KEY_4,    KEY_5,    KEY_6,    KEY_7,    KEY_8,    KEY_9,    KEY_0
ROW2:         .DB   KEY_Q,    KEY_W,    KEY_E,    KEY_R,    KEY_T,    KEY_Y,    KEY_U,    KEY_I,    KEY_O,    KEY_P
ROW3:         .DB   KEY_A,    KEY_S,    KEY_D,    KEY_F,    KEY_G,    KEY_H,    KEY_J,    KEY_K,    KEY_L,    KEY_EN
ROW4:         .DB   KEY_CS,   KEY_Z,    KEY_X,    KEY_C,    KEY_V,    KEY_B,    KEY_N,    KEY_M,    KEY_SS,   KEY_SP

