;***********************************************************************************************************************
;*   INTERRUPTS.asm   "SUPER JOYSTICK PORT 2"
;* (C) 2015  
;* 150223-04
;***********************************************************************************************************************
;***********************************************************************************************************************
;* 150223-04                                0
;*                                       SEGA ,      CS  SS
;***********************************************************************************************************************
TIM0_COMPA:
        SAVE_SREG                       ;  SREG
        SAVE_TEMP                       ;   temp

        inc     SEGA_cnt                ;     
        cpi     SEGA_cnt,9
        brlo    Tim0_00

        rjmp    Tim0_90                 ; ,    9  

Tim0_00:
        cpi     SEGA_cnt,1              ;      1  8
        breq    Tim0_10
        cpi     SEGA_cnt,2
        breq    Tim0_20
        cpi     SEGA_cnt,3
        breq    Tim0_30
        cpi     SEGA_cnt,4
        breq    Tim0_40
        cpi     SEGA_cnt,5
        breq    Tim0_50
        cpi     SEGA_cnt,6
        breq    Tim0_60
        cpi     SEGA_cnt,7
        breq    Tim0_70
        cpi     SEGA_cnt,8
        breq    Tim0_80
        rjmp    Tim0_End

Tim0_10:
        ldi     temp,$FF               ;       "  "
        mov     sega1_byte1,temp
        mov     sega1_byte2,temp
        mov     sega2_byte1,temp
        mov     sega2_byte2,temp

        READ_SEGA1_LEFT                 ;      1
        READ_SEGA1_RIGHT
        READ_SEGA1_DOWN
        READ_SEGA1_UP
        READ_SEGA1_B
        READ_SEGA1_C

        CLR_SEGA_SYN                    ;  0    SEGA 
        rjmp    Tim0_End

Tim0_20:
        READ_SEGA1_A                    ;      1
        READ_SEGA1_START

        SET_SEGA_SYN                    ;  1    SEGA 
        rjmp    Tim0_End

Tim0_30:
        CLR_SEGA_SYN
        rjmp    Tim0_End

Tim0_40:
        SET_SEGA_SYN
        rjmp    Tim0_End

Tim0_50:
        CLR_SEGA_SYN
        rjmp    Tim0_End

Tim0_60:
        SET_SEGA_SYN
        rjmp    Tim0_End

Tim0_70:

        READ_SEGA1_X                    ;      1
        READ_SEGA1_Y
        READ_SEGA1_Z
        READ_SEGA1_SELECT

        ldi     sega_state,READY        ;      SEGA 

        CLR_SEGA_SYN
        rjmp    Tim0_End

Tim0_80:
        SET_SEGA_SYN
        rjmp    Tim0_End

Tim0_90:
        cpi     SEGA_cnt,SEGA_CNT_MAX   ;     -  /
        brne    Tim0_End

        ldi     SEGA_cnt,SEGA_CNT_START ;  ,     SEGA
                                        ;     CS  SS:

        cpi     CS_cnt,CS_CNT_STOP      ;   CS ,  
        breq    Tim0_100

        cpi     CS_cnt,CS_CNT_MAX       ;   CS   ,  
        breq    Tim0_100

        inc     CS_cnt                  ;    - 

Tim0_100:
        cpi     SS_cnt,SS_CNT_STOP      ;   SS ,  
        breq    Tim0_End

        cpi     SS_cnt,SS_CNT_MAX       ;   SS   ,  
        breq    Tim0_End

        inc     SS_cnt                  ;    - 

Tim0_End:
        LOAD_TEMP                       ;   temp
        LOAD_SREG                       ;  SREG
        reti

;***********************************************************************************************************************
