;***********************************************************************************************************************
;*   PROCESS_KEY.asm   "SUPER JOYSTICK PORT 2"
;* (C) 2015  
;*
;* 150223-04
;***********************************************************************************************************************
;***********************************************************************************************************************
;* 150223-04                                  SEGA 
;*
;*                                      :  temp =    PS/2   SEGA 
;*                                             xh   =     
;*                                      :        
;***********************************************************************************************************************
ProcessKey:
        sbrc    temp,BIT_CS
        rjmp    ProcessKey_CS           ; ,      CS

        sbrc    temp,BIT_SS
        rjmp    ProcessKey_SS           ; ,      SS

        mov     xl,temp                 ;        
        ldi     temp,PRESS              ;        ,    
        st      x,temp
        ret

ProcessKey_CS:
        sbrc    temp,BIT_SS
        rjmp    ProcessKey_EXT          ;     ,  : CS  SS

        sbr     flags,CS                ;     CS
        cpi     CS_cnt,CS_CNT_MAX       ;     CS   ,
        brne    ProcessKey_End          ;  c CS  

        cbr     temp,CS                 ;   -  ,     CS
        rjmp    ProcessKey_100

ProcessKey_SS:
        sbr     flags,SS                ;     SS
        cpi     SS_cnt,SS_CNT_MAX       ;     SS   ,
        brne    ProcessKey_End          ;  c SS  

        cbr     temp,SS                 ;   -  ,     SS
        rjmp    ProcessKey_100

ProcessKey_EXT:
        rjmp    ProcessKey_End          ;  CS+SS  

ProcessKey_100:
        mov     xl,temp                 ;        
        ldi     temp,PRESS              ;        ,    
        st      x,temp

ProcessKey_End:
        ret

;***********************************************************************************************************************
;* 150223-03                               CS  SS
;***********************************************************************************************************************
ProcessCSSS:
        sbrc    flags,BIT_CS
        rjmp    ProcessCSSS_10          ; ,   CS 

        ldi     CS_cnt,CS_CNT_STOP      ;  -    CS
        rjmp    ProcessCSSS_30          ;    SS

ProcessCSSS_10:
        cpi     CS_cnt,CS_CNT_STOP      ;    CS  
        brne    ProcessCSSS_20

        ldi     CS_cnt,CS_CNT_START     ;  

ProcessCSSS_20:
        ldi     xl,KEY_CS               ;    CS      
        ldi     temp,PRESS              ;        ,    
        st      x,temp

ProcessCSSS_30:
        sbrc    flags,BIT_SS
        rjmp    ProcessCSSS_40          ; ,   SS 

        ldi     SS_cnt,SS_CNT_STOP      ;  -    SS
        rjmp    ProcessCSSS_End

ProcessCSSS_40:
        cpi     SS_cnt,SS_CNT_STOP      ;    SS  
        brne    ProcessCSSS_50

        ldi     SS_cnt,SS_CNT_START     ;  

ProcessCSSS_50:
        ldi     xl,KEY_SS               ;    SS      
        ldi     temp,PRESS              ;        ,    
        st      x,temp

ProcessCSSS_End:
       ret

;***********************************************************************************************************************
