;***********************************************************************************************************************
;*   SEGA.asm   "SUPER JOYSTICK PORT 2"
;* (C) 2015  
;*
;* 150225-02
;***********************************************************************************************************************

;***********************************************************************************************************************
;* 150225-02                               -    
;***********************************************************************************************************************
ClearOutBuf:
        ldi     xl,0                    ;     
        ldi     cnt,OUT_BUF_SIZE        ;    -   
        ldi     temp,RELEASE

ClearOutBuf_10:
        st      x+,temp                 ;     1,      
        dec     cnt                     ;         1 -  
        brne    ClearOutBuf_10

        cbr     csss_flags,CS           ;      CS  SS
        cbr     csss_flags,SS

        ret

;***********************************************************************************************************************
;* 150223-01                               SEGA 
;***********************************************************************************************************************
WorkSegaData:
        ldi     yl,low(SEGA1_table)     ;   1 SEGA 
                                        ;      

        sbrs    sega1_byte1,BUTTON_START
        rjmp    WorkSega1_START         ;  START  -   

        sbrs    sega1_byte1,BUTTON_SELECT
        rjmp    WorkSega1_SELECT        ;  SELECT -   SEGA 

        sbrs    sega1_byte1,BUTTON_LEFT ;   START  SELECT -    
        rcall   WorkSega1_LEFT

        sbrs    sega1_byte1,BUTTON_RIGHT
        rcall   WorkSega1_RIGHT

        sbrs    sega1_byte1,BUTTON_DOWN
        rcall   WorkSega1_DOWN

        sbrs    sega1_byte1,BUTTON_UP
        rcall   WorkSega1_UP

        sbrs    sega1_byte2,BUTTON_X
        rcall   WorkSega1_X

        sbrs    sega1_byte2,BUTTON_Y
        rcall   WorkSega1_Y

        sbrs    sega1_byte2,BUTTON_Z
        rcall   WorkSega1_Z

        sbrs    sega1_byte2,BUTTON_A
        rcall   WorkSega1_A

        sbrs    sega1_byte2,BUTTON_B
        rcall   WorkSega1_B

        sbrs    sega1_byte2,BUTTON_C
        rcall   WorkSega1_C

        ret
;-----------------------------------------------------------------------------------------------------------------------
WorkSega1_UP:
        ldd     temp,y+0                ;       UP   
        rjmp    ProcessKey
;-----------------------------------------------------------------------------------------------------------------------
WorkSega1_LEFT:
        ldd     temp,y+1
        rjmp    ProcessKey
;-----------------------------------------------------------------------------------------------------------------------
WorkSega1_RIGHT:
        ldd     temp,y+2
        rjmp    ProcessKey
;-----------------------------------------------------------------------------------------------------------------------
WorkSega1_DOWN:
        ldd     temp,y+3
        rjmp    ProcessKey
;-----------------------------------------------------------------------------------------------------------------------
WorkSega1_X:
        ldd     temp,y+4
        rjmp    ProcessKey
;-----------------------------------------------------------------------------------------------------------------------
WorkSega1_Y:
        ldd     temp,y+5
        rjmp    ProcessKey
;-----------------------------------------------------------------------------------------------------------------------
WorkSega1_Z:
        ldd     temp,y+6
        rjmp    ProcessKey
;-----------------------------------------------------------------------------------------------------------------------
WorkSega1_A:
        ldd     temp,y+7
        rjmp    ProcessKey
;-----------------------------------------------------------------------------------------------------------------------
WorkSega1_B:
        ldd     temp,y+8
        rjmp    ProcessKey
;-----------------------------------------------------------------------------------------------------------------------
WorkSega1_C:
        ldd     temp,y+9
        rjmp    ProcessKey
;-----------------------------------------------------------------------------------------------------------------------
WorkSega1_SELECT:

        mov     zl,SEGA1_zl             ;  .    FLASH

        sbrs    sega1_byte1,BUTTON_LEFT ;   START  SELECT -    
        ldi     zl,low(ROW2*2)          ;   ROW2  FLASH

        sbrs    sega1_byte1,BUTTON_RIGHT
        ldi     zl,low(ROW3*2)

        sbrs    sega1_byte1,BUTTON_DOWN
        ldi     zl,low(ROW4*2)

        sbrs    sega1_byte1,BUTTON_UP
        ldi     zl,low(ROW1*2)

        sbrs    sega1_byte2,BUTTON_X
        ldi     zl,low(CURSOR*2)

        sbrs    sega1_byte2,BUTTON_Y
        ldi     zl,low(QAOPM*2)

        sbrs    sega1_byte2,BUTTON_Z
        ldi     zl,low(ELITE*2)

        sbrs    sega1_byte2,BUTTON_A
        ldi     zl,low(SINCLAIR1*2)

        sbrs    sega1_byte2,BUTTON_B
        ldi     zl,low(SINCLAIR2*2)

        sbrs    sega1_byte2,BUTTON_C
        ldi     zl,low(KEMPSTON*2)

        cp      zl,SEGA1_zl             ;   SEGA    -   
        breq    WorkSega1_SELECT_End

        mov     SEGA1_zl,zl             ;  .    FLASH
        ldi     zh,high(SINCLAIR1*2)    ;    FLASH -    

        ldi     yl,low(SEGA1_table)     ;   1   SRAM
        ldi     yh,high(SEGA1_table)
        ldi     cnt,SEGA_TABL_SIZE      ;  

WorkSega1_SELECT_10:
        lpm     temp,z+                 ;     
        st      y+,temp
        dec     cnt
        brne    WorkSega1_SELECT_10

WorkSega1_SELECT_End:
        ret

;-----------------------------------------------------------------------------------------------------------------------
WorkSega1_START:
        ldi     temp,KEY_B
        mov     xl,temp
        ldi     temp,PRESS
        st      x,temp
        ret

;-----------------------------------------------------------------------------------------------------------------------

;***********************************************************************************************************************
