;***********************************************************************************************************************
;*   EQU.asm   "SUPER JOYSTICK PORT 2"
;* (C) 2015  
;* 150225-03
;***********************************************************************************************************************

.equ    SEGA_CNT_MIN   = 0              ;   
.equ    SEGA_CNT_MAX   = 48             ;   SEGA   48 * 50  = 2,4 

.equ    PS2_TIMEOUT_CNT_MIN  = 0        ;   
.equ    PS2_TIMEOUT_CNT_MAX  = 30       ;    PS/2   30 * 50  = 1,5 
.equ    PS2_TIMEOUT_CNT_STOP = 255      ;   

.equ    BIT_PREFIX_EO        = 7
.equ    BIT_RELEASE          = 4


.equ    CS_CNT_MIN     = 0              ;    CS
.equ    CS_CNT_MAX     = 30             ;     CS  30 * 2,4  = 72 
.equ    CS_CNT_STOP    = 255            ; CS   ,  

.equ    SS_CNT_MIN     = 0              ;    SS
.equ    SS_CNT_MAX     = 30             ;     SS  30 * 2,4  = 72 
.equ    SS_CNT_STOP    = 255            ; SS   ,  

.equ    BIT_CS         = 7
.equ    BIT_SS         = 6
.equ    CS             = 0b10000000     ;  D7=1     CAPS SHIFT + 
.equ    SS             = 0b01000000     ;  D6=1   SYMBOL SHIFT + 

.equ    PRESS          = 0              ;  
.equ    RELEASE        = 1              ;  
.equ    SEGA_TABL_SIZE = 10             ;     SEGA 
.equ    OUT_BUF_SIZE   = 48             ;        
.equ    NULL           = 48             ;      ,     
;***********************************************************************************************************************
;* 150214-01                                   
;***********************************************************************************************************************
.equ    PROCESS        = 0
.equ    READY          = 1
.equ    ERROR          = 2

;;***********************************************************************************************************************
;* 150216-01                                   SEGA 
;************************************************************************************************************************
                                        ; sega1_byte1, sega2_byte1 -      SEGA :
.equ    BUTTON_LEFT    = 5
.equ    BUTTON_RIGHT   = 4
.equ    BUTTON_DOWN    = 3
.equ    BUTTON_UP      = 2
.equ    BUTTON_SELECT  = 1
.equ    BUTTON_START   = 0
                                        ; sega1_byte2, sega2_byte2 -      SEGA :
.equ    BUTTON_X       = 5
.equ    BUTTON_Y       = 4
.equ    BUTTON_Z       = 3
.equ    BUTTON_A       = 2
.equ    BUTTON_B       = 1
.equ    BUTTON_C       = 0


;***********************************************************************************************************************
;* 150223-01                              ,  KEMPSTON     Z80
;*                                             
;***********************************************************************************************************************

;--------------------------------------  DD10 -------------------------------------------------------------------

.equ    KEMP_D         = 0
.equ    KEMP_R         = 1
.equ    KEMP_F         = 2
.equ    KEMP_U         = 3
.equ    KEMP_L         = 4
.equ    Z80_WAIT       = 5
.equ    Z80_NMI        = 6
.equ    Z80_RESET      = 7

;--------------------------------------  DD9 --------------------------------------------------------------------

.equ    KEY_H          = 8
.equ    KEY_J          = 9
.equ    KEY_K          = 10
.equ    KEY_L          = 11
.equ    KEY_EN         = 12             ; ENTER
;                      = 48             ; free pin
;                      = 48             ; free pin
;                      = 48             ; free pin

;--------------------------------------  DD8 --------------------------------------------------------------------

;                      = 48             ; free pin
;                      = 48             ; free pin
.equ    KEY_SP         = 13             ; SPACE
.equ    KEY_SS         = 14             ; SYMBOL SHIFT
.equ    KEY_M          = 15
.equ    KEY_N          = 16
.equ    KEY_B          = 17
;                      = 48             ; free pin

;--------------------------------------  DD7 --------------------------------------------------------------------

.equ    KEY_G          = 18
.equ    KEY_F          = 19
.equ    KEY_D          = 20
.equ    KEY_S          = 21
.equ    KEY_A          = 22
;                      = 48             ; free pin
;                      = 48             ; free pin
;                      = 48             ; free pin

;--------------------------------------  DD6 --------------------------------------------------------------------

;                      = 48             ; free pin
;                      = 48             ; free pin
.equ    KEY_P          = 23
.equ    KEY_O          = 24
.equ    KEY_I          = 25
.equ    KEY_U          = 26
.equ    KEY_Y          = 27
;                      = 48             ; free pin

;--------------------------------------  DD5 --------------------------------------------------------------------

.equ    KEY_5          = 28
.equ    KEY_4          = 29
.equ    KEY_3          = 30
.equ    KEY_2          = 31
.equ    KEY_1          = 32
;                      = 48             ; free pin
;                      = 48             ; free pin
;                      = 48             ; free pin

;--------------------------------------  DD4 --------------------------------------------------------------------

;                      = 48             ; free pin
;                      = 48             ; free pin
.equ    KEY_Q          = 33
.equ    KEY_W          = 34
.equ    KEY_E          = 35
.equ    KEY_R          = 36
.equ    KEY_T          = 37
;                      = 48             ; free pin

;--------------------------------------  DD3 --------------------------------------------------------------------

.equ    KEY_6          = 38
.equ    KEY_7          = 39
.equ    KEY_8          = 40
.equ    KEY_9          = 41
.equ    KEY_0          = 42
;                      = 48             ; free pin
;                      = 48             ; free pin
;                      = 48             ; free pin

;--------------------------------------  DD2 --------------------------------------------------------------------

;                      = 48             ; free pin
;                      = 48             ; free pin
.equ    KEY_CS         = 43             ; CAPS SHIFT
.equ    KEY_Z          = 44
.equ    KEY_X          = 45
.equ    KEY_C          = 46
.equ    KEY_V          = 47
;                      = 48             ; free pin

;-----------------------------------------------------------------------------------------------------------------------

