
#pragma once

#include <Windows.h>
#include "progressReport.h"

const int MAX_INPUT_SIZE = 65535;

enum COMPRESS_RESULT
{
	OK,
	IMPOSSIBLE_TOO_SHORT,
	IMPOSSIBLE_TOO_BAD     // packed size is above 0xFFFF, can't form header
};

// sizeof(Backref) = 8
struct Backref
{
	int Dist;
	short Count;
	bool IsBCB;   // is backref-copy-backref reference?
	byte dd;      // 1..8 (1 is senseless though)

	Backref() {};

	Backref(bool isBCB, int count, int dist, int dd) : IsBCB(isBCB), Dist(dist), Count(short(count)), dd(byte(dd)) {};

	int GetEncodedLen();
};

class OptimalCompressor
{
private:

	int inputSize;
	int inputOffset;
	byte input[MAX_INPUT_SIZE * 2];

	int cost[MAX_INPUT_SIZE + 1][8];
	Backref solution[MAX_INPUT_SIZE + 1][8];

	int matchLen[MAX_INPUT_SIZE];
	void fill_matchLen(int pos);

public:

	ProgressReport* ProgressReport;

	OptimalCompressor() {};
	void Init(byte* input, int inputSize);
	int Preprocess(); // returns compressed size in bits
	Backref GetOptimalOp(int pos, int dd);
};

class Compressor
{
private:

	OptimalCompressor optimalCompressor;

	byte* outputPtr;
	void emitByte(int byte);

	WORD* controlWordPtr;
	//int controlWord;
	int controlBitsCnt;
	void emitControlBit(int bit);
	void finalizeControlBits();

	void emitLargeCnt(int cnt);
	void emitLongDist(int dist, int dd);

public:

	int InputSize;
	byte Input[MAX_INPUT_SIZE + 1];

	#define maxOutputSize (int(MAX_INPUT_SIZE * 1.05 + 100))
	byte Output[maxOutputSize];
	int OutputSize;
	COMPRESS_RESULT Result;

	Compressor();
	void Compressor::TryCompress();

	ProgressReport ProgressReport;

private:

	int compressedSizePrecalc;		// approx. (may be 1 byte less) compressed size in bytes. Set by Compress_Preprocess().
	void Compress_Preprocess();
	void Compress_Emit();

};

