/* REXX */
/* HiTech2zx48scl.rex */
/*
Short:			Rexx macro for automatic compilation C-source to ZX-BASIC-monolader in SCL under HiTech C v3.09.
Author:		Amixgris / Red Triangle
Uploader:		Amixgris / Red Triangle
Type:			rexx script
Version		1.2  (added --reserve-regs-iy option)
Architecture: 	x86/win
Date:		  	27-07-2014
Usage: 		optimHiTech2zx48scl.rex source_name.c [, *.lib... [*.obj...]]
*/

/*Compiling options BEGIN:*/
CODE_ORG = "23897"	  /* for BASIC string value */
STACK	  = "65535"	  /* BASIC stack value */
/*Compiling options END*/

OPTIONS AREXX_SEMANTICS
OPTIONS AREXX_BIFS

/* SCL data BEGIN:*/
T0 = '53 49 4e 43 4c 41 49 52 01 62 6f 6f 74 20 20 20 20 42 00 00 00 00 00'x
T1 = '00 01'x
/* LENGTH OF BASIC STRING HERE, 2 bytes */
T2 = 'fd b0 22'x
/* STACK HERE, 5 chars */
T3 = '22 3a f9 c0 b0 22'x
/* CODE START addres here, 5 chars (23897) */
T4 = '22 3a f1 42 24 3d 22'x
/* TARGET CODE HERE */
T5 = '22 0d'x
/*  SCL data END: */
T0L = LENGTH(T0) ; T1L = LENGTH(T1) ; T2L = LENGTH(T2) ; T3L = LENGTH(T3) ; T4L = LENGTH(T4) ; T5L = LENGTH(T5)

SAY ""
SAY "optimHiTech2zx48scl.rex v.1.1, (R) Amixgris / Red Triangle"
SAY "----------------------------------------------------------"

PARSE ARG infpathname ',' libs

inf_drive = FILESPEC('D',infpathname)
inf_path  = FILESPEC('P',infpathname)
inf_name  = FILESPEC('N',infpathname)


PARSE VAR inf_name in_name "." in_ext

asmpathname = inf_drive||inf_path||in_name||".asm"
objpathname = inf_drive||inf_path||in_name||".OBJ"
cpmfpathname = inf_drive||inf_path||in_name||".COM"
binfpathname = inf_drive||inf_path||in_name||".bin"

l = "call cpm CPP.COM -DHI_TECH_C -Dz80 -I "||infpathname||" $CTMP1.$$$"
n = CHARS(infpathname)
if ( n > 0)	THEN 	DO
/*						say "Preprocessing:"
						say l 
						say "=============================================="
						say "" */
						INTERPRET "l"
					
						END
				ELSE 	DO
						SAY "Input C source file cannot be opened"
						EXIT
						END

l = "call cpm P1 $CTMP1.$$$ $CTMP2.$$$ $CTMP3.$$$"
n = CHARS("$CTMP1.$$$")
if ( n > 0)	THEN 	DO
/*						say "PseudoCode generation:"
						say l
						say "=============================================="
						say "" */
						INTERPRET "l"
					
						END
				ELSE 	DO
						SAY "FAILED"
						EXIT
						END

l = "call cpm CGEN $CTMP2.$$$ $CTMP1.$$$"
n = CHARS("$CTMP2.$$$")
if ( n > 0)	THEN 	DO
/*						say "Code generation:"
 						say l
						say "=============================================="
						say "" */
						INTERPRET "l"
						l = "call copy $CTMP1.$$$ "||inf_drive||inf_path||in_name||".asm >nil"
						INTERPRET "l"
						END
				ELSE 	DO
						SAY "FAILED"
						EXIT
						END
						
l = "call cpm OPTIM $CTMP1.$$$ $CTMP3.$$$"
n = CHARS("$CTMP1.$$$")
if ( n > 0)	THEN 	DO
/*						say "Code optimization:"
 						say l
						say "=============================================="
						say "" */
						INTERPRET "l"
						END
				ELSE 	DO
						SAY "FAILED"
						EXIT
						END
						
						

l = "call cpm ZAS -N -o"||in_name||".OBJ $CTMP3.$$$"
n = CHARS("$CTMP3.$$$")
if ( n > 0)	THEN 	DO
/*						say "Assembling:"
 						say l
						say "=============================================="
						say "" */
						INTERPRET "l"
						l = "call copy $CTMP3.$$$ "||inf_drive||inf_path||in_name||"_opt.asm >nil"
						INTERPRET "l"
						END
				ELSE 	DO
						SAY "FAILED"
						EXIT
						END
l = "call del $CTMP1.$$$ $CTMP2.$$$ $CTMP3.$$$ >nil"
INTERPRET "l"

l = "call cpm link.com -Z -Ptext=5D59H -C5D59H -O"||binfpathname||" "||objpathname||libs||" libc.lib"
n = CHARS(objpathname)
if ( n > 0)	THEN 	DO
/*						say "LINKING:"
 						say l
						say "=============================================="
						say ""	 */					
						INTERPRET "l"
						END
				ELSE 	DO
						SAY "Input OBJECT source file cannot be opened"
						EXIT
						END

l = "call del $$EXEC.$$$ "||objpathname||" >nil"
INTERPRET "l"						
						
n = CHARS(binfpathname)
if ( n > 0)	THEN 	DO
						n = OPEN("out0",  binfpathname, "READ")
						END
				ELSE 	DO
						SAY "Input BINARY source file cannot be opened"
						EXIT
						END						
						
	/*THEN DO
												CALL CLOSE('out0')
												SAY "Can`t open" binfpathname
												SAY "OPERATION ABORTED!"
												END */

say "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx"
say "BINNAME: "binfpathname

/* NEEDLE LENGTHS CALCULATING*/
code_len = CHARS(binfpathname)
bline_len = code_len + 28
bas_len  = T1L+2+T2L+5+T3L+5+T4L+code_len+T5L
bas_slen = (bas_len+255)%256	/* BASIC len in sectors*/
add_len = 256 - bas_len//256	/* align value to sector boundary*/
scl_len = T0L+bas_len+add_len
free_len = STACK - 23867 - bas_len

say "Code length      = "RIGHT(code_len,5,' ') "/ 0x"RIGHT(D2X(code_len),4,'0')
say "BASIC line len   = "RIGHT(bline_len,5,' ') "/ 0x"RIGHT(D2X(bline_len),4,'0')
say "BASIC length     = "RIGHT(bas_len,5,' ') "/ 0x"RIGHT(D2X(bas_len),4,'0')
say "Space to stack   = "RIGHT(free_len,5,' ') "/ 0x"RIGHT(D2X(free_len),4,'0')
say "BASIC sectors    = "RIGHT(bas_slen,5,' ') "/ 0x"RIGHT(D2X(bas_slen),4,'0')
say "Align to sector  = "RIGHT(add_len,5,' ') "/ 0x"RIGHT(D2X(add_len),4,'0')
say "SCL size w/o CRC = "RIGHT(scl_len,5,' ') "/ 0x"RIGHT(D2X(scl_len),4,'0')


/* CREATING SCL FILE*/
sclpathname = inf_drive||inf_path||in_name||".scl"
n = OPEN("out2", sclpathname, "WRITE")	/*THEN DO ; CALL CLOSE("out2")
											SAY "Can`t open" sclpathname
											SAY "OPERATION ABORTED!"
											END */

s = T0||T1||d2c(bline_len//256)||d2c(bline_len%256)||T2||RIGHT(STACK, 5)||,
	T3||RIGHT(CODE_ORG, 5)||T4||CHARIN(binfpathname, 1, code_len)||T5||LEFT('00'x,add_len,'00'x)
a = CHAROUT(sclpathname, s,)

b = d2c(bas_len//256)
c = d2c(bas_len%256)
a = CHAROUT(sclpathname, b||c||b||c||D2C(bas_slen), 19)


count = scl_len+1
crc = 0
DO	i=1 WHILE i <> count
	a = CHARIN(sclpathname,i , 1)
	crc = crc + C2D(a)
END	

say "SCL CRC          =    0x"RIGHT(D2X(crc),8,'0')

x3 = d2c(crc%16777216)	; 	crc = crc//16777216
x2 = d2c(crc%65536) 	;	crc = crc//65536
x1 = d2c(crc%256)
x0 = d2c(crc//256)
a = charout(sclpathname, x0||x1||x2||x3, count)

a = CALL CLOSE("out2")	

EXIT
