;***********************************************************************************************************************
;*   PROCESS_KEY.asm   "SUPER JOYSTICK PORT 2"
;* (C) 2015  
;*
;* 150408-01
;***********************************************************************************************************************
;***********************************************************************************************************************
;* 150407-02                                  SEGA 
;*
;*                                      :  temp =    PS/2   SEGA 
;*                                             xh   =     
;*                                      :        
;***********************************************************************************************************************
ProcessKey:
        sbrc    temp,BIT_CS
        rjmp    ProcessKey_CS           ; ,      CS

        sbrc    temp,BIT_SS
        rjmp    ProcessKey_SS           ; ,      SS

        mov     xl,temp                 ;        
        ldi     temp,PRESS              ;        ,    
        st      x,temp
        ret

ProcessKey_CS:
        sbrc    temp,BIT_SS
        rjmp    ProcessKey_EXT          ;     ,  : CS  SS

        sbr     csss_flags,CS           ;     CS
        cpi     CS_cnt,CS_CNT_MAX       ;     CS   ,
        brne    ProcessKey_End          ;  c CS  

        cbr     temp,CS                 ;   -  ,     CS
        rjmp    ProcessKey_100

ProcessKey_SS:
        sbr     csss_flags,SS           ;     SS
        cpi     SS_cnt,SS_CNT_MAX       ;     SS   ,
        brne    ProcessKey_End          ;  c SS  

        cbr     temp,SS                 ;   -  ,     SS
        rjmp    ProcessKey_100

ProcessKey_EXT:
        cbr     temp,EXT                ;   D7, D6
        rcall   KeyMacros               ;   
        rjmp    ProcessKey_End          ;  EXT  

ProcessKey_100:
        mov     xl,temp                 ;        
        ldi     temp,PRESS              ;        ,    
        st      x,temp

ProcessKey_End:
        ret

;***********************************************************************************************************************
;* 150408-01                              
;***********************************************************************************************************************
KeyMacros:                              ;  12: LOAD""ENTER   OpenSE BASIC
        rcall   ClearOutBuf

        ldi     temp,Z80_RESET
        rcall   StepKeyMacro

        ldi     temp,NULL
        rcall   StepKeyMacro

        rcall   Delay1S

        ldi     temp,CS+KEY_L
        rcall   StepKeyMacro
        ldi     temp,CS+KEY_L
        rcall   StepKeyMacro

        ldi     temp,CS+KEY_O
        rcall   StepKeyMacro

        ldi     temp,CS+KEY_A
        rcall   StepKeyMacro

        ldi     temp,CS+KEY_D
        rcall   StepKeyMacro

        ldi     temp,SS+KEY_P
        rcall   StepKeyMacro
        ldi     temp,SS+KEY_P
        rcall   StepKeyMacro

        ldi     temp,NULL
        rcall   StepKeyMacro

        ldi     temp,SS+KEY_P
        rcall   StepKeyMacro
        ldi     temp,SS+KEY_P
        rcall   StepKeyMacro

        ldi     temp,KEY_EN
        rcall   StepKeyMacro

        ret
;***********************************************************************************************************************
;* 150407-02                               
;***********************************************************************************************************************
StepKeyMacro:
        rcall   ProcessKey
        rcall   ProcessCSSS
        rcall   OutBufToRegs
        rcall   Delay100mS
        rcall   ClearOutBuf
        ret

;***********************************************************************************************************************
;* 150225-02                               CS  SS
;***********************************************************************************************************************
ProcessCSSS:
        sbrc    csss_flags,BIT_CS
        rjmp    ProcessCSSS_10          ; ,   CS 

        ldi     CS_cnt,CS_CNT_STOP      ;  -    CS
        rjmp    ProcessCSSS_30          ;    SS

ProcessCSSS_10:
        cpi     CS_cnt,CS_CNT_STOP      ;    CS  
        brne    ProcessCSSS_20

        ldi     CS_cnt,CS_CNT_MIN       ;  

ProcessCSSS_20:
        ldi     xl,KEY_CS               ;    CS      
        ldi     temp,PRESS              ;        ,    
        st      x,temp

ProcessCSSS_30:
        sbrc    csss_flags,BIT_SS
        rjmp    ProcessCSSS_40          ; ,   SS 

        ldi     SS_cnt,SS_CNT_STOP      ;  -    SS
        rjmp    ProcessCSSS_End

ProcessCSSS_40:
        cpi     SS_cnt,SS_CNT_STOP      ;    SS  
        brne    ProcessCSSS_50

        ldi     SS_cnt,SS_CNT_MIN       ;  

ProcessCSSS_50:
        ldi     xl,KEY_SS               ;    SS      
        ldi     temp,PRESS              ;        ,    
        st      x,temp

ProcessCSSS_End:
       ret
;***********************************************************************************************************************
;* 150408-01                                
;***********************************************************************************************************************
ProcessKeyboardBuf:
        ldi     yl,low(PS2_buf)               ;    -
        ldi     yh,high(PS2_buf)
        ldi     zh,high(PS2_KEYBOARD_TABLE*2) ;      FLASH
        ldi     cnt,KEYBOARD_BUF_SIZE

PKB_10: ld      temp,y+                 ;       
        cpi     temp,0                  ;   0 ( ) ?
        breq    PKB_20                  ;  ->  

        mov     zl,temp                 ;      
        lpm     temp,z                  ;     

        push    cnt
        rcall   ProcessKey              ;     
        pop     cnt

PKB_20: dec     cnt                     ;       -    
        brne    PKB_10

        ret
;***********************************************************************************************************************
