;***********************************************************************************************************************
;*   COMMAND.asm   "SUPER JOYSTICK PORT 2"
;* (C) 2015  
;*
;* 150419-09
;***********************************************************************************************************************

;***********************************************************************************************************************
;* 150419-03                            F10 - : RESET,     TR-DOS, RUN, ENTER
;***********************************************************************************************************************
Command_10:

 PRESS   Z80_RESET                      ;   RESET
 PRESS   NULL                           ;      RESET
 rcall   Delay1S                        ;  2         
 rcall   Delay1S

 PRESS   CS+KEY_7                       ;  
 PRESS   NULL                           ;   
 PRESS   KEY_EN                         ; ENTER
 PRESS   NULL                           ;   
 PRESS   KEY_R                          ; RUN
 PRESS   NULL                           ;   
 PRESS   KEY_EN                         ; ENTER

 ret

;***********************************************************************************************************************
;* 150419-03                            F11 - : RESET, LOAD "" ENTER   BASIC 1982 .
;***********************************************************************************************************************
Command_11:

 PRESS   Z80_RESET                      ;   RESET
 PRESS   NULL                           ;      RESET
 rcall   Delay1S                        ;  2         
 rcall   Delay1S

 PRESS   KEY_J                          ; LOAD

 PRESS   SS+KEY_P                       ; "
 PRESS   NULL                           ;   
 PRESS   SS+KEY_P                       ; "
 PRESS   NULL                           ;   
 PRESS   KEY_EN                         ; ENTER

 ret

;***********************************************************************************************************************
;* 150411-01                            F12 - : RESET, LOAD "" ENTER   OpenSE BASIC
;***********************************************************************************************************************
Command_12:

 PRESS   Z80_RESET                      ;   RESET
 PRESS   NULL                           ;      RESET
 rcall   Delay1S                        ;  1         

 PRESS   CS+KEY_L                       ; L
 PRESS   CS+KEY_O                       ; O
 PRESS   CS+KEY_A                       ; A
 PRESS   CS+KEY_D                       ; D

 PRESS   SS+KEY_P                       ; "
 PRESS   NULL                           ;   
 PRESS   SS+KEY_P                       ; "

 PRESS   KEY_EN                         ; ENTER

 ret


;***********************************************************************************************************************
;* 150419-02                            CLR BUF,    (COM+17))
;***********************************************************************************************************************
Command_17:

 ldi     temp,0

 mov     KEY_CODE1,temp                 ;     
 mov     KEY_CODE2,temp
 mov     KEY_CODE3,temp
 mov     KEY_CODE4,temp

 ret

;***********************************************************************************************************************
;* 150419-02                              ~ (COM+20: CS+KEY_SS, SS+KEY_A)
;***********************************************************************************************************************
Command_20:

 PRESS   CS+KEY_SS
 PRESS   SS+KEY_A

 ret

;***********************************************************************************************************************
;* 150419-02                              \ (COM+21: CS+KEY_SS, SS+KEY_D)
;***********************************************************************************************************************
Command_21:

 PRESS   CS+KEY_SS
 PRESS   SS+KEY_D

 ret

;***********************************************************************************************************************
;* 150419-02                              | (COM+22: CS+KEY_SS, SS+KEY_S)
;***********************************************************************************************************************
Command_22:

 PRESS   CS+KEY_SS
 PRESS   SS+KEY_S

 ret

;***********************************************************************************************************************
;* 150419-02                              [ (COM+23: CS+KEY_SS, SS+KEY_Y)
;***********************************************************************************************************************
Command_23:

 PRESS   CS+KEY_SS
 PRESS   SS+KEY_Y

 ret

;***********************************************************************************************************************
;* 150419-02                              { (COM+24: CS+KEY_SS, SS+KEY_F)
;***********************************************************************************************************************
Command_24:

 PRESS   CS+KEY_SS
 PRESS   SS+KEY_F

 ret

;***********************************************************************************************************************
;* 150419-02                              ] (COM+25: CS+KEY_SS, SS+KEY_U)
;***********************************************************************************************************************
Command_25:

 PRESS   CS+KEY_SS
 PRESS   SS+KEY_U

 ret

;***********************************************************************************************************************
;* 150419-02                              } (COM+26: CS+KEY_SS, SS+KEY_G)
;***********************************************************************************************************************
Command_26:

 PRESS   CS+KEY_SS
 PRESS   SS+KEY_G

 ret

;***********************************************************************************************************************
;* 150419-02                                 (COM+27: CS+KEY_8, CS+KEY_0)
;***********************************************************************************************************************
Command_27:

 PRESS   CS+KEY_8
 PRESS   CS+KEY_0

 ret


;***************************************    **************************************************

Command_00:
Command_01:
Command_02:
Command_03:
Command_04:
Command_05:
Command_06:
Command_07:
Command_08:
Command_09:
Command_13:
Command_14:
Command_15:
Command_16:
Command_18:
Command_19:
Command_28:
Command_29:
Command_30:

 ret

;***********************************************************************************************************************
;* 150411-01                                  
;***********************************************************************************************************************
CommandSelector:
 cpi     temp,0
 breq    Com_00
 cpi     temp,1
 breq    Com_01
 cpi     temp,2
 breq    Com_02
 cpi     temp,3
 breq    Com_03
 cpi     temp,4
 breq    Com_04
 cpi     temp,5
 breq    Com_05
 cpi     temp,6
 breq    Com_06
 cpi     temp,7
 breq    Com_07
 cpi     temp,8
 breq    Com_08
 cpi     temp,9
 breq    Com_09
 cpi     temp,10
 breq    Com_10
 cpi     temp,11
 breq    Com_11
 cpi     temp,12
 breq    Com_12
 cpi     temp,13
 breq    Com_13
 cpi     temp,14
 breq    Com_14
 cpi     temp,15
 breq    Com_15
 cpi     temp,16
 breq    Com_16
 cpi     temp,17
 breq    Com_17
 cpi     temp,18
 breq    Com_18
 cpi     temp,19
 breq    Com_19
 cpi     temp,20
 breq    Com_20
 cpi     temp,21
 breq    Com_21
 cpi     temp,22
 breq    Com_22
 cpi     temp,23
 breq    Com_23
 cpi     temp,24
 breq    Com_24
 cpi     temp,25
 breq    Com_25
 cpi     temp,26
 breq    Com_26
 cpi     temp,27
 breq    Com_27
 cpi     temp,28
 breq    Com_28
 cpi     temp,29
 breq    Com_29
 cpi     temp,30
 breq    Com_30

 ret

;***********************************************************************************************************************

Com_00: rjmp Command_00
Com_01: rjmp Command_01
Com_02: rjmp Command_02
Com_03: rjmp Command_03
Com_04: rjmp Command_04
Com_05: rjmp Command_05
Com_06: rjmp Command_06
Com_07: rjmp Command_07
Com_08: rjmp Command_08
Com_09: rjmp Command_09
Com_10: rjmp Command_10
Com_11: rjmp Command_11
Com_12: rjmp Command_12
Com_13: rjmp Command_13
Com_14: rjmp Command_14
Com_15: rjmp Command_15
Com_16: rjmp Command_16
Com_17: rjmp Command_17
Com_18: rjmp Command_18
Com_19: rjmp Command_19
Com_20: rjmp Command_20
Com_21: rjmp Command_21
Com_22: rjmp Command_22
Com_23: rjmp Command_23
Com_24: rjmp Command_24
Com_25: rjmp Command_25
Com_26: rjmp Command_26
Com_27: rjmp Command_27
Com_28: rjmp Command_28
Com_29: rjmp Command_29
Com_30: rjmp Command_30

;***********************************************************************************************************************
