;***********************************************************************************************************************
;*   FLASH_DATA.asm   "SUPER JOYSTICK PORT 2"
;* (C) 2015  
;*
;* 150419-01
;***********************************************************************************************************************

;***********************************************************************************************************************
;* 150419-01                             PS/2 
;***********************************************************************************************************************
;                                           
;***********************************************************************************************************************
PS2_KEYBOARD_TABLE:                     ;  , 128 -   E0
;-----------------------------------------------------------------------------------------------------------------------
; -:         00        01        02        03        04        05        06        07
;  :       --        F9        F7 ?      F5        F3        F1        F2        F12
              .DB   NULL,     COM+9,    COM+7,    COM+5,    COM+3,    COM+1,    COM+2,    COM+12
; :                  OUT2=0    KP CUR.   WASD CUR. KEMP. J.  SINC1 J.  SINC2 J.  LOAD for OpenSE BASIC
;-----------------------------------------------------------------------------------------------------------------------
; -:         08        09        0A        0B        0C        0D        0E        0F
;  :       --        F10       F8        F6        F4        TAB        ~       --
              .DB   NULL,     COM+10,   COM+8,    COM+6,    COM+4,    CS+KEY_SS,SS+KEY_X, NULL
; :                  TR-DOS    OUT1=0    MAIN CUR. QAOPM J.  EXT.MODE  
;-----------------------------------------------------------------------------------------------------------------------
; -:         10        11        12        13        14        15        16        17
;  :       --        L ALT     L SHIFT   --        L CTRL    Q         1 !       --
              .DB   NULL,     NULL,     NULL,     NULL,     KEY_CS,   KEY_Q,    KEY_1,    NULL
; :                                                CapsShift q         1
;-----------------------------------------------------------------------------------------------------------------------
; -:         18        19        1A        1B        1C        1D        1E        1F
;  :       --        --        Z         S         A         W         2 @       --
              .DB   NULL,     NULL,     KEY_Z,    KEY_S,    KEY_A,    KEY_W,    KEY_2,    NULL
; :                            z         s         a         w         2
;-----------------------------------------------------------------------------------------------------------------------
; -:         20        21        22        23        24        25        26        27
;  :       --        C         X         D         E         4 $       3 #        --
              .DB   NULL,     KEY_C,    KEY_X,    KEY_D,    KEY_E,    KEY_4,    KEY_3,    NULL
; :                  c         x         d         e         4         3
;-----------------------------------------------------------------------------------------------------------------------
; -:         28        29        2A        2B        2C        2D        2E        2F
;  :       --        SPACE     V         F         T         R         5 %       --
              .DB   NULL,     KEY_SP,   KEY_V,    KEY_F,    KEY_T,    KEY_R,    KEY_5,    NULL
; :                      v         f         t         r         5
;-----------------------------------------------------------------------------------------------------------------------
; -:         30        31        32        33        34        35        36        37
;  :       --        N         B         H         G         Y         6 ^       --
              .DB   NULL,     KEY_N,    KEY_B,    KEY_H,    KEY_G,    KEY_Y,    KEY_6,    NULL
; :                  n         b         h         g         y         6
;-----------------------------------------------------------------------------------------------------------------------
; -:         38        39        3A        3B        3C        3D        3E        3F
;  :       --        --        M         J         U         7 &       8 *       --
              .DB   NULL,     NULL,     KEY_M,    KEY_J,    KEY_U,    KEY_7,    KEY_8,    NULL
; :                            m         j         u         7         8
;-----------------------------------------------------------------------------------------------------------------------
; -:         40        41        42        43        44        45        46        47
;  :       --        , <       K         I         O         0 )       9 (        --
              .DB   NULL,     SS+KEY_N, KEY_K,    KEY_I,    KEY_O,    KEY_0,    KEY_9,    NULL
; :                  ,         k         i         o         0         9
;-----------------------------------------------------------------------------------------------------------------------
; -:         48        49        4A        4B        4C        4D        4E        4F
;  :       --        . >       / ?       L         ; :       P         - _       --
              .DB   NULL,     SS+KEY_M, SS+KEY_V, KEY_L,    SS+KEY_O, KEY_P,    SS+KEY_J, NULL
; :                  .         /         l         ;         p         -
;-----------------------------------------------------------------------------------------------------------------------
; -:         50        51        52        53        54        55        56        57
;  :       --        --        ' "       --        [ {       = +       --        --
              .DB   NULL,     NULL,     SS+KEY_7, NULL,     COM+23,   SS+KEY_L, NULL,     NULL
; :                            '                   [         =
;-----------------------------------------------------------------------------------------------------------------------
; -:         58        59        5A        5B        5C        5D        5E        5F
;  :       CAPS LOCK R SHIFT   ENTER     ] }       --        \ |       --        --
              .DB   CS+KEY_2, NULL,     KEY_EN,   COM+25,   NULL,     COM+21,   NULL,     NULL
; :        CAPS LOCK           ENTER     ]                   \
;-----------------------------------------------------------------------------------------------------------------------
; -:         60        61        62        63        64        65        66        67
;  :       --        --        --        --        --        --        BKSP      --
              .DB   NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     CS+KEY_0, NULL
; :                                                                    DELETE L.
;-----------------------------------------------------------------------------------------------------------------------
; -:         68        69        6A        6B        6C        6D        6E        6F
;  :       --        KP 1      --        KP 4      KP 7      --        --        --
              .DB   NULL,     KEY_1,    NULL,     KEY_4,    KEY_7,    NULL,     NULL,     NULL
; :                  1                   4         7
;-----------------------------------------------------------------------------------------------------------------------
; -:         70        71        72        73        74        75        76        77
;  :       KP 0      KP .      KP 2      KP 5      KP 6      KP 8      ESC       NUM
              .DB   KEY_0,    SS+KEY_M, KEY_2,    KEY_5,    KEY_6,    KEY_8,    CS+KEY_1, NULL
; :        0         .         2         5         6         8         EDIT
;-----------------------------------------------------------------------------------------------------------------------
; -:         78        79        7A        7B        7C        7D        7E        7F
;  :       F11       KP +      KP 3      KP -      KP *      KP 9      SCROLL    --
              .DB   COM+11,   SS+KEY_K, KEY_3,    SS+KEY_J, SS+KEY_B, KEY_9,    COM+15,   NULL
; :        LOAD 1982 +         3         -         *         9         MAGIC
;-----------------------------------------------------------------------------------------------------------------------
                                        ;  , 128 -   E0 (   $80=128)
;-----------------------------------------------------------------------------------------------------------------------
; -:         00        01        02        03        04        05        06        07
;  :       --        --        --        --        --        --        --        --
              .DB   NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL
; :
;-----------------------------------------------------------------------------------------------------------------------
; -:         08        09        0A        0B        0C        0D        0E        0F
;  :       --        --        --        --        --        --        --        --
              .DB   NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL
; :
;-----------------------------------------------------------------------------------------------------------------------
; -:         10        11        12        13        14        15        16        17
;  :       --        R ALT     PRNSCR1   --        R CTRL    --        --        --
              .DB   NULL,     NULL,     Z80_RESET,NULL,     KEY_SS,   NULL,     NULL,     NULL
; :                            RESET               Symbol Shift
;-----------------------------------------------------------------------------------------------------------------------
; -:         18        19        1A        1B        1C        1D        1E        1F
;  :       --        --        --        --        --        --        --        L GUI
              .DB   NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL
; :
;-----------------------------------------------------------------------------------------------------------------------
; -:         20        21        22        23        24        25        26        27
;  :       --        --        --        --        --        --        --        R GUI
              .DB   NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL
; :
;-----------------------------------------------------------------------------------------------------------------------
; -:         28        29        2A        2B        2C        2D        2E        2F
;  :       --        --        --        --        --        --        --        APPS
              .DB   NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL
; :
;-----------------------------------------------------------------------------------------------------------------------
; -:         30        31        32        33        34        35        36        37
;  :       --        --        --        --        --        --        --        --
              .DB   NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL
; :
;-----------------------------------------------------------------------------------------------------------------------
; -:         38        39        3A        3B        3C        3D        3E        3F
;  :       --        --        --        --        --        --        --        --
              .DB   NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL
; :
;-----------------------------------------------------------------------------------------------------------------------
; -:         40        41        42        43        44        45        46        47
;  :       --        --        --        --        --        --        --        --
              .DB   NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL
; :
;-----------------------------------------------------------------------------------------------------------------------
; -:         48        49        4A        4B        4C        4D        4E        4F
;  :       --        --        KP /      --        --        --        --        --
              .DB   NULL,     NULL,     SS+KEY_V, NULL,     NULL,     NULL,     NULL,     NULL
; :                            /
;-----------------------------------------------------------------------------------------------------------------------
; -:         50        51        52        53        54        55        56        57
;  :       --        --        --        --        --        --        --        --
              .DB   NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL
; :
;-----------------------------------------------------------------------------------------------------------------------
; -:         58        59        5A        5B        5C        5D        5E        5F
;  :       --        --        KP EN     --        --        --        --        --
              .DB   NULL,     NULL,     KEY_EN,   NULL,     NULL,     NULL,     NULL,     NULL
; :                            ENTER
;-----------------------------------------------------------------------------------------------------------------------
; -:         60        61        62        63        64        65        66        67
;  :       --        --        --        --        --        --        --        --
              .DB   NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL
; :
;-----------------------------------------------------------------------------------------------------------------------
; -:         68        69        6A        6B        6C        6D        6E        6F
;  :       --        END       --        LEFT      HOME      --        --        --
              .DB   NULL,     COM+17,   NULL,     CS+KEY_5, COM+16,   NULL,     NULL,     NULL
; :                  CLR BUF             LEFT      JOY OFF
;-----------------------------------------------------------------------------------------------------------------------
; -:         70        71        72        73        74        75        76        77
;  :       INSERT    DELETE    DOWN      --        RIGHT     UP        --        --
              .DB   CS+KEY_9, COM+27,   CS+KEY_6, NULL,     CS+KEY_8, CS+KEY_7, NULL,     NULL
; :        GRAPH     DELETE R. DOWN                RIGHT     UP
;-----------------------------------------------------------------------------------------------------------------------
; -:         78        79        7A        7B        7C        7D        7E        7F
;  :       --        --        PG DN     --        PRNSCR2   PG UP     --        --
              .DB   NULL,     NULL,     CS+KEY_3, NULL,     NULL,     CS+KEY_4, NULL,     NULL
; :                            True Video                    Inv. Video
;-----------------------------------------------------------------------------------------------------------------------

;***********************************************************************************************************************
;                                           
;***********************************************************************************************************************
PS2_KEYBOARD_TABLE2:                    ;  , 128 -   E0
;-----------------------------------------------------------------------------------------------------------------------
; -:         00        01        02        03        04        05        06        07
;  :       --        F9        F7 ?      F5        F3        F1        F2        F12
              .DB   NULL,     COM+14,   NULL,     NULL,     NULL,     NULL,     NULL,     NULL
; :                  OUT2=1
;-----------------------------------------------------------------------------------------------------------------------
; -:         08        09        0A        0B        0C        0D        0E        0F
;  :       --        F10       F8        F6        F4        TAB        ~       --
              .DB   NULL,     NULL,     COM+13,   NULL,     NULL,     NULL,     COM+20,   NULL
; :                            OUT1=1                                  ~
;-----------------------------------------------------------------------------------------------------------------------
; -:         10        11        12        13        14        15        16        17
;  :       --        L ALT     L SHIFT   --        L CTRL    Q         1 !       --
              .DB   NULL,     NULL,     NULL,     NULL,     NULL,     CS+KEY_Q, SS+KEY_1, NULL
; :                                                          Q         !
;-----------------------------------------------------------------------------------------------------------------------
; -:         18        19        1A        1B        1C        1D        1E        1F
;  :       --        --        Z         S         A         W         2 @       --
              .DB   NULL,     NULL,     CS+KEY_Z, CS+KEY_S, CS+KEY_A, CS+KEY_W, SS+KEY_2, NULL
; :                            Z         S         A         W         @
;-----------------------------------------------------------------------------------------------------------------------
; -:         20        21        22        23        24        25        26        27
;  :       --        C         X         D         E         4 $       3 #       --
              .DB   NULL,     CS+KEY_C, CS+KEY_X, CS+KEY_D, CS+KEY_E, SS+KEY_4, SS+KEY_3, NULL
; :                  C         X         D         E         $         #
;-----------------------------------------------------------------------------------------------------------------------
; -:         28        29        2A        2B        2C        2D        2E        2F
;  :       --        SPACE     V         F         T         R         5 %       --
              .DB   NULL,     NULL,     CS+KEY_V, CS+KEY_F, CS+KEY_T, CS+KEY_R, SS+KEY_5, NULL
; :                            V         F         T         R         %
;-----------------------------------------------------------------------------------------------------------------------
; -:         30        31        32        33        34        35        36        37
;  :       --        N         B         H         G         Y         6 ^       --
              .DB   NULL,     CS+KEY_N, CS+KEY_B, CS+KEY_H, CS+KEY_G, CS+KEY_Y, SS+KEY_H, NULL
; :                  N         B         H         G         Y         ^
;-----------------------------------------------------------------------------------------------------------------------
; -:         38        39        3A        3B        3C        3D        3E        3F
;  :       --        --        M         J         U         7 &       8 *       --
              .DB   NULL,     NULL,     CS+KEY_M, CS+KEY_J, CS+KEY_U, SS+KEY_6, SS+KEY_B, NULL
; :                            M         J         U         &         *
;-----------------------------------------------------------------------------------------------------------------------
; -:         40        41        42        43        44        45        46        47
;  :       --        , <       K         I         O         0 )       9 (       --
              .DB   NULL,     SS+KEY_R, CS+KEY_K, CS+KEY_I, CS+KEY_O, SS+KEY_9, SS+KEY_8, NULL
; :                  <         K         I         O         )         (
;-----------------------------------------------------------------------------------------------------------------------
; -:         48        49        4A        4B        4C        4D        4E        4F
;  :       --        . >       / ?       L         ; :       P         - _       --
              .DB   NULL,     SS+KEY_T, SS+KEY_C, CS+KEY_L, SS+KEY_Z, CS+KEY_P, SS+KEY_0, NULL
; :                  >         ?         L         :         P         _
;-----------------------------------------------------------------------------------------------------------------------
; -:         50        51        52        53        54        55        56        57
;  :       --        --        ' "       --        [ {       = +       --        --
              .DB   NULL,     NULL,     SS+KEY_P, NULL,     COM+24,   SS+KEY_K, NULL,     NULL
; :                            "                   {         +
;-----------------------------------------------------------------------------------------------------------------------
; -:         58        59        5A        5B        5C        5D        5E        5F
;  :       CAPS LOCK R SHIFT   ENTER     ] }       --        \ |       --        --
              .DB   NULL,     NULL,     NULL,     COM+26,   NULL,     COM+22,   NULL,     NULL
; :                                      }                   |
;-----------------------------------------------------------------------------------------------------------------------
; -:         60        61        62        63        64        65        66        67
;  :       --        --        --        --        --        --        BKSP      --
              .DB   NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL
; :
;-----------------------------------------------------------------------------------------------------------------------
; -:         68        69        6A        6B        6C        6D        6E        6F
;  :       --        KP 1      --        KP 4      KP 7      --        --        --
              .DB   NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL
; :
;-----------------------------------------------------------------------------------------------------------------------
; -:         70        71        72        73        74        75        76        77
;  :       KP 0      KP .      KP 2      KP 5      KP 6      KP 8      ESC       NUM
              .DB   NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL
; :
;-----------------------------------------------------------------------------------------------------------------------
; -:         78        79        7A        7B        7C        7D        7E        7F
;  :       F11       KP +      KP 3      KP -      KP *      KP 9      SCROLL    --
              .DB   NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL
; :
;-----------------------------------------------------------------------------------------------------------------------
                                        ;  , 128 -   E0 (   $80=128)
;-----------------------------------------------------------------------------------------------------------------------
; -:         00        01        02        03        04        05        06        07
;  :       --        --        --        --        --        --        --        --
              .DB   NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL
; :
;-----------------------------------------------------------------------------------------------------------------------
; -:         08        09        0A        0B        0C        0D        0E        0F
;  :       --        --        --        --        --        --        --        --
              .DB   NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL
; :
;-----------------------------------------------------------------------------------------------------------------------
; -:         10        11        12        13        14        15        16        17
;  :       --        R ALT     PRNSCR1   --        R CTRL    --        --        --
              .DB   NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL
; :
;-----------------------------------------------------------------------------------------------------------------------
; -:         18        19        1A        1B        1C        1D        1E        1F
;  :       --        --        --        --        --        --        --        L GUI
              .DB   NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL
; :
;-----------------------------------------------------------------------------------------------------------------------
; -:         20        21        22        23        24        25        26        27
;  :       --        --        --        --        --        --        --        R GUI
              .DB   NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL
; :
;-----------------------------------------------------------------------------------------------------------------------
; -:         28        29        2A        2B        2C        2D        2E        2F
;  :       --        --        --        --        --        --        --        APPS
              .DB   NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL
; :
;-----------------------------------------------------------------------------------------------------------------------
; -:         30        31        32        33        34        35        36        37
;  :       --        --        --        --        --        --        --        --
              .DB   NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL
; :
;-----------------------------------------------------------------------------------------------------------------------
; -:         38        39        3A        3B        3C        3D        3E        3F
;  :       --        --        --        --        --        --        --        --
              .DB   NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL
; :
;-----------------------------------------------------------------------------------------------------------------------
; -:         40        41        42        43        44        45        46        47
;  :       --        --        --        --        --        --        --        --
              .DB   NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL
; :
;-----------------------------------------------------------------------------------------------------------------------
; -:         48        49        4A        4B        4C        4D        4E        4F
;  :       --        --        KP /      --        --        --        --        --
              .DB   NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL
; :
;-----------------------------------------------------------------------------------------------------------------------
; -:         50        51        52        53        54        55        56        57
;  :       --        --        --        --        --        --        --        --
              .DB   NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL
; :
;-----------------------------------------------------------------------------------------------------------------------
; -:         58        59        5A        5B        5C        5D        5E        5F
;  :       --        --        KP EN     --        --        --        --        --
              .DB   NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL
; :
;-----------------------------------------------------------------------------------------------------------------------
; -:         60        61        62        63        64        65        66        67
;  :       --        --        --        --        --        --        --        --
              .DB   NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL
; :
;-----------------------------------------------------------------------------------------------------------------------
; -:         68        69        6A        6B        6C        6D        6E        6F
;  :       --        END       --        LEFT      HOME      --        --        --
              .DB   NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL
; :
;-----------------------------------------------------------------------------------------------------------------------
; -:         70        71        72        73        74        75        76        77
;  :       INSERT    DELETE    DOWN      --        RIGHT     UP        --        --
              .DB   NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL
; :
;-----------------------------------------------------------------------------------------------------------------------
; -:         78        79        7A        7B        7C        7D        7E        7F
;  :       --        --        PG DN     --        PRNSCR2   PG UP     --        --
              .DB   NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL,     NULL
; :
;-----------------------------------------------------------------------------------------------------------------------

;***********************************************************************************************************************
;* 150222-02                             SEGA 
;***********************************************************************************************************************

;                   UP        LEFT      RIGHT     DOWN      X         Y         Z         A         B         C
SINCLAIR1:    .DB   KEY_4,    KEY_1,    KEY_2,    KEY_3,    KEY_1,    KEY_2,    KEY_3,    KEY_4,    KEY_0,    KEY_5
SINCLAIR2:    .DB   KEY_9,    KEY_6,    KEY_7,    KEY_8,    KEY_1,    KEY_2,    KEY_3,    KEY_4,    KEY_0,    KEY_0
KEMPSTON:     .DB   KEMP_U,   KEMP_L,   KEMP_R,   KEMP_D,   KEY_1,    KEY_2,    KEY_3,    KEY_4,    KEY_0,    KEMP_F
CURSOR:       .DB   CS+KEY_7, CS+KEY_5, CS+KEY_8, CS+KEY_6, KEY_1,    KEY_2,    KEY_3,    KEY_4,    KEY_0,    KEY_EN
QAOPM:        .DB   KEY_Q,    KEY_O,    KEY_P,    KEY_A,    KEY_1,    KEY_2,    KEY_3,    KEY_4,    KEY_0,    KEY_M
ELITE:        .DB   KEY_S,    KEY_N,    KEY_M,    KEY_X,    KEY_T,    KEY_SP,   KEY_J,    KEY_F,    KEY_SS,   KEY_A
ROW1:         .DB   KEY_1,    KEY_2,    KEY_3,    KEY_4,    KEY_5,    KEY_6,    KEY_7,    KEY_8,    KEY_9,    KEY_0
ROW2:         .DB   KEY_Q,    KEY_W,    KEY_E,    KEY_R,    KEY_T,    KEY_Y,    KEY_U,    KEY_I,    KEY_O,    KEY_P
ROW3:         .DB   KEY_A,    KEY_S,    KEY_D,    KEY_F,    KEY_G,    KEY_H,    KEY_J,    KEY_K,    KEY_L,    KEY_EN
ROW4:         .DB   KEY_CS,   KEY_Z,    KEY_X,    KEY_C,    KEY_V,    KEY_B,    KEY_N,    KEY_M,    KEY_SS,   KEY_SP

