;***********************************************************************************************************************
;*   INTERRUPTS.asm   "SUPER JOYSTICK PORT 2"
;* (C) 2015  
;* 150409-02
;***********************************************************************************************************************
;***********************************************************************************************************************
;* 150224-02                                0
;*                                       SEGA ,      CS  SS
;*                                             PS/2 
;***********************************************************************************************************************
TIM0_COMPA:
        SAVE_SREG                       ;  SREG
        SAVE_TEMP                       ;   temp

;---------------------------------------       PS/2  ------------------------
        mov     temp,ps2_timeout_cnt
        cpi     temp,PS2_TIMEOUT_CNT_STOP ;       PS/2   ?
        breq    Tim0_Sega                 ;  -    SEGA 

        cpi     temp,PS2_TIMEOUT_CNT_MAX  ;       PS/2    ?
        brne    Tim0_04                   ;  -    

        CLEAR_PS2_VARIABLES               ;  
        rjmp    Tim0_Sega                 ;    SEGA 

Tim0_04:
        inc     ps2_timeout_cnt           ;   

;---------------------------------------     SEGA  ---------------------------------------
Tim0_Sega:
        inc     SEGA_cnt                ;     SEGA 
        cpi     SEGA_cnt,9
        brlo    Tim0_05
        rjmp    Tim0_90                 ; ,    9  

Tim0_05:
        cpi     SEGA_cnt,1              ;      1  8
        breq    Tim0_10
        cpi     SEGA_cnt,2
        breq    Tim0_20
        cpi     SEGA_cnt,3
        breq    Tim0_30
        cpi     SEGA_cnt,4
        breq    Tim0_40
        cpi     SEGA_cnt,5
        breq    Tim0_50
        cpi     SEGA_cnt,6
        breq    Tim0_60
        cpi     SEGA_cnt,7
        breq    Tim0_70
        cpi     SEGA_cnt,8
        breq    Tim0_80
        rjmp    Tim0_End

Tim0_10:
        ldi     temp,$FF               ;       "  "
        mov     sega1_byte1,temp
        mov     sega1_byte2,temp
        mov     sega2_byte1,temp
        mov     sega2_byte2,temp

        READ_SEGA1_LEFT                 ;      1
        READ_SEGA1_RIGHT
        READ_SEGA1_DOWN
        READ_SEGA1_UP
        READ_SEGA1_B
        READ_SEGA1_C

        CLR_SEGA_SYN                    ;  0    SEGA 
        rjmp    Tim0_End

Tim0_20:
        READ_SEGA1_A                    ;      1
        READ_SEGA1_START

        SET_SEGA_SYN                    ;  1    SEGA 
        rjmp    Tim0_End

Tim0_30:
        CLR_SEGA_SYN
        rjmp    Tim0_End

Tim0_40:
        SET_SEGA_SYN
        rjmp    Tim0_End

Tim0_50:
        CLR_SEGA_SYN
        rjmp    Tim0_End

Tim0_60:
        SET_SEGA_SYN
        rjmp    Tim0_End

Tim0_70:

        READ_SEGA1_X                    ;      1
        READ_SEGA1_Y
        READ_SEGA1_Z
        READ_SEGA1_SELECT

        ldi     sega_state,READY        ;      SEGA 

        CLR_SEGA_SYN
        rjmp    Tim0_End

Tim0_80:
        SET_SEGA_SYN
        rjmp    Tim0_End

Tim0_90:
        cpi     SEGA_cnt,SEGA_CNT_MAX   ;     -  /
        brne    Tim0_End

        ldi     SEGA_cnt,SEGA_CNT_MIN   ;  ,     SEGA
                                        ;     CS  SS:

        cpi     CS_cnt,CS_CNT_STOP      ;   CS ,  
        breq    Tim0_100

        cpi     CS_cnt,CS_CNT_MAX       ;   CS   ,  
        breq    Tim0_100

        inc     CS_cnt                  ;    - 

Tim0_100:
        cpi     SS_cnt,SS_CNT_STOP      ;   SS ,  
        breq    Tim0_End

        cpi     SS_cnt,SS_CNT_MAX       ;   SS   ,  
        breq    Tim0_End

        inc     SS_cnt                  ;    - 

Tim0_End:
        LOAD_TEMP                       ;   temp
        LOAD_SREG                       ;  SREG
        reti

;***********************************************************************************************************************
;* 150409-02                                INT1    CLK PS/2 
;***********************************************************************************************************************
EXT_INT1:
        SAVE_SREG                       ;  SREG
        SAVE_TEMP                       ;   temp

        inc     ps2_bits_cnt            ;         PS/2 

        mov     temp,ps2_bits_cnt
        cpi     temp,10                 ;  10 (parity)  11 (stop) ?
        brsh    EXT_INT1_100            ;  ->       

        cpi     temp,1                  ;  1 (start)  ?
        breq    EXT_INT1_10             ;  ->    

;-------------------------------------- DATA BIT -----------------------------------------------------------------------

        lsr     ps2_byte                ;    PS/2     0   
        SBIS_PS2_DATA                   ;      0 ?
        rjmp    EXT_INT1_End            ;  ->    

        ldi     temp,0b10000000         ;  -  1     PS/2 
        or      ps2_byte,temp
        inc     ps2_parity_cnt          ;       
        rjmp    EXT_INT1_End

;-------------------------------------- START BIT ----------------------------------------------------------------------
EXT_INT1_10:
        SBIC_PS2_DATA                   ;      0 ?
        rjmp    EXT_INT1_20             ;  ->    

        ldi     temp,0
        mov     ps2_parity_cnt,temp     ;        PS/2 

        ldi     temp,PS2_TIMEOUT_CNT_MIN
        mov     ps2_timeout_cnt,temp    ;        PS/2 
        rjmp    EXT_INT1_End

EXT_INT1_20:
        CLEAR_PS2_VARIABLES             ;     
        rjmp    EXT_INT1_End

;-----------------------------------------------------------------------------------------------------------------------
EXT_INT1_100:                           ; (cpi temp,10)  10 (parity) ?
        brne    EXT_INT1_200            ;  ->     

;-------------------------------------- PARITY BIT ---------------------------------------------------------------------

        SBIC_PS2_DATA                   ;       1
        inc     ps2_parity_cnt          ;      
        sbrc    ps2_parity_cnt,0        ;      1 ?
        rjmp    EXT_INT1_End            ;  ->     

        CLEAR_PS2_VARIABLES             ;  -     
        rjmp    EXT_INT1_End

;-------------------------------------- STOP BIT -----------------------------------------------------------------------
EXT_INT1_200:
        SBIC_PS2_DATA                   ;      1 ?
        rjmp    EXT_INT1_210            ;  ->    -

        CLEAR_PS2_VARIABLES             ;     
        rjmp    EXT_INT1_End

EXT_INT1_210:                           ;  -
        ldi     temp,PS2_TIMEOUT_CNT_STOP
        mov     ps2_timeout_cnt,temp    ;         PS/2 

        ldi     temp,0                  ;         PS/2 
        mov     ps2_bits_cnt,temp

        mov     temp,ps2_byte           ;      PS/2 
        cpi     temp,128                ;   128 ?
        brlo    EXT_INT1_300            ;  ->   . 

;-------------------------------------- -  127 -----------------------------------------------------------

        cpi     temp,$F0                ;   F0 ( ) ?
        brne    EXT_INT1_220
        SET_PS2_F0                      ;   F0
        rjmp    EXT_INT1_End

EXT_INT1_220:
        cpi     temp,$E0                ;   E0 (   E0) ?
        brne    EXT_INT1_230
        SET_PS2_E0                      ;   E0
        rjmp    EXT_INT1_End

EXT_INT1_230:
        cpi     temp,$E1                ;   E1 (   E1) ?
        brne    EXT_INT1_240
        SET_PS2_E0                      ;    E0,     1    PAUSE
        rjmp    EXT_INT1_End

EXT_INT1_240:
        cpi     temp,$83                ;   $83 (F7) -   $02
        brne    EXT_INT1_250
        ldi     temp,$02
        rjmp    EXT_INT1_300            ;     

EXT_INT1_250:
        CLEAR_PS2_VARIABLES             ;    -  
        rjmp    EXT_INT1_End

;-------------------------------------- -  128 ------------------------------------------------------------
EXT_INT1_300:
        SBRC_PS2_E0                     ;   E0  (   )
        ori     temp,0b10000000         ;  1    -
        mov     ps2_byte,temp

        SBRC_PS2_F0                     ;  F0  ( ) ?
        rjmp    EXT_INT1_331            ;  ->      

;--------------------------------------      ---------------------------------------------

                                        ; ,       :

        mov     temp,KEY_CODE1          ;    1  
        cp      temp,ps2_byte           ;    ?
        breq    EXT_INT1_320            ;  ->  

        mov     temp,KEY_CODE2          ;     ...
        cp      temp,ps2_byte
        breq    EXT_INT1_320

        mov     temp,KEY_CODE3
        cp      temp,ps2_byte
        breq    EXT_INT1_320

        mov     temp,KEY_CODE4
        cp      temp,ps2_byte
        breq    EXT_INT1_320
;-----------------------------------------------------------------------------------------------------------------------
                                        ;      -       
EXT_INT1_301:
        mov     temp,KEY_CODE1          ;    1  
        cpi     temp,0                  ;   0 ( ) ?
        brne    EXT_INT1_302            ;  ->    

        mov     KEY_CODE1,ps2_byte      ;  -      
        rjmp    EXT_INT1_320

EXT_INT1_302:
        mov     temp,KEY_CODE2          ;     ...
        cpi     temp,0
        brne    EXT_INT1_303

        mov     KEY_CODE2,ps2_byte
        rjmp    EXT_INT1_320

EXT_INT1_303:
        mov     temp,KEY_CODE3          ;     ...
        cpi     temp,0
        brne    EXT_INT1_304

        mov     KEY_CODE3,ps2_byte
        rjmp    EXT_INT1_320

EXT_INT1_304:
        mov     temp,KEY_CODE4          ;     ...
        cpi     temp,0
        brne    EXT_INT1_310

        mov     KEY_CODE4,ps2_byte
        rjmp    EXT_INT1_320

EXT_INT1_310:
        CLEAR_PS2_VARIABLES             ;       -  
        rjmp    EXT_INT1_End
;-----------------------------------------------------------------------------------------------------------------------
EXT_INT1_320:
        CLR_PS2_E0                      ;      (    . )
        CLR_PS2_F0
        rjmp    EXT_INT1_End

;--------------------------------------      ---------------------------------------------
EXT_INT1_331:
        mov     temp,KEY_CODE1          ;    1  
        cp      temp,ps2_byte           ;    ?
        brne    EXT_INT1_332            ;  ->    

        clr     KEY_CODE1               ;     
        rjmp    EXT_INT1_350

EXT_INT1_332:
        mov     temp,KEY_CODE2
        cp      temp,ps2_byte
        brne    EXT_INT1_333

        clr     KEY_CODE2
        rjmp    EXT_INT1_350

EXT_INT1_333:
        mov     temp,KEY_CODE3
        cp      temp,ps2_byte
        brne    EXT_INT1_334

        clr     KEY_CODE3
        rjmp    EXT_INT1_350

EXT_INT1_334:
        mov     temp,KEY_CODE4
        cp      temp,ps2_byte
        brne    EXT_INT1_340

        clr     KEY_CODE4
        rjmp    EXT_INT1_350

EXT_INT1_340:
        CLEAR_PS2_VARIABLES             ;       -  
        rjmp    EXT_INT1_End

EXT_INT1_350:
        CLR_PS2_E0                      ;      (    . )
        CLR_PS2_F0
        rjmp    EXT_INT1_End

;-----------------------------------------------------------------------------------------------------------------------
EXT_INT1_End:
        LOAD_TEMP                       ;   temp
        LOAD_SREG                       ;  SREG
        reti
