;***********************************************************************************************************************
;*   MACRO.asm   "SUPER JOYSTICK PORT 2"
;* (C) 2015  
;* 150411-01
;***********************************************************************************************************************
.MACRO PRESS                         ;     
 ldi     temp,@0
 rcall   PressKey
.ENDMACRO
;-----------------------------------------------------------------------------------------------------------------------
.MACRO SAVE_SREG                        ;   SREG      
 in      r15,SREG
.ENDMACRO
;-----------------------------------------------------------------------------------------------------------------------
.MACRO LOAD_SREG                        ;   SREG
 out     SREG,r15
.ENDMACRO
;-----------------------------------------------------------------------------------------------------------------------
.MACRO SAVE_TEMP                       ;   temp      
 mov     r14,temp
.ENDMACRO
;-----------------------------------------------------------------------------------------------------------------------
.MACRO LOAD_TEMP                       ;   temp
 mov     temp,r14
.ENDMACRO
;-----------------------------------------------------------------------------------------------------------------------
.MACRO CLEAR_PS2_VARIABLES             ;       PS/2 

 ldi     temp,PS2_TIMEOUT_CNT_STOP
 mov     ps2_timeout_cnt,temp           ;         PS/2 

 ldi     temp,0
 mov     ps2_bits_cnt,temp              ;         PS/2 
 mov     ps2_flags,temp                 ;     PS/2 

 mov     KEY_CODE1,temp                 ;     
 mov     KEY_CODE2,temp
 mov     KEY_CODE3,temp
 mov     KEY_CODE4,temp

.ENDMACRO
;-----------------------------------------------------------------------------------------------------------------------
.MACRO SBIC_PS2_DATA                   ;   ,     PS/2 = 0
 sbic    PIND,2
.ENDMACRO
;-----------------------------------------------------------------------------------------------------------------------
.MACRO SBIS_PS2_DATA                   ;   ,     PS/2 = 1
 sbis    PIND,2
.ENDMACRO
;-----------------------------------------------------------------------------------------------------------------------
.MACRO SET_PS2_E0                      ;     -
 ori      ps2_flags,0b10000000
.ENDMACRO
;-----------------------------------------------------------------------------------------------------------------------
.MACRO CLR_PS2_E0                      ;     -
 andi     ps2_flags,0b01111111
.ENDMACRO
;-----------------------------------------------------------------------------------------------------------------------
.MACRO SET_PS2_F0                      ;    
        ori      ps2_flags,0b00010000
.ENDMACRO
;-----------------------------------------------------------------------------------------------------------------------
.MACRO  CLR_PS2_F0                      ;    
 andi    ps2_flags,0b11101111
.ENDMACRO
;-----------------------------------------------------------------------------------------------------------------------
.MACRO SBRC_PS2_E0                     ;   ,   E0 = 0
 sbrc    ps2_flags,7
.ENDMACRO
;-----------------------------------------------------------------------------------------------------------------------
.MACRO SBRS_PS2_E0                     ;   ,   E0 = 1
 sbrs    ps2_flags,7
.ENDMACRO
;-----------------------------------------------------------------------------------------------------------------------
.MACRO SBRC_PS2_F0                     ;   ,   F0 = 0
 sbrc    ps2_flags,4
.ENDMACRO
;-----------------------------------------------------------------------------------------------------------------------
.MACRO SBRS_PS2_F0                     ;   ,   F0 = 1
 sbrs    ps2_flags,4
.ENDMACRO

;***********************************************************************************************************************
;* 150216-02                                SEGA 
;***********************************************************************************************************************
.MACRO CLR_SEGA_SYN                    ;       0   SEGA 
 cbi     PORTD,4
.ENDMACRO
;-----------------------------------------------------------------------------------------------------------------------
.MACRO SET_SEGA_SYN                    ;   1   SEGA 
 sbi     PORTD,4
.ENDMACRO
;-----------------------------------------------------------------------------------------------------------------------
.MACRO READ_SEGA1_LEFT                 ;             
 ldi     temp,0b11011111
 sbis    PIND,7
 and     sega1_byte1,temp
.ENDMACRO
;-----------------------------------------------------------------------------------------------------------------------
.MACRO READ_SEGA1_RIGHT
 ldi     temp,0b11101111
 sbis    PINB,2
 and     sega1_byte1,temp
.ENDMACRO
;-----------------------------------------------------------------------------------------------------------------------
.MACRO READ_SEGA1_DOWN
 ldi     temp,0b11110111
 sbis    PINB,1
 and     sega1_byte1,temp
.ENDMACRO
;-----------------------------------------------------------------------------------------------------------------------
.MACRO READ_SEGA1_UP
 ldi     temp,0b11111011
 sbis    PINB,0
 and     sega1_byte1,temp
.ENDMACRO
;-----------------------------------------------------------------------------------------------------------------------
.MACRO READ_SEGA1_SELECT
 ldi     temp,0b11111101
 sbis    PINB,2
 and     sega1_byte1,temp
.ENDMACRO
;-----------------------------------------------------------------------------------------------------------------------
.MACRO READ_SEGA1_START
 ldi     temp,0b11111110
 sbis    PIND,6
 and     sega1_byte1,temp
.ENDMACRO
;-----------------------------------------------------------------------------------------------------------------------
.MACRO READ_SEGA1_X
 ldi     temp,0b11011111
 sbis    PIND,7
 and     sega1_byte2,temp
.ENDMACRO
;-----------------------------------------------------------------------------------------------------------------------
.MACRO READ_SEGA1_Y
 ldi     temp,0b11101111
 sbis    PINB,1
 and     sega1_byte2,temp
.ENDMACRO
;-----------------------------------------------------------------------------------------------------------------------
.MACRO READ_SEGA1_Z
 ldi     temp,0b11110111
 sbis    PINB,0
 and     sega1_byte2,temp
.ENDMACRO
;-----------------------------------------------------------------------------------------------------------------------
.MACRO READ_SEGA1_A
 ldi     temp,0b11111011
 sbis    PIND,5
 and     sega1_byte2,temp
.ENDMACRO
;-----------------------------------------------------------------------------------------------------------------------
.MACRO READ_SEGA1_B
 ldi     temp,0b11111101
        sbis    PIND,5
        and     sega1_byte2,temp
.ENDMACRO
;-----------------------------------------------------------------------------------------------------------------------
.MACRO READ_SEGA1_C
 ldi     temp,0b11111110
 sbis    PIND,6
 and     sega1_byte2,temp
.ENDMACRO

;***********************************************************************************************************************
;* 150214-04                                -
;***********************************************************************************************************************
.MACRO INIT_PORTS                      ;    -:

 ldi     temp,0b00111000                ; PORTB:
 out     DDRB,temp
                                        ; PB7 -   -   ()
                                        ; PB6 -   -   ()
                                        ; PB5 -  - REG_SHIFT -      
                                        ; PB4 -  - REG_DATA  -      
                                        ; PB3 -  - REG_LATCH -    
                                        ; PB2 -   - SEGA1_4   - 1 SEGA  4 
                                        ; PB1 -   - SEGA1_2   - 1 SEGA  2 
                                        ; PB0 -   - SEGA1_1   - 1 SEGA  1 

 ldi     temp,0b00000000                ; PORTC:
 out     DDRC,temp
                                        ; PC7 -   - 
                                        ; PC6 -   -   (RESET)
                                        ; PC5 -   - SEGA2_6   - 2 SEGA  6 
                                        ; PC4 -   - SEGA2_2   - 2 SEGA  2 
                                        ; PC3 -   - SEGA2_1   - 2 SEGA  1 
                                        ; PC2 -   - SEGA2_3   - 2 SEGA  3 
                                        ; PC1 -   - SEGA2_4   - 2 SEGA  4 
                                        ; PC0 -   - SEGA2_9   - 2 SEGA  9 

 ldi     temp,0b00010010         ; PORTD:
 out     DDRD,temp
                                        ; PD7 -   - SEGA1_3   - 1 SEGA  3 
                                        ; PD6 -   - SEGA1_9   - 1 SEGA  9 
                                        ; PD5 -   - SEGA1_6   - 1 SEGA  6 
                                        ; PD4 -  - SEGA12_7  - 1  2 SEGA  7  - 
                                        ; PD3 -   - KEYB_CLK  -  PS2 ,     !!!
                                        ; PD2 -   - KEYB_DATA -    PS2 ,     !!!
                                        ; PD1 -  - TX - ,   UART
                                        ; PD0 -   - RX - ,     UART
.ENDMACRO

;***********************************************************************************************************************
;* 150214-02                                   
;***********************************************************************************************************************

.MACRO CLR_REG_DATA                    ;       0     
 cbi     PORTB,4
.ENDMACRO
;-----------------------------------------------------------------------------------------------------------------------
.MACRO SET_REG_DATA                    ;   1     
 sbi     PORTB,4
.ENDMACRO
;-----------------------------------------------------------------------------------------------------------------------
.MACRO CLR_REG_SHIFT                   ;       0     
 cbi     PORTB,5
.ENDMACRO
;-----------------------------------------------------------------------------------------------------------------------
.MACRO SET_REG_SHIFT                   ;   1     
 sbi     PORTB,5
.ENDMACRO
;-----------------------------------------------------------------------------------------------------------------------
.MACRO CLR_REG_LATCH                   ;       0     
 cbi     PORTB,3
.ENDMACRO
;-----------------------------------------------------------------------------------------------------------------------
.MACRO SET_REG_LATCH                   ;   1     
 sbi     PORTB,3
.ENDMACRO
;-----------------------------------------------------------------------------------------------------------------------
.MACRO SHIFT_KEY_TO_REGS               ;         
 cbi     PORTB,4                 ; CLR_REG_DATA  ;       = 0

 ld      temp,y+                 ;      ,    
 sbrc    temp,0                  ;      -     ?

 sbi     PORTB,4                 ; SET_REG_DATA  ;   -        1

 sbi     PORTB,5                 ; SET_REG_SHIFT ;      
 cbi     PORTB,5                 ; CLR_REG_SHIFT
.ENDMACRO
;-----------------------------------------------------------------------------------------------------------------------
.MACRO SHIFT_REGS                      ;   
 sbi     PORTB,5                 ; SET_REG_SHIFT
 cbi     PORTB,5                 ; CLR_REG_SHIFT
.ENDMACRO
;-----------------------------------------------------------------------------------------------------------------------
.MACRO LATCH_REGS                      ;         
 sbi     PORTB,3                 ; SET_REG_LATCH
 cbi     PORTB,3                 ; CLR_REG_LATCH
.ENDMACRO

;***********************************************************************************************************************





