;***********************************************************************************************************************
;*   PROCESS_KEY.asm   "SUPER JOYSTICK PORT 2"
;* (C) 2015  
;*
;* 150419-01
;***********************************************************************************************************************

;***********************************************************************************************************************
;* 150419-01                             -   
;                                       : tmp,  -  Z=1,  
;***********************************************************************************************************************
FindScanCode:

 cp      temp,KEY_CODE1
 breq    FindScanCode_End

 cp      temp,KEY_CODE2
 breq    FindScanCode_End

 cp      temp,KEY_CODE3
 breq    FindScanCode_End

 cp      temp,KEY_CODE4

FindScanCode_End:

         ret

;***********************************************************************************************************************
;* 150419-01                               -  ?
;                                        -  Z=1,  
;***********************************************************************************************************************
CheckKeyBufEmpty:

 ldi     temp,0

 cp      temp,KEY_CODE1
 brne    CheckKeyBufEmpty_End

 cp      temp,KEY_CODE2
 brne    CheckKeyBufEmpty_End

 cp      temp,KEY_CODE3
 brne    CheckKeyBufEmpty_End

 cp      temp,KEY_CODE4

CheckKeyBufEmpty_End:

         ret

;***********************************************************************************************************************
;* 150419-01                                
;***********************************************************************************************************************
ProcessKeyBuf:


 ldi     temp,L_SHIFT                   ; ,      ?
 rcall   FindScanCode
 breq    ProcessKeyBuf_10

 ldi     temp,R_SHIFT
 rcall   FindScanCode
 breq    ProcessKeyBuf_10

 ldi     zh,high(PS2_KEYBOARD_TABLE*2)  ;    -       FLASH  
 rjmp    ProcessKeyBuf_20

ProcessKeyBuf_10:

 ldi     zh,high(PS2_KEYBOARD_TABLE2*2) ;   -       FLASH  

ProcessKeyBuf_20:

 mov     temp,KEY_CODE1                 ;    1  
 cpi     temp,0                         ;   0 ( ) ?
 breq    PKB_02                         ;  ->  

 mov     zl,temp                        ;      
 lpm     temp,z                         ;     
 rcall   ProcessKey                     ;     

PKB_02:
 mov     temp,KEY_CODE2
 cpi     temp,0
 breq    PKB_03

 mov     zl,temp
 lpm     temp,z
 rcall   ProcessKey

PKB_03:
 mov     temp,KEY_CODE3
 cpi     temp,0
 breq    PKB_04

 mov     zl,temp
 lpm     temp,z
 rcall   ProcessKey

PKB_04:
 mov     temp,KEY_CODE4
 cpi     temp,0
 breq    PKB_10

 mov     zl,temp
 lpm     temp,z
 rcall   ProcessKey

PKB_10:
 ret

;***********************************************************************************************************************
;* 150411-01                               
;***********************************************************************************************************************
PressKey:
 push    temp
 cpi     temp,64                        ;      CS  SS ?
 brlo    PressKey10                     ;  -      

                                        ;    CS  SS   :
 rcall   ClearOutBuf                    ;   ,     
 pop     temp
 push    temp
 rcall   ProcessKey                     ;    
 rcall   ProcessCSSS                    ;   CS  SS
 rcall   OutBufToRegs                   ;      ZX SPECTRUM     
 rcall   Delay100mS                     ;     0.1 

PressKey10:
 rcall   ClearOutBuf                    ;   ,     
 pop     temp
 rcall   ProcessKey                     ;    
 rcall   ProcessCSSS                    ;   CS  SS
 rcall   OutBufToRegs                   ;      ZX SPECTRUM     
 rcall   Delay100mS                     ;     0.1 
 ret

;***********************************************************************************************************************
;* 150411-01                                  SEGA 
;*
;*                                      :  temp =    PS/2   SEGA 
;*                                             xh   =     
;*                                      :        
;***********************************************************************************************************************
ProcessKey:
        sbrc    temp,BIT_CS
        rjmp    ProcessKey_CS           ; ,      CS

        sbrc    temp,BIT_SS
        rjmp    ProcessKey_SS           ; ,      SS

        mov     xl,temp                 ;        
        ldi     temp,PRESS              ;        ,    
        st      x,temp
        ret

ProcessKey_CS:
        sbrc    temp,BIT_SS
        rjmp    ProcessKey_EXT          ;     ,  : CS  SS

        sbr     csss_flags,CS           ;     CS
        cpi     CS_cnt,CS_CNT_MAX       ;     CS   ,
        brne    ProcessKey_End          ;  c CS  

        cbr     temp,CS                 ;   -  ,     CS
        rjmp    ProcessKey_100

ProcessKey_SS:
        sbr     csss_flags,SS           ;     SS
        cpi     SS_cnt,SS_CNT_MAX       ;     SS   ,
        brne    ProcessKey_End          ;  c SS  

        cbr     temp,SS                 ;   -  ,     SS
        rjmp    ProcessKey_100

ProcessKey_EXT:
        cbr     temp,COM                ;   D7, D6
        rcall   CommandSelector         ;     
        rjmp    ProcessKey_End

ProcessKey_100:
        mov     xl,temp                 ;        
        ldi     temp,PRESS              ;        ,    
        st      x,temp

ProcessKey_End:
        ret

;***********************************************************************************************************************
;* 150225-02                               CS  SS
;***********************************************************************************************************************
ProcessCSSS:
        sbrc    csss_flags,BIT_CS
        rjmp    ProcessCSSS_10          ; ,   CS 

        ldi     CS_cnt,CS_CNT_STOP      ;  -    CS
        rjmp    ProcessCSSS_30          ;    SS

ProcessCSSS_10:
        cpi     CS_cnt,CS_CNT_STOP      ;    CS  
        brne    ProcessCSSS_20

        ldi     CS_cnt,CS_CNT_MIN       ;  

ProcessCSSS_20:
        ldi     xl,KEY_CS               ;    CS      
        ldi     temp,PRESS              ;        ,    
        st      x,temp

ProcessCSSS_30:
        sbrc    csss_flags,BIT_SS
        rjmp    ProcessCSSS_40          ; ,   SS 

        ldi     SS_cnt,SS_CNT_STOP      ;  -    SS
        rjmp    ProcessCSSS_End

ProcessCSSS_40:
        cpi     SS_cnt,SS_CNT_STOP      ;    SS  
        brne    ProcessCSSS_50

        ldi     SS_cnt,SS_CNT_MIN       ;  

ProcessCSSS_50:
        ldi     xl,KEY_SS               ;    SS      
        ldi     temp,PRESS              ;        ,    
        st      x,temp

ProcessCSSS_End:
       ret

;***********************************************************************************************************************
