;===     UART-to-USB    ==================
; EMT 40 -   UART -    R0.
;   ,   .
;  R0=3  / =19200 .
;  0011()    :
; R0=0 = 9600 , R0=1 = 4800 , R0=2 =2400 ...
;
.LA 117462
;117462:
	 ASL R0
	 MOV S0(R0),@#254	;   UART
;   @#254    
;    
;117472:
	 RET
;
; EMT 42 -     UART (PUTBYT)
;  R0     
;
;.LA 117474
;117474:
PUTBYT:	MOV  R0,-(SP)
	MOV  R4,-(SP)
	BIS  #400,R0		; 8-N-1,  #1400 => 8-N-2
	MOV  #10.,R4		; 8-N-1,  #11.  8-N-2
;Z17510: BIT  #200,@#177714	;   
;	 BNE  Z17510		;   UART  
				;   
	CLC
	BR   Z17526
Z17524:	ASR  R0
Z17526:	BCS  Z17540		;  BCC -  
	MOV  #20,@#177714
	BR   Z17550
Z17540:	MOV  #0,@#177714
	BR   Z17550
Z17550:	MOV  @#254,R5    
;
;   @#254    
;     /, :
; 40 => 4800  ( 0011 @ 4MHz)
; 15 => 9600  ( 0011 @ 4MHz)
;  2 => 19200  ( 0011 @ 4MHz)
;
Z17554:	SOB  R5,Z17554
	SOB  R4,Z17524
	MOV  (SP)+,R4
	BR   I17716
;	MOV  (SP)+,R0
;	RET
;
S0:	 .WORD 14		; 9600   0010
S1:	 .WORD 36		; 4800   0010
S2:	 .WORD 103		; 2400   0010
S3:	 .WORD 213		; 1200   0010
S4:	 .WORD 435		;  600   0010
;
; EMT 44 -     UART (GETBYT)
;  R0  ,   UART
;
;.LA 117566
GETBYT: ;    UART-
;117566:
	  MOV  R4,-(SP)
	  MOV  R3,-(SP)
;
	  CALL GETBY1   
;
EXIT44:	  MOV  (SP)+,R3
	  MOV  (SP)+,R4
	  RET
;
GETBY1:	  MTPS #0
	  MOV  #177714,R3	;   
	  MOV  #200,R4		;    
	  CLR  R0		;    
GETBY2: 
I17620:	BIT  R4,(R3)		;  -
	BEQ  I17620		;  BNE,  
	MTPS #200  ;      
GETBY3: MOV  R2,-(SP)
	MOV  #10,R2		;   = 8. 
I17630: MOV  @#254,R5
;
;   @#254     
;     /, :
; 40 => 4800  ( 0011 @ 4MHz)
; 15 => 9600  ( 0011 @ 4MHz)
;  2 => 19200  ( 0011 @ 4MHz)
;
	ASR  R5			;   
I17636: SOB  R5,I17636		;   -
I17642:	MOV  @#254,R5
	BR   I17646		; .   19200 
I17646:	SOB  R5,I17646	    ;    . 
	BIT  R4,(R3)		;  
	BEQ  I17662		;  BNE,  
	CLC  
	BR   I17666
I17662: SEC
	BR   I17666
I17666: RORB R0	       ;     . 
	SOB  R2,I17642 ;   
	MOV  (SP)+,R2
	RET
;
; EMT 46 -     (R1-    R2-   )
;
;.LA 117704
I17704: MOV R0,-(SP)
I17706: MOVB (R1)+,R0
I17710: CALL PUTBYT	;    
I17714: SOB R2,I17706	;    (117706-117714)
I17716: MOV (SP)+,R0
I17720: RET
;
; EMT 50 -     (R1-      R2=0)
;
;.LA 117722
;117722
EMT050:	  MOV  R4,-(SP)
	  MOV  R3,-(SP)
	  MOV  R0,-(SP)
	  CALL GETBY1		;  1-   , 
	  DEC R2
I17730:	  BEQ R2EQ01		;   =1.
NEXBYT:	  MOVB R0,(R1)+
	  CALL GETBY2		;     
	  SOB  R2,NEXBYT	;   
R2EQ01:   MOVB R0,(R1)+
	  MOV  (SP)+,R0
	  BR   EXIT44		
;	  /  0011 @ 4MHz
S19200:	 .WORD 2		; 19200 
S9600:	 .WORD 15		;  9600 
S4800:	 .WORD 40		;  4800 
S2400:	 .WORD 110		;  2400 
	 .END
===    0010 ================================
