//
//  psg.h
//
//  AY-3-8910/12 Emulation
//
//  Created by Alexander Medvedev on 05/06/14.
//  Copyright (c) 2014 Alexander Medvedev. All rights reserved.
//

#ifndef ay8910_h
#define ay8910_h

// AY-3-8910 State

#define PSGDUMP

typedef struct {
    
    byte    R[16];
    
    int     Counter[5];   // ABC + Noise + Envelope
    int     Divider[5];
    
    int     Bit[4];       // ABC + Noise
    
    int     Envelope;     // Envelope volume
    int     EnvelopeStep; // Envelope tick (0..31)
    int     EnvelopeMode; // Envelope shape

    // Stuff
    
    byte *  OutputA;
    byte *  OutputB;
    byte *  OutputC;
    
    int     Fill;
    int     Ready;
    int     Samples;
    
    int     Mix[2][3];
    
    int     DebugInfo;
    char *  DebugName;
    
} ay8910state;

void ay8910init(ay8910state * ay8910, int samples);
void ay8910done(ay8910state * ay8910);

void ay8910write(ay8910state * ay8910, int addr, byte data);
byte ay8910read(ay8910state * ay8910, int addr);

void ay8910render(ay8910state * ay8910, int N);
void ay8910mix(ay8910state * ay8910, short audio[][2], int divider);

#endif
